/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util;

import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;

public final class StringEscapeUtils {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String U2028 = "\\u2028";
    private static final String U2029 = "\\u2029";

    public static String escapeJson(@Nullable String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = REPLACEMENT_CHARS[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = U2028;
            } else {
                if (c2 != '\u2029') continue;
                string2 = U2029;
            }
            if (n3 < i2) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                }
                stringBuilder.append(string, n3, i2);
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n2);
            }
            stringBuilder.append(string2);
            n3 = i2 + 1;
        }
        if (stringBuilder == null) {
            return string;
        }
        if (n3 < n2) {
            stringBuilder.append(string, n3, n2);
        }
        return stringBuilder.toString();
    }

    private StringEscapeUtils() {
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            StringEscapeUtils.REPLACEMENT_CHARS[i2] = String.format("\\u%04x", i2);
        }
        StringEscapeUtils.REPLACEMENT_CHARS[34] = "\\\"";
        StringEscapeUtils.REPLACEMENT_CHARS[92] = "\\\\";
        StringEscapeUtils.REPLACEMENT_CHARS[9] = "\\t";
        StringEscapeUtils.REPLACEMENT_CHARS[8] = "\\b";
        StringEscapeUtils.REPLACEMENT_CHARS[10] = "\\n";
        StringEscapeUtils.REPLACEMENT_CHARS[13] = "\\r";
        StringEscapeUtils.REPLACEMENT_CHARS[12] = "\\f";
    }
}

