/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.Bitset;
import com.contrastsecurity.thirdparty.jregex.PatternSyntaxException;
import com.contrastsecurity.thirdparty.jregex.Term;
import com.contrastsecurity.thirdparty.jregex.UnicodeConstants;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class CharacterClass
extends Term
implements UnicodeConstants {
    static final Bitset DIGIT = new Bitset();
    static final Bitset WORDCHAR = new Bitset();
    static final Bitset SPACE = new Bitset();
    static final Bitset UDIGIT = new Bitset();
    static final Bitset UWORDCHAR = new Bitset();
    static final Bitset USPACE = new Bitset();
    static final Bitset NONDIGIT = new Bitset();
    static final Bitset NONWORDCHAR = new Bitset();
    static final Bitset NONSPACE = new Bitset();
    static final Bitset UNONDIGIT = new Bitset();
    static final Bitset UNONWORDCHAR = new Bitset();
    static final Bitset UNONSPACE = new Bitset();
    private static boolean namesInitialized = false;
    static final Hashtable namedClasses = new Hashtable();
    static final Vector unicodeBlocks = new Vector();
    static final Vector posixClasses = new Vector();
    static final Vector unicodeCategories = new Vector();
    private static final int ADD = 1;
    private static final int SUBTRACT = 2;
    private static final int INTERSECT = 3;
    private static final String blockData = "0000..007F:InBasicLatin;0080..00FF:InLatin-1Supplement;0100..017F:InLatinExtended-A;0180..024F:InLatinExtended-B;0250..02AF:InIPAExtensions;02B0..02FF:InSpacingModifierLetters;0300..036F:InCombiningDiacriticalMarks;0370..03FF:InGreek;0400..04FF:InCyrillic;0530..058F:InArmenian;0590..05FF:InHebrew;0600..06FF:InArabic;0700..074F:InSyriac;0780..07BF:InThaana;0900..097F:InDevanagari;0980..09FF:InBengali;0A00..0A7F:InGurmukhi;0A80..0AFF:InGujarati;0B00..0B7F:InOriya;0B80..0BFF:InTamil;0C00..0C7F:InTelugu;0C80..0CFF:InKannada;0D00..0D7F:InMalayalam;0D80..0DFF:InSinhala;0E00..0E7F:InThai;0E80..0EFF:InLao;0F00..0FFF:InTibetan;1000..109F:InMyanmar;10A0..10FF:InGeorgian;1100..11FF:InHangulJamo;1200..137F:InEthiopic;13A0..13FF:InCherokee;1400..167F:InUnifiedCanadianAboriginalSyllabics;1680..169F:InOgham;16A0..16FF:InRunic;1780..17FF:InKhmer;1800..18AF:InMongolian;1E00..1EFF:InLatinExtendedAdditional;1F00..1FFF:InGreekExtended;2000..206F:InGeneralPunctuation;2070..209F:InSuperscriptsAndSubscripts;20A0..20CF:InCurrencySymbols;20D0..20FF:InCombiningMarksForSymbols;2100..214F:InLetterLikeSymbols;2150..218F:InNumberForms;2190..21FF:InArrows;2200..22FF:InMathematicalOperators;2300..23FF:InMiscellaneousTechnical;2400..243F:InControlPictures;2440..245F:InOpticalCharacterRecognition;2460..24FF:InEnclosedAlphanumerics;2500..257F:InBoxDrawing;2580..259F:InBlockElements;25A0..25FF:InGeometricShapes;2600..26FF:InMiscellaneousSymbols;2700..27BF:InDingbats;2800..28FF:InBraillePatterns;2E80..2EFF:InCJKRadicalsSupplement;2F00..2FDF:InKangxiRadicals;2FF0..2FFF:InIdeographicDescriptionCharacters;3000..303F:InCJKSymbolsAndPunctuation;3040..309F:InHiragana;30A0..30FF:InKatakana;3100..312F:InBopomofo;3130..318F:InHangulCompatibilityJamo;3190..319F:InKanbun;31A0..31BF:InBopomofoExtended;3200..32FF:InEnclosedCJKLettersAndMonths;3300..33FF:InCJKCompatibility;3400..4DB5:InCJKUnifiedIdeographsExtensionA;4E00..9FFF:InCJKUnifiedIdeographs;A000..A48F:InYiSyllables;A490..A4CF:InYiRadicals;AC00..D7A3:InHangulSyllables;D800..DB7F:InHighSurrogates;DB80..DBFF:InHighPrivateUseSurrogates;DC00..DFFF:InLowSurrogates;E000..F8FF:InPrivateUse;F900..FAFF:InCJKCompatibilityIdeographs;FB00..FB4F:InAlphabeticPresentationForms;FB50..FDFF:InArabicPresentationForms-A;FE20..FE2F:InCombiningHalfMarks;FE30..FE4F:InCJKCompatibilityForms;FE50..FE6F:InSmallFormVariants;FE70..FEFE:InArabicPresentationForms-B;FEFF..FEFF:InSpecials;FF00..FFEF:InHalfWidthAndFullWidthForms;FFF0..FFFD:InSpecials";

    CharacterClass() {
    }

    private static void registerClass(String string, Bitset bitset, Vector vector) {
        namedClasses.put(string, bitset);
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private static void initPosixClasses() {
        Bitset bitset = new Bitset();
        bitset.setRange('a', 'z');
        CharacterClass.registerClass("Lower", bitset, posixClasses);
        Bitset bitset2 = new Bitset();
        bitset2.setRange('A', 'Z');
        CharacterClass.registerClass("Upper", bitset2, posixClasses);
        Bitset bitset3 = new Bitset();
        bitset3.setRange('\u0000', '\u007f');
        CharacterClass.registerClass("ASCII", bitset3, posixClasses);
        Bitset bitset4 = new Bitset();
        bitset4.add(bitset);
        bitset4.add(bitset2);
        CharacterClass.registerClass("Alpha", bitset4, posixClasses);
        Bitset bitset5 = new Bitset();
        bitset5.setRange('0', '9');
        CharacterClass.registerClass("Digit", bitset5, posixClasses);
        Bitset bitset6 = new Bitset();
        bitset6.add(bitset4);
        bitset6.add(bitset5);
        CharacterClass.registerClass("Alnum", bitset6, posixClasses);
        Bitset bitset7 = new Bitset();
        bitset7.setChars("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~");
        CharacterClass.registerClass("Punct", bitset7, posixClasses);
        Bitset bitset8 = new Bitset();
        bitset8.add(bitset6);
        bitset8.add(bitset7);
        CharacterClass.registerClass("Graph", bitset8, posixClasses);
        CharacterClass.registerClass("Print", bitset8, posixClasses);
        Bitset bitset9 = new Bitset();
        bitset9.setChars(" \t");
        CharacterClass.registerClass("Blank", bitset9, posixClasses);
        Bitset bitset10 = new Bitset();
        bitset10.setRange('\u0000', '\u001f');
        bitset10.setChar('\u007f');
        CharacterClass.registerClass("Cntrl", bitset10, posixClasses);
        Bitset bitset11 = new Bitset();
        bitset11.setRange('0', '9');
        bitset11.setRange('a', 'f');
        bitset11.setRange('A', 'F');
        CharacterClass.registerClass("XDigit", bitset11, posixClasses);
        Bitset bitset12 = new Bitset();
        bitset12.setChars(" \t\n\r\f\u000b");
        CharacterClass.registerClass("Space", bitset12, posixClasses);
    }

    private static void initNames() {
        CharacterClass.initNamedCategory("C", new int[]{0, 15, 16, 18, 19});
        CharacterClass.initNamedCategory("Cn", 0);
        CharacterClass.initNamedCategory("Cc", 15);
        CharacterClass.initNamedCategory("Cf", 16);
        CharacterClass.initNamedCategory("Co", 18);
        CharacterClass.initNamedCategory("Cs", 19);
        CharacterClass.initNamedCategory("L", new int[]{1, 2, 3, 4, 5});
        CharacterClass.initNamedCategory("Lu", 1);
        CharacterClass.initNamedCategory("Ll", 2);
        CharacterClass.initNamedCategory("Lt", 3);
        CharacterClass.initNamedCategory("Lm", 4);
        CharacterClass.initNamedCategory("Lo", 5);
        CharacterClass.initNamedCategory("M", new int[]{6, 7, 8});
        CharacterClass.initNamedCategory("Mn", 6);
        CharacterClass.initNamedCategory("Me", 7);
        CharacterClass.initNamedCategory("Mc", 8);
        CharacterClass.initNamedCategory("N", new int[]{9, 10, 11});
        CharacterClass.initNamedCategory("Nd", 9);
        CharacterClass.initNamedCategory("Nl", 10);
        CharacterClass.initNamedCategory("No", 11);
        CharacterClass.initNamedCategory("Z", new int[]{12, 13, 14});
        CharacterClass.initNamedCategory("Zs", 12);
        CharacterClass.initNamedCategory("Zl", 13);
        CharacterClass.initNamedCategory("Zp", 14);
        CharacterClass.initNamedCategory("P", new int[]{20, 21, 21, 22, 22, 23, 24});
        CharacterClass.initNamedCategory("Pd", 20);
        CharacterClass.initNamedCategory("Ps", 21);
        CharacterClass.initNamedCategory("Pi", 21);
        CharacterClass.initNamedCategory("Pe", 22);
        CharacterClass.initNamedCategory("Pf", 22);
        CharacterClass.initNamedCategory("Pc", 23);
        CharacterClass.initNamedCategory("Po", 24);
        CharacterClass.initNamedCategory("S", new int[]{25, 26, 27, 28});
        CharacterClass.initNamedCategory("Sm", 25);
        CharacterClass.initNamedCategory("Sc", 26);
        CharacterClass.initNamedCategory("Sk", 27);
        CharacterClass.initNamedCategory("So", 28);
        Bitset bitset = new Bitset();
        bitset.setCategory(0);
        CharacterClass.registerClass("UNASSIGNED", bitset, unicodeCategories);
        bitset = new Bitset();
        bitset.setCategory(0);
        bitset.setPositive(false);
        CharacterClass.registerClass("ASSIGNED", bitset, unicodeCategories);
        StringTokenizer stringTokenizer = new StringTokenizer(blockData, ".,:;");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                String string = stringTokenizer.nextToken();
                CharacterClass.initNamedBlock(string, n2, n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        CharacterClass.initNamedBlock("ALL", 0, 65535);
        namesInitialized = true;
    }

    private static void initNamedBlock(String string, int n2, int n3) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("wrong start code (" + n2 + ") in block " + string);
        }
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("wrong end code (" + n3 + ") in block " + string);
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("end code < start code in block " + string);
        }
        Bitset bitset = (Bitset)namedClasses.get(string);
        if (bitset == null) {
            bitset = new Bitset();
            CharacterClass.registerClass(string, bitset, unicodeBlocks);
        }
        bitset.setRange((char)n2, (char)n3);
    }

    private static void initNamedCategory(String string, int n2) {
        Bitset bitset = new Bitset();
        bitset.setCategory(n2);
        CharacterClass.registerClass(string, bitset, unicodeCategories);
    }

    private static void initNamedCategory(String string, int[] nArray) {
        Bitset bitset = new Bitset();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            bitset.setCategory(nArray[i2]);
        }
        namedClasses.put(string, bitset);
    }

    private static Bitset getNamedClass(String string) {
        if (!namesInitialized) {
            CharacterClass.initNames();
        }
        return (Bitset)namedClasses.get(string);
    }

    static void makeICase(Term term, char c2) {
        Bitset bitset = new Bitset();
        bitset.setChar(Character.toLowerCase(c2));
        bitset.setChar(Character.toUpperCase(c2));
        bitset.setChar(Character.toTitleCase(c2));
        Bitset.unify(bitset, term);
    }

    static void makeDigit(Term term, boolean bl, boolean bl2) {
        Bitset bitset = bl2 ? (bl ? UNONDIGIT : UDIGIT) : (bl ? NONDIGIT : DIGIT);
        Bitset.unify(bitset, term);
    }

    static void makeSpace(Term term, boolean bl, boolean bl2) {
        Bitset bitset = bl2 ? (bl ? UNONSPACE : USPACE) : (bl ? NONSPACE : SPACE);
        Bitset.unify(bitset, term);
    }

    static void makeWordChar(Term term, boolean bl, boolean bl2) {
        Bitset bitset = bl2 ? (bl ? UNONWORDCHAR : UWORDCHAR) : (bl ? NONWORDCHAR : WORDCHAR);
        Bitset.unify(bitset, term);
    }

    static void makeWordBoundary(Term term, boolean bl, boolean bl2) {
        CharacterClass.makeWordChar(term, bl, bl2);
        term.type = bl2 ? 13 : 11;
    }

    static void makeWordStart(Term term, boolean bl) {
        CharacterClass.makeWordChar(term, false, bl);
        term.type = bl ? 14 : 12;
    }

    static void makeWordEnd(Term term, boolean bl) {
        CharacterClass.makeWordChar(term, true, bl);
        term.type = bl ? 14 : 12;
    }

    static final void parseGroup(char[] cArray, int n2, int n3, Term term, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        Bitset bitset = new Bitset();
        Bitset bitset2 = new Bitset();
        int n4 = 1;
        block12: while (n2 < n3) {
            char c2 = cArray[n2++];
            switch (c2) {
                case '+': {
                    n4 = 1;
                    continue block12;
                }
                case '-': {
                    n4 = 2;
                    continue block12;
                }
                case '&': {
                    n4 = 3;
                    continue block12;
                }
                case '[': {
                    bitset2.reset();
                    n2 = CharacterClass.parseClass(cArray, n2, n3, bitset2, bl, bl2, bl3, bl4);
                    switch (n4) {
                        case 1: {
                            bitset.add(bitset2);
                            break;
                        }
                        case 2: {
                            bitset.subtract(bitset2);
                            break;
                        }
                        case 3: {
                            bitset.intersect(bitset2);
                        }
                    }
                    continue block12;
                }
                case ')': {
                    throw new PatternSyntaxException("unbalanced class group");
                }
            }
        }
        Bitset.unify(bitset, term);
    }

    static final int parseClass(char[] cArray, int n2, int n3, Term term, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        Bitset bitset = new Bitset();
        n2 = CharacterClass.parseClass(cArray, n2, n3, bitset, bl, bl2, bl3, bl4);
        Bitset.unify(bitset, term);
        return n2;
    }

    static final int parseName(char[] cArray, int n2, int n3, Term term, boolean bl, boolean bl2) throws PatternSyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        n2 = CharacterClass.parseName(cArray, n2, n3, stringBuffer, bl2);
        Bitset bitset = CharacterClass.getNamedClass(stringBuffer.toString());
        if (bitset == null) {
            throw new PatternSyntaxException("unknow class: {" + stringBuffer + "}");
        }
        Bitset.unify(bitset, term);
        term.inverse = bl;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final int parseClass(char[] cArray, int n2, int n3, Bitset bitset, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        int n4 = -1;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        Bitset bitset2 = null;
        StringBuffer stringBuffer = null;
        while (n2 < n3) {
            block64: {
                char c2;
                char c3 = cArray[n2++];
                block0 : switch (c3) {
                    case ']': {
                        if (bl5) break;
                        if (bl7) {
                            bitset.setChar('-');
                        }
                        if (c2 < '\u0000') return n2;
                        char c4 = c2;
                        if (bl) {
                            bitset.setChar(Character.toLowerCase(c4));
                            bitset.setChar(Character.toUpperCase(c4));
                            bitset.setChar(Character.toTitleCase(c4));
                            return n2;
                        }
                        bitset.setChar(c4);
                        return n2;
                    }
                    case '-': {
                        if (bl5 || bl7) break;
                        bl7 = true;
                        break block64;
                    }
                    case '[': {
                        if (!bl7 || !bl4) break;
                        if (c2 >= '\u0000') {
                            bitset.setChar(c2);
                        }
                        if (bitset2 == null) {
                            bitset2 = new Bitset();
                        } else {
                            bitset2.reset();
                        }
                        n2 = CharacterClass.parseClass(cArray, n2, n3, bitset2, bl, bl2, bl3, bl4);
                        bitset.subtract(bitset2);
                        bl7 = false;
                        c2 = '\uffffffff';
                        break block64;
                    }
                    case '^': {
                        if (!bl5) break;
                        bitset.setPositive(false);
                        bl6 = true;
                        break block64;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (!bl2) break;
                        break block64;
                    }
                    case '\\': {
                        Bitset bitset3 = null;
                        boolean bl8 = false;
                        c3 = cArray[n2++];
                        switch (c3) {
                            case 'r': {
                                c3 = '\r';
                                break block0;
                            }
                            case 'n': {
                                c3 = '\n';
                                break block0;
                            }
                            case 't': {
                                c3 = '\t';
                                break block0;
                            }
                            case 'f': {
                                c3 = '\f';
                                break block0;
                            }
                            case 'u': {
                                if (n2 >= n3 - 4) {
                                    throw new PatternSyntaxException("incomplete escape sequence \\uXXXX");
                                }
                                c3 = (char)((CharacterClass.toHexDigit(c3) << 12) + (CharacterClass.toHexDigit(cArray[n2++]) << 8) + (CharacterClass.toHexDigit(cArray[n2++]) << 4) + CharacterClass.toHexDigit(cArray[n2++]));
                                break block0;
                            }
                            case 'v': {
                                c3 = (char)((CharacterClass.toHexDigit(c3) << 24) + (CharacterClass.toHexDigit(cArray[n2++]) << 16) + (CharacterClass.toHexDigit(cArray[n2++]) << 12) + (CharacterClass.toHexDigit(cArray[n2++]) << 8) + (CharacterClass.toHexDigit(cArray[n2++]) << 4) + CharacterClass.toHexDigit(cArray[n2++]));
                                break block0;
                            }
                            case 'b': {
                                c3 = '\b';
                                break block0;
                            }
                            case 'x': {
                                int n5 = 0;
                                int n6 = cArray[n2++];
                                if (n6 == 123) {
                                    while ((n6 = cArray[n2++]) != 125) {
                                        n5 = (n5 << 4) + CharacterClass.toHexDigit((char)n6);
                                    }
                                    if (n5 > 65535) {
                                        throw new PatternSyntaxException("\\x{<out of range>}");
                                    }
                                } else {
                                    n5 = (CharacterClass.toHexDigit((char)n6) << 4) + CharacterClass.toHexDigit(cArray[n2++]);
                                }
                                c3 = (char)n5;
                                break block0;
                            }
                            case 'o': {
                                int n6;
                                int n7 = 0;
                                while ((n6 = cArray[n2++]) >= 48 && n6 <= 55) {
                                    n7 *= 8;
                                    if ((n7 += n6 - 48) <= 65535) continue;
                                }
                                c3 = (char)n7;
                                break block0;
                            }
                            case 'm': {
                                char c5;
                                int n6 = 0;
                                while ((c5 = cArray[n2++]) >= '0' && c5 <= '9') {
                                    n6 *= 10;
                                    if ((n6 += c5 - 48) <= 65535) continue;
                                }
                                c3 = (char)n6;
                                break block0;
                            }
                            case 'c': {
                                c3 = (char)(cArray[n2++] & 0x1F);
                                break block0;
                            }
                            case 'D': {
                                bitset3 = bl3 ? UNONDIGIT : NONDIGIT;
                                break;
                            }
                            case 'S': {
                                bitset3 = bl3 ? UNONSPACE : NONSPACE;
                                break;
                            }
                            case 'W': {
                                bitset3 = bl3 ? UNONWORDCHAR : NONWORDCHAR;
                                break;
                            }
                            case 'd': {
                                if (bl7) {
                                    throw new PatternSyntaxException("illegal range: [..." + c2 + "-\\d...]");
                                }
                                bitset.setDigit(bl3);
                                break block64;
                            }
                            case 's': {
                                if (bl7) {
                                    throw new PatternSyntaxException("illegal range: [..." + c2 + "-\\s...]");
                                }
                                bitset.setSpace(bl3);
                                break block64;
                            }
                            case 'w': {
                                if (bl7) {
                                    throw new PatternSyntaxException("illegal range: [..." + c2 + "-\\w...]");
                                }
                                bitset.setWordChar(bl3);
                                break block64;
                            }
                            case 'P': {
                                bl8 = true;
                            }
                            case 'p': {
                                if (bl7) {
                                    throw new PatternSyntaxException("illegal range: [..." + c2 + "-\\w...]");
                                }
                                if (stringBuffer == null) {
                                    stringBuffer = new StringBuffer();
                                } else {
                                    stringBuffer.setLength(0);
                                }
                                n2 = CharacterClass.parseName(cArray, n2, n3, stringBuffer, bl2);
                                Bitset bitset4 = CharacterClass.getNamedClass(stringBuffer.toString());
                                if (bitset4 == null) {
                                    throw new PatternSyntaxException("unknown named class: {" + stringBuffer + "}");
                                }
                                bitset.add(bitset4, bl8);
                                break block64;
                            }
                            default: {
                                break block0;
                            }
                        }
                        if (bl7) {
                            throw new PatternSyntaxException("illegal range: [..." + c2 + "-\\" + c3 + "...]");
                        }
                        bitset.add(bitset3);
                        break block64;
                    }
                    case '{': {
                        if (bl7) {
                            throw new PatternSyntaxException("illegal range: [..." + c2 + "-\\w...]");
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.setLength(0);
                        }
                        n2 = CharacterClass.parseName(cArray, n2 - 1, n3, stringBuffer, bl2);
                        Bitset bitset5 = CharacterClass.getNamedClass(stringBuffer.toString());
                        if (bitset5 == null) {
                            throw new PatternSyntaxException("unknown named class: {" + stringBuffer + "}");
                        }
                        bitset.add(bitset5, false);
                        break block64;
                    }
                }
                if (c2 < '\u0000') {
                    c2 = c3;
                    bl7 = false;
                } else if (!bl7) {
                    char c6 = c2;
                    if (bl) {
                        bitset.setChar(Character.toLowerCase(c6));
                        bitset.setChar(Character.toUpperCase(c6));
                        bitset.setChar(Character.toTitleCase(c6));
                    } else {
                        bitset.setChar(c6);
                    }
                    c2 = c3;
                } else {
                    if (c2 > c3) {
                        throw new PatternSyntaxException("illegal range: " + c2 + ">" + c3);
                    }
                    char c7 = c2;
                    bl7 = false;
                    c2 = '\uffffffff';
                    if (bl) {
                        bitset.setRange(Character.toLowerCase(c7), Character.toLowerCase(c3));
                        bitset.setRange(Character.toUpperCase(c7), Character.toUpperCase(c3));
                        bitset.setRange(Character.toTitleCase(c7), Character.toTitleCase(c3));
                    } else {
                        bitset.setRange(c7, c3);
                    }
                }
            }
            bl5 = bl6;
            bl6 = false;
        }
        throw new PatternSyntaxException("unbalanced brackets in a class def");
    }

    static final int parseName(char[] cArray, int n2, int n3, StringBuffer stringBuffer, boolean bl) throws PatternSyntaxException {
        int n4 = -1;
        block5: while (n2 < n3) {
            char c2 = cArray[n2++];
            switch (c2) {
                case '{': {
                    n4 = n2;
                    continue block5;
                }
                case '}': {
                    return n2;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) break;
                    continue block5;
                }
            }
            if (n4 < 0) {
                throw new PatternSyntaxException("named class doesn't start with '{'");
            }
            stringBuffer.append(c2);
        }
        throw new PatternSyntaxException("wrong class name: " + new String(cArray, n2, n3 - n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String stringValue0(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (true) {
            if (!blArray[n2]) {
                if (++n2 < 255) continue;
                return stringBuffer.toString();
            }
            int n3 = n2;
            while (blArray[n2] && ++n2 <= 255) {
            }
            int n4 = n2 - 1;
            if (n4 == n3) {
                stringBuffer.append(CharacterClass.stringValue(n4));
            } else {
                stringBuffer.append(CharacterClass.stringValue(n3));
                stringBuffer.append('-');
                stringBuffer.append(CharacterClass.stringValue(n4));
            }
            if (n2 > 255) return stringBuffer.toString();
        }
    }

    static String stringValue2(boolean[][] blArray) {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer();
            int n2 = 0;
            do {
                boolean[] blArray2;
                boolean[] blArray3;
                boolean bl = false;
                while ((blArray3 = blArray[n2 >> 8]) == null || !blArray3[n2 & 0xFF]) {
                    if (++n2 <= 65535) continue;
                    break block4;
                }
                int n3 = n2;
                while (n2 <= 65535 && (blArray2 = blArray[n2 >> 8]) != null && blArray2[n2 & 0xFF]) {
                    ++n2;
                }
                int n4 = n2 - 1;
                if (n4 == n3) {
                    stringBuffer.append(CharacterClass.stringValue(n4));
                    continue;
                }
                stringBuffer.append(CharacterClass.stringValue(n3));
                stringBuffer.append('-');
                stringBuffer.append(CharacterClass.stringValue(n4));
            } while (n2 <= 65535);
        }
        return stringBuffer.toString();
    }

    static String stringValue(int n2) {
        StringBuffer stringBuffer = new StringBuffer(5);
        if (n2 < 32) {
            switch (n2) {
                case 13: {
                    stringBuffer.append("\\r");
                    break;
                }
                case 10: {
                    stringBuffer.append("\\n");
                    break;
                }
                case 9: {
                    stringBuffer.append("\\t");
                    break;
                }
                case 12: {
                    stringBuffer.append("\\f");
                    break;
                }
                default: {
                    stringBuffer.append('(');
                    stringBuffer.append(n2);
                    stringBuffer.append(')');
                    break;
                }
            }
        } else if (n2 < 256) {
            stringBuffer.append((char)n2);
        } else {
            stringBuffer.append('\\');
            stringBuffer.append('x');
            stringBuffer.append(Integer.toHexString(n2));
        }
        return stringBuffer.toString();
    }

    static int toHexDigit(char c2) throws PatternSyntaxException {
        int n2 = 0;
        if (c2 >= '0' && c2 <= '9') {
            n2 = c2 - 48;
        } else if (c2 >= 'a' && c2 <= 'f') {
            n2 = 10 + c2 - 97;
        } else if (c2 >= 'A' && c2 <= 'F') {
            n2 = 10 + c2 - 65;
        } else {
            throw new PatternSyntaxException("hexadecimal digit expected: " + c2);
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        if (!namesInitialized) {
            CharacterClass.initNames();
        }
        if (stringArray.length == 0) {
            System.out.println("Class usage: \\p{Class},\\P{Class}");
            CharacterClass.printRealm(posixClasses, "Posix classes");
            CharacterClass.printRealm(unicodeCategories, "Unicode categories");
            CharacterClass.printRealm(unicodeBlocks, "Unicode blocks");
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                System.out.print(stringArray[i2]);
                System.out.print(": ");
                System.out.println(namedClasses.containsKey(stringArray[i2]) ? "supported" : "not supported");
            }
        }
    }

    private static void printRealm(Vector vector, String string) {
        System.out.println(string + ":");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("  " + enumeration.nextElement());
        }
    }

    static {
        DIGIT.setDigit(false);
        WORDCHAR.setWordChar(false);
        SPACE.setSpace(false);
        UDIGIT.setDigit(true);
        UWORDCHAR.setWordChar(true);
        USPACE.setSpace(true);
        NONDIGIT.setDigit(false);
        NONDIGIT.setPositive(false);
        NONWORDCHAR.setWordChar(false);
        NONWORDCHAR.setPositive(false);
        NONSPACE.setSpace(false);
        NONSPACE.setPositive(false);
        UNONDIGIT.setDigit(true);
        UNONDIGIT.setPositive(false);
        UNONWORDCHAR.setWordChar(true);
        UNONWORDCHAR.setPositive(false);
        UNONSPACE.setSpace(true);
        UNONSPACE.setPositive(false);
        CharacterClass.initPosixClasses();
    }
}

