/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.PatternSyntaxException;
import com.contrastsecurity.thirdparty.jregex.Term;

class Lookbehind
extends Term {
    final boolean isPositive;
    private int prevDistance = -1;

    Lookbehind(int n2, boolean bl) {
        this.distance = 0;
        this.isPositive = bl;
        this.in = this;
        this.out = new Term();
        if (bl) {
            this.type = 39;
            this.out.type = 40;
        } else {
            this.type = 41;
            this.out.type = 42;
            this.branchOut = this;
        }
        this.lookaheadId = n2;
        this.out.lookaheadId = n2;
    }

    protected Term append(Term term) throws PatternSyntaxException {
        this.distance += Lookbehind.length(term);
        return super.append(term);
    }

    protected Term replaceCurrent(Term term) throws PatternSyntaxException {
        this.distance += Lookbehind.length(term) - Lookbehind.length(this.current);
        return super.replaceCurrent(term);
    }

    private static int length(Term term) throws PatternSyntaxException {
        int n2 = term.type;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 0;
            }
        }
        if (n2 >= 11 && n2 <= 31) {
            return 0;
        }
        throw new PatternSyntaxException("variable length element within a lookbehind assertion");
    }

    protected void startNewBranch() throws PatternSyntaxException {
        this.prevDistance = this.distance;
        this.distance = 0;
        super.startNewBranch();
    }

    protected void close() throws PatternSyntaxException {
        int n2 = this.prevDistance;
        if (n2 >= 0 && this.distance != n2) {
            throw new PatternSyntaxException("non-equal branch lengths within a lookbehind assertion");
        }
        super.close();
    }
}

