/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.n3.nanoxml;

import com.contrastsecurity.thirdparty.net.n3.nanoxml.IXMLReader;
import java.io.IOException;
import java.io.Reader;

class CDATAReader
extends Reader {
    private IXMLReader reader;
    private char savedChar;
    private boolean atEndOfData;

    CDATAReader(IXMLReader iXMLReader) {
        this.reader = iXMLReader;
        this.savedChar = '\u0000';
        this.atEndOfData = false;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 0;
        if (this.atEndOfData) {
            return -1;
        }
        if (n2 + n3 > cArray.length) {
            n3 = cArray.length - n2;
        }
        while (n4 < n3) {
            char c2 = this.savedChar;
            if (c2 == '\u0000') {
                c2 = this.reader.read();
            } else {
                this.savedChar = '\u0000';
            }
            if (c2 == ']') {
                char c3 = this.reader.read();
                if (c3 == ']') {
                    char c4 = this.reader.read();
                    if (c4 == '>') {
                        this.atEndOfData = true;
                        break;
                    }
                    this.savedChar = c3;
                    this.reader.unread(c4);
                } else {
                    this.reader.unread(c3);
                }
            }
            cArray[n4] = c2;
            ++n4;
        }
        if (n4 == 0) {
            n4 = -1;
        }
        return n4;
    }

    @Override
    public void close() throws IOException {
        while (!this.atEndOfData) {
            char c2 = this.savedChar;
            if (c2 == '\u0000') {
                c2 = this.reader.read();
            } else {
                this.savedChar = '\u0000';
            }
            if (c2 != ']') continue;
            char c3 = this.reader.read();
            if (c3 == ']') {
                char c4 = this.reader.read();
                if (c4 == '>') break;
                this.savedChar = c3;
                this.reader.unread(c4);
                continue;
            }
            this.reader.unread(c3);
        }
        this.atEndOfData = true;
    }
}

