/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Fetch;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Limit;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Offset;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectBody;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SetOperation;
import java.util.List;

public class SetOperationList
implements SelectBody {
    private List<SelectBody> selects;
    private List<Boolean> brackets;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<SelectBody> getSelects() {
        return this.selects;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public List<Boolean> getBrackets() {
        return this.brackets;
    }

    public void setBrackets(List<Boolean> list) {
        this.brackets = list;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public void setBracketsOpsAndSelects(List<Boolean> list, List<SelectBody> list2, List<SetOperation> list3) {
        this.selects = list2;
        this.operations = list3;
        this.brackets = list;
        if (list2.size() - 1 != list3.size() || list2.size() != list.size()) {
            throw new IllegalArgumentException("list sizes are not valid");
        }
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.selects.size(); ++i2) {
            if (i2 != 0) {
                stringBuilder.append(" ").append(this.operations.get(i2 - 1).toString()).append(" ");
            }
            if (this.brackets == null || this.brackets.get(i2).booleanValue()) {
                stringBuilder.append("(").append(this.selects.get(i2).toString()).append(")");
                continue;
            }
            stringBuilder.append(this.selects.get(i2).toString());
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit.toString());
        }
        if (this.offset != null) {
            stringBuilder.append(this.offset.toString());
        }
        if (this.fetch != null) {
            stringBuilder.append(this.fetch.toString());
        }
        return stringBuilder.toString();
    }

    public static enum SetOperationType {
        INTERSECT,
        EXCEPT,
        MINUS,
        UNION;

    }
}

