/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.AllComparisonExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.AnalyticExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.AnyComparisonExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.BinaryExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.CaseExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.CastExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.DateValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.DoubleValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExtractExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Function;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.HexValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.IntervalExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.JdbcNamedParameter;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.JdbcParameter;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.JsonExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.KeepExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.LongValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.MySQLGroupConcat;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.NotExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.NullValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.NumericBind;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.OracleHint;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Parenthesis;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.RowConstructor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.SignedExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.StringValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.TimeKeyExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.TimeValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.TimestampValue;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.UserVariable;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.WhenClause;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.WindowElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.WithinGroupExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.Between;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.InExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.Matches;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Column;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.SubSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.WithItem;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import java.util.Iterator;
import java.util.List;

public class ExpressionDeParser
implements ExpressionVisitor,
ItemsListVisitor {
    private static final String NOT = "NOT ";
    private StringBuilder buffer = new StringBuilder();
    private SelectVisitor selectVisitor;
    private boolean useBracketsInExprList = true;
    private OrderByDeParser orderByDeParser = new OrderByDeParser();

    public ExpressionDeParser() {
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        this(selectVisitor, stringBuilder, new OrderByDeParser());
    }

    ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder stringBuilder, OrderByDeParser orderByDeParser) {
        this.selectVisitor = selectVisitor;
        this.buffer = stringBuilder;
        this.orderByDeParser = orderByDeParser;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.toString());
    }

    @Override
    public void visit(HexValue hexValue) {
        this.buffer.append(hexValue.toString());
    }

    @Override
    public void visit(NotExpression notExpression) {
        this.buffer.append(NOT);
        notExpression.getExpression().accept(this);
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression oldOracleJoinBinaryExpression, String string) {
        if (oldOracleJoinBinaryExpression.isNot()) {
            this.buffer.append(NOT);
        }
        oldOracleJoinBinaryExpression.getLeftExpression().accept(this);
        if (oldOracleJoinBinaryExpression.getOldOracleJoinSyntax() == 1) {
            this.buffer.append("(+)");
        }
        this.buffer.append(string);
        oldOracleJoinBinaryExpression.getRightExpression().accept(this);
        if (oldOracleJoinBinaryExpression.getOldOracleJoinSyntax() == 2) {
            this.buffer.append("(+)");
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        if (inExpression.getLeftExpression() == null) {
            inExpression.getLeftItemsList().accept(this);
        } else {
            inExpression.getLeftExpression().accept(this);
            if (inExpression.getOldOracleJoinSyntax() == 1) {
                this.buffer.append("(+)");
            }
        }
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        inExpression.getRightItemsList().accept(this);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        this.buffer.append(signedExpression.getSign());
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
        } else {
            this.buffer.append(" IS NULL");
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
        if (jdbcParameter.isUseFixedIndex()) {
            this.buffer.append(jdbcParameter.getIndex());
        }
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression, likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE ");
        String string = likeExpression.getEscape();
        if (string != null) {
            this.buffer.append(" ESCAPE '").append(string).append('\'');
        }
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append("NOT EXISTS ");
        } else {
            this.buffer.append("EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(NullValue nullValue) {
        this.buffer.append(nullValue.toString());
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        if (parenthesis.isNot()) {
            this.buffer.append(NOT);
        }
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(StringValue stringValue) {
        this.buffer.append("'").append(stringValue.getValue()).append("'");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression, String string) {
        if (binaryExpression.isNot()) {
            this.buffer.append(NOT);
        }
        binaryExpression.getLeftExpression().accept(this);
        this.buffer.append(string);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        if (this.selectVisitor != null) {
            if (subSelect.getWithItemsList() != null) {
                this.buffer.append("WITH ");
                Iterator<WithItem> iterator = subSelect.getWithItemsList().iterator();
                while (iterator.hasNext()) {
                    iterator.next().accept(this.selectVisitor);
                    if (iterator.hasNext()) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
                this.buffer.append(" ");
            }
            subSelect.getSelectBody().accept(this.selectVisitor);
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(Column column) {
        Table table = column.getTable();
        String string = null;
        if (table != null) {
            string = table.getAlias() != null ? table.getAlias().getName() : table.getFullyQualifiedName();
        }
        if (string != null && !string.isEmpty()) {
            this.buffer.append(string).append(".");
        }
        this.buffer.append(column.getColumnName());
    }

    @Override
    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        this.buffer.append(function.getName());
        if (function.isAllColumns() && function.getParameters() == null) {
            this.buffer.append("(*)");
        } else if (function.getParameters() == null) {
            this.buffer.append("()");
        } else {
            boolean bl = this.useBracketsInExprList;
            if (function.isDistinct()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(DISTINCT ");
            } else if (function.isAllColumns()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(ALL ");
            }
            this.visit(function.getParameters());
            this.useBracketsInExprList = bl;
            if (function.isDistinct() || function.isAllColumns()) {
                this.buffer.append(")");
            }
        }
        if (function.getAttribute() != null) {
            this.buffer.append(".").append(function.getAttribute());
        }
        if (function.getKeep() != null) {
            this.buffer.append(" ").append(function.getKeep());
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        Iterator<Expression> iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void visit(DateValue dateValue) {
        this.buffer.append("{d '").append(dateValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '").append(timestampValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '").append(timeValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.buffer.append("CASE ");
        Expression expression = caseExpression.getSwitchExpression();
        if (expression != null) {
            expression.accept(this);
            this.buffer.append(" ");
        }
        for (Expression expression2 : caseExpression.getWhenClauses()) {
            expression2.accept(this);
        }
        Expression expression3 = caseExpression.getElseExpression();
        if (expression3 != null) {
            this.buffer.append("ELSE ");
            expression3.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.buffer.append("WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
        this.buffer.append(" ");
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        this.buffer.append("ALL ");
        allComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(anyComparisonExpression.getAnyType().name()).append(" ");
        anyComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression castExpression) {
        if (castExpression.isUseCastKeyword()) {
            this.buffer.append("CAST(");
            this.buffer.append(castExpression.getLeftExpression());
            this.buffer.append(" AS ");
            this.buffer.append(castExpression.getType());
            this.buffer.append(")");
        } else {
            this.buffer.append(castExpression.getLeftExpression());
            this.buffer.append("::");
            this.buffer.append(castExpression.getType());
        }
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression analyticExpression) {
        String string = analyticExpression.getName();
        Expression expression = analyticExpression.getExpression();
        Expression expression2 = analyticExpression.getOffset();
        Expression expression3 = analyticExpression.getDefaultValue();
        boolean bl = analyticExpression.isAllColumns();
        KeepExpression keepExpression = analyticExpression.getKeep();
        ExpressionList expressionList = analyticExpression.getPartitionExpressionList();
        List<OrderByElement> list = analyticExpression.getOrderByElements();
        WindowElement windowElement = analyticExpression.getWindowElement();
        this.buffer.append(string).append("(");
        if (expression != null) {
            expression.accept(this);
            if (expression2 != null) {
                this.buffer.append(", ");
                expression2.accept(this);
                if (expression3 != null) {
                    this.buffer.append(", ");
                    expression3.accept(this);
                }
            }
        } else if (bl) {
            this.buffer.append("*");
        }
        this.buffer.append(") ");
        if (keepExpression != null) {
            keepExpression.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("OVER (");
        if (expressionList != null && !expressionList.getExpressions().isEmpty()) {
            this.buffer.append("PARTITION BY ");
            List<Expression> list2 = expressionList.getExpressions();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                if (i2 > 0) {
                    this.buffer.append(", ");
                }
                list2.get(i2).accept(this);
            }
            this.buffer.append(" ");
        }
        if (list != null && !list.isEmpty()) {
            this.buffer.append("ORDER BY ");
            this.orderByDeParser.setExpressionVisitor(this);
            this.orderByDeParser.setBuffer(this.buffer);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                if (i3 > 0) {
                    this.buffer.append(", ");
                }
                this.orderByDeParser.deParseElement(list.get(i3));
            }
            if (windowElement != null) {
                this.buffer.append(' ');
                this.buffer.append(windowElement);
            }
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(ExtractExpression extractExpression) {
        this.buffer.append("EXTRACT(").append(extractExpression.getName());
        this.buffer.append(" FROM ");
        extractExpression.getExpression().accept(this);
        this.buffer.append(')');
    }

    @Override
    public void visit(MultiExpressionList multiExpressionList) {
        Iterator<ExpressionList> iterator = multiExpressionList.getExprList().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(IntervalExpression intervalExpression) {
        this.buffer.append(intervalExpression.toString());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.buffer.append(jdbcNamedParameter.toString());
    }

    @Override
    public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.buffer.append(oracleHierarchicalExpression.toString());
    }

    @Override
    public void visit(RegExpMatchOperator regExpMatchOperator) {
        this.visitBinaryExpression(regExpMatchOperator, " " + regExpMatchOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(RegExpMySQLOperator regExpMySQLOperator) {
        this.visitBinaryExpression(regExpMySQLOperator, " " + regExpMySQLOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpression) {
        this.buffer.append(jsonExpression.toString());
    }

    @Override
    public void visit(JsonOperator jsonOperator) {
        this.visitBinaryExpression(jsonOperator, " " + jsonOperator.getStringExpression() + " ");
    }

    @Override
    public void visit(WithinGroupExpression withinGroupExpression) {
        this.buffer.append(withinGroupExpression.toString());
    }

    @Override
    public void visit(UserVariable userVariable) {
        this.buffer.append(userVariable.toString());
    }

    @Override
    public void visit(NumericBind numericBind) {
        this.buffer.append(numericBind.toString());
    }

    @Override
    public void visit(KeepExpression keepExpression) {
        this.buffer.append(keepExpression.toString());
    }

    @Override
    public void visit(MySQLGroupConcat mySQLGroupConcat) {
        this.buffer.append(mySQLGroupConcat.toString());
    }

    @Override
    public void visit(RowConstructor rowConstructor) {
        if (rowConstructor.getName() != null) {
            this.buffer.append(rowConstructor.getName());
        }
        this.buffer.append("(");
        boolean bl = true;
        for (Expression expression : rowConstructor.getExprList().getExpressions()) {
            if (bl) {
                bl = false;
            } else {
                this.buffer.append(", ");
            }
            expression.accept(this);
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(OracleHint oracleHint) {
        this.buffer.append(oracleHint.toString());
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        this.buffer.append(timeKeyExpression.toString());
    }

    @Override
    public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
        this.buffer.append(dateTimeLiteralExpression.toString());
    }
}

