/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.EncodableHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.HistogramLogScanner;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.zip.DataFormatException;

public class HistogramLogReader
implements Closeable {
    private final HistogramLogScanner scanner;
    private final HistogramLogScanner.EventHandler handler = new HistogramLogScanner.EventHandler(){

        @Override
        public boolean onComment(String string) {
            return false;
        }

        @Override
        public boolean onBaseTime(double d2) {
            HistogramLogReader.this.baseTimeSec = d2;
            HistogramLogReader.this.observedBaseTime = true;
            return false;
        }

        @Override
        public boolean onStartTime(double d2) {
            HistogramLogReader.this.startTimeSec = d2;
            HistogramLogReader.this.observedStartTime = true;
            return false;
        }

        @Override
        public boolean onHistogram(String string, double d2, double d3, HistogramLogScanner.EncodableHistogramSupplier encodableHistogramSupplier) {
            EncodableHistogram encodableHistogram;
            double d4;
            double d5 = d2;
            if (!HistogramLogReader.this.observedStartTime) {
                HistogramLogReader.this.startTimeSec = d5;
                HistogramLogReader.this.observedStartTime = true;
            }
            if (!HistogramLogReader.this.observedBaseTime) {
                if (d5 < HistogramLogReader.this.startTimeSec - 3.1536E7) {
                    HistogramLogReader.this.baseTimeSec = HistogramLogReader.this.startTimeSec;
                } else {
                    HistogramLogReader.this.baseTimeSec = 0.0;
                }
                HistogramLogReader.this.observedBaseTime = true;
            }
            double d6 = d5 + HistogramLogReader.this.baseTimeSec;
            double d7 = d6 - HistogramLogReader.this.startTimeSec;
            double d8 = d3;
            double d9 = d6 + d8;
            double d10 = d4 = HistogramLogReader.this.absolute ? d6 : d7;
            if (d4 < HistogramLogReader.this.rangeStartTimeSec) {
                return false;
            }
            if (d4 > HistogramLogReader.this.rangeEndTimeSec) {
                return true;
            }
            try {
                encodableHistogram = encodableHistogramSupplier.read();
            }
            catch (DataFormatException dataFormatException) {
                return true;
            }
            encodableHistogram.setStartTimeStamp((long)(d6 * 1000.0));
            encodableHistogram.setEndTimeStamp((long)(d9 * 1000.0));
            encodableHistogram.setTag(string);
            HistogramLogReader.this.nextHistogram = encodableHistogram;
            return true;
        }

        @Override
        public boolean onException(Throwable throwable) {
            if (throwable instanceof NoSuchElementException) {
                return true;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    };
    private double startTimeSec = 0.0;
    private boolean observedStartTime = false;
    private double baseTimeSec = 0.0;
    private boolean observedBaseTime = false;
    private boolean absolute;
    private double rangeStartTimeSec;
    private double rangeEndTimeSec;
    private EncodableHistogram nextHistogram;

    public HistogramLogReader(String string) throws FileNotFoundException {
        this.scanner = new HistogramLogScanner(new File(string));
    }

    public HistogramLogReader(InputStream inputStream) {
        this.scanner = new HistogramLogScanner(inputStream);
    }

    public HistogramLogReader(File file) throws FileNotFoundException {
        this.scanner = new HistogramLogScanner(file);
    }

    public double getStartTimeSec() {
        return this.startTimeSec;
    }

    public EncodableHistogram nextIntervalHistogram(double d2, double d3) {
        return this.nextIntervalHistogram(d2, d3, false);
    }

    public EncodableHistogram nextAbsoluteIntervalHistogram(double d2, double d3) {
        return this.nextIntervalHistogram(d2, d3, true);
    }

    public EncodableHistogram nextIntervalHistogram() {
        return this.nextIntervalHistogram(0.0, 9.223372036854776E18, true);
    }

    private EncodableHistogram nextIntervalHistogram(double d2, double d3, boolean bl) {
        this.rangeStartTimeSec = d2;
        this.rangeEndTimeSec = d3;
        this.absolute = bl;
        this.scanner.process(this.handler);
        EncodableHistogram encodableHistogram = this.nextHistogram;
        this.nextHistogram = null;
        return encodableHistogram;
    }

    public boolean hasNext() {
        return this.scanner.hasNextLine();
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

