/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.AbstractHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.AbstractHistogramIterator;
import com.contrastsecurity.thirdparty.org.HdrHistogram.HistogramIterationValue;
import java.util.Iterator;

public class PercentileIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    int percentileTicksPerHalfDistance;
    double percentileLevelToIterateTo;
    double percentileLevelToIterateFrom;
    boolean reachedLastRecordedValue;

    public void reset(int n2) {
        this.reset(this.histogram, n2);
    }

    private void reset(AbstractHistogram abstractHistogram, int n2) {
        super.resetIterator(abstractHistogram);
        this.percentileTicksPerHalfDistance = n2;
        this.percentileLevelToIterateTo = 0.0;
        this.percentileLevelToIterateFrom = 0.0;
        this.reachedLastRecordedValue = false;
    }

    public PercentileIterator(AbstractHistogram abstractHistogram, int n2) {
        this.reset(abstractHistogram, n2);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        if (!this.reachedLastRecordedValue && this.arrayTotalCount > 0L) {
            this.percentileLevelToIterateTo = 100.0;
            this.reachedLastRecordedValue = true;
            return true;
        }
        return false;
    }

    @Override
    void incrementIterationLevel() {
        this.percentileLevelToIterateFrom = this.percentileLevelToIterateTo;
        long l2 = (long)this.percentileTicksPerHalfDistance * (long)Math.pow(2.0, (long)(Math.log(100.0 / (100.0 - this.percentileLevelToIterateTo)) / Math.log(2.0)) + 1L);
        this.percentileLevelToIterateTo += 100.0 / (double)l2;
    }

    @Override
    boolean reachedIterationLevel() {
        if (this.countAtThisValue == 0L) {
            return false;
        }
        double d2 = 100.0 * (double)this.totalCountToCurrentIndex / (double)this.arrayTotalCount;
        return d2 >= this.percentileLevelToIterateTo;
    }

    @Override
    double getPercentileIteratedTo() {
        return this.percentileLevelToIterateTo;
    }

    @Override
    double getPercentileIteratedFrom() {
        return this.percentileLevelToIterateFrom;
    }
}

