/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram.packedarray;

import com.contrastsecurity.thirdparty.org.HdrHistogram.packedarray.AbstractPackedArrayContext;
import java.util.Arrays;

class PackedArrayContext
extends AbstractPackedArrayContext {
    private long[] array;
    private int populatedShortLength = 0;

    PackedArrayContext(int n2, int n3, boolean bl) {
        super(n2, n3);
        if (bl) {
            this.array = new long[this.getPhysicalLength()];
            this.init(n2);
        }
    }

    PackedArrayContext(int n2, int n3) {
        this(n2, n3, true);
    }

    PackedArrayContext(int n2, AbstractPackedArrayContext abstractPackedArrayContext, int n3) {
        this(n2, n3);
        if (this.isPacked()) {
            this.populateEquivalentEntriesWithZerosFromOther(abstractPackedArrayContext);
        }
    }

    @Override
    int length() {
        return this.array.length;
    }

    @Override
    int getPopulatedShortLength() {
        return this.populatedShortLength;
    }

    @Override
    boolean casPopulatedShortLength(int n2, int n3) {
        if (this.populatedShortLength != n2) {
            return false;
        }
        this.populatedShortLength = n3;
        return true;
    }

    @Override
    boolean casPopulatedLongLength(int n2, int n3) {
        if (this.getPopulatedLongLength() != n2) {
            return false;
        }
        return this.casPopulatedShortLength(this.populatedShortLength, n3 << 2);
    }

    @Override
    long getAtLongIndex(int n2) {
        return this.array[n2];
    }

    @Override
    boolean casAtLongIndex(int n2, long l2, long l3) {
        if (this.array[n2] != l2) {
            return false;
        }
        this.array[n2] = l3;
        return true;
    }

    @Override
    void lazySetAtLongIndex(int n2, long l2) {
        this.array[n2] = l2;
    }

    @Override
    void clearContents() {
        Arrays.fill(this.array, 0L);
        this.init(this.getVirtualLength());
    }

    @Override
    void resizeArray(int n2) {
        this.array = Arrays.copyOf(this.array, n2);
    }

    @Override
    long getAtUnpackedIndex(int n2) {
        return this.array[n2];
    }

    @Override
    void setAtUnpackedIndex(int n2, long l2) {
        this.array[n2] = l2;
    }

    @Override
    void lazysetAtUnpackedIndex(int n2, long l2) {
        this.array[n2] = l2;
    }

    @Override
    long incrementAndGetAtUnpackedIndex(int n2) {
        int n3 = n2;
        this.array[n3] = this.array[n3] + 1L;
        return this.array[n2];
    }

    @Override
    long addAndGetAtUnpackedIndex(int n2, long l2) {
        int n3 = n2;
        this.array[n3] = this.array[n3] + l2;
        return this.array[n2];
    }

    @Override
    String unpackedToString() {
        return Arrays.toString(this.array);
    }
}

