/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.LatencyUtils;

import com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetectorListener;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class PauseDetector {
    private final ArrayList<PauseDetectorListener> highPriorityListeners = new ArrayList(32);
    private final ArrayList<PauseDetectorListener> normalPriorityListeners = new ArrayList(32);
    private final LinkedBlockingQueue<Object> messages = new LinkedBlockingQueue();
    private final PauseDetectorThread pauseDetectorThread = new PauseDetectorThread();
    private volatile boolean stop;

    protected PauseDetector() {
        this.pauseDetectorThread.setDaemon(true);
        this.stop = false;
        this.pauseDetectorThread.start();
    }

    protected synchronized void notifyListeners(long l2, long l3) {
        this.messages.add(new PauseNotification(l2, l3));
    }

    public synchronized void addListener(PauseDetectorListener pauseDetectorListener) {
        this.addListener(pauseDetectorListener, false);
    }

    public synchronized void addListener(PauseDetectorListener pauseDetectorListener, boolean bl) {
        this.messages.add(new ChangeListenersRequest(bl ? ChangeListenersRequest.ChangeCommand.ADD_HIGH_PRIORITY : ChangeListenersRequest.ChangeCommand.ADD_NORMAL_PRIORITY, pauseDetectorListener));
    }

    public synchronized void removeListener(PauseDetectorListener pauseDetectorListener) {
        this.messages.add(new ChangeListenersRequest(ChangeListenersRequest.ChangeCommand.REMOVE, pauseDetectorListener));
    }

    public void shutdown() {
        this.stop = true;
        this.pauseDetectorThread.interrupt();
    }

    static class PauseNotification {
        final long pauseLengthNsec;
        final long pauseEndTimeNsec;

        PauseNotification(long l2, long l3) {
            this.pauseLengthNsec = l2;
            this.pauseEndTimeNsec = l3;
        }
    }

    static class ChangeListenersRequest {
        final ChangeCommand command;
        final PauseDetectorListener listener;

        ChangeListenersRequest(ChangeCommand changeCommand, PauseDetectorListener pauseDetectorListener) {
            this.command = changeCommand;
            this.listener = pauseDetectorListener;
        }

        static enum ChangeCommand {
            ADD_HIGH_PRIORITY,
            ADD_NORMAL_PRIORITY,
            REMOVE;

        }
    }

    private class PauseDetectorThread
    extends Thread {
        private PauseDetectorThread() {
        }

        @Override
        public void run() {
            while (!PauseDetector.this.stop) {
                try {
                    Object object;
                    Object e2 = PauseDetector.this.messages.take();
                    if (e2 instanceof ChangeListenersRequest) {
                        object = (ChangeListenersRequest)e2;
                        if (((ChangeListenersRequest)object).command == ChangeListenersRequest.ChangeCommand.ADD_HIGH_PRIORITY) {
                            PauseDetector.this.highPriorityListeners.add(((ChangeListenersRequest)object).listener);
                            continue;
                        }
                        if (((ChangeListenersRequest)object).command == ChangeListenersRequest.ChangeCommand.ADD_NORMAL_PRIORITY) {
                            PauseDetector.this.normalPriorityListeners.add(((ChangeListenersRequest)object).listener);
                            continue;
                        }
                        PauseDetector.this.normalPriorityListeners.remove(((ChangeListenersRequest)object).listener);
                        PauseDetector.this.highPriorityListeners.remove(((ChangeListenersRequest)object).listener);
                        continue;
                    }
                    if (e2 instanceof PauseNotification) {
                        object = (PauseNotification)e2;
                        for (PauseDetectorListener pauseDetectorListener : PauseDetector.this.highPriorityListeners) {
                            pauseDetectorListener.handlePauseEvent(((PauseNotification)object).pauseLengthNsec, ((PauseNotification)object).pauseEndTimeNsec);
                        }
                        for (PauseDetectorListener pauseDetectorListener : PauseDetector.this.normalPriorityListeners) {
                            pauseDetectorListener.handlePauseEvent(((PauseNotification)object).pauseLengthNsec, ((PauseNotification)object).pauseEndTimeNsec);
                        }
                        continue;
                    }
                    throw new RuntimeException("Unexpected message type received: " + e2);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

