/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.LatencyUtils;

import com.contrastsecurity.thirdparty.org.LatencyUtils.MovingAverageIntervalEstimator;
import com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetector;
import com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetectorListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLongArray;

public class TimeCappedMovingAverageIntervalEstimator
extends MovingAverageIntervalEstimator {
    private final long baseTimeCap;
    private final PauseTracker pauseTracker;
    private long timeCap;
    private volatile long timeOfLastEstimatedInterval = 0L;
    private static final int maxPausesToTrack = 32;
    private AtomicLongArray pauseStartTimes = new AtomicLongArray(32);
    private AtomicLongArray pauseLengths = new AtomicLongArray(32);
    private int earliestPauseIndex = 0;
    private int nextPauseRecordingIndex = 0;

    public TimeCappedMovingAverageIntervalEstimator(int n2, long l2) {
        this(n2, l2, null);
    }

    public TimeCappedMovingAverageIntervalEstimator(int n2, long l2, PauseDetector pauseDetector) {
        super(n2);
        this.baseTimeCap = l2;
        this.timeCap = l2;
        this.pauseTracker = pauseDetector != null ? new PauseTracker(pauseDetector, this) : null;
        for (int i2 = 0; i2 < 32; ++i2) {
            this.pauseStartTimes.set(i2, Long.MAX_VALUE);
            this.pauseLengths.set(i2, 0L);
        }
    }

    @Override
    public void recordInterval(long l2) {
        super.recordIntervalAndReturnWindowPosition(l2);
    }

    @Override
    public synchronized long getEstimatedInterval(long l2) {
        long l3;
        long l4;
        long l5;
        this.timeOfLastEstimatedInterval = l2;
        this.eliminateStalePauses(l2);
        long l6 = this.count.get();
        if (l6 < (long)this.windowLength) {
            return Long.MAX_VALUE;
        }
        int n2 = this.determineNumberOfWindowPositionsOutsideOfTimeCap(l2);
        do {
            l5 = l6;
            int n3 = (int)(l6 + (long)this.windowLength - 1L & (long)this.windowMask);
            long l7 = this.determineEarliestQualifyingTimeInWindow(l2);
            if (l7 == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            l3 = Math.max(this.intervalEndTimes[n3], l2);
            l4 = l3 - l7;
        } while ((l6 = this.count.get()) != l5 || l4 < 0L);
        long l8 = this.timeCap - this.baseTimeCap;
        int n4 = this.windowLength - n2 - 1;
        if (n4 <= 0) {
            return Long.MAX_VALUE;
        }
        l3 = (l4 - l8) / (long)n4;
        if (l3 <= 0L) {
            return Long.MAX_VALUE;
        }
        return l3;
    }

    private synchronized void recordPause(long l2, long l3) {
        if (this.pauseStartTimes.get(this.nextPauseRecordingIndex) != Long.MAX_VALUE) {
            this.timeCap -= this.pauseLengths.get(this.nextPauseRecordingIndex);
            this.earliestPauseIndex = (this.nextPauseRecordingIndex + 1) % 32;
        }
        this.timeCap += l2;
        this.pauseStartTimes.set(this.nextPauseRecordingIndex, l3 - l2);
        this.pauseLengths.set(this.nextPauseRecordingIndex, l2);
        this.nextPauseRecordingIndex = (this.nextPauseRecordingIndex + 1) % 32;
    }

    public void stop() {
        if (this.pauseTracker != null) {
            this.pauseTracker.stop();
        }
    }

    public String toString() {
        long l2 = this.timeOfLastEstimatedInterval;
        this.eliminateStalePauses(l2);
        int n2 = this.determineNumberOfWindowPositionsOutsideOfTimeCap(l2);
        long l3 = this.determineEarliestQualifyingTimeInWindow(l2);
        long l4 = l2 - l3;
        long l5 = this.timeCap - this.baseTimeCap;
        int n3 = this.windowLength - n2 - 1;
        long l6 = Long.MAX_VALUE;
        if (n3 > 0) {
            l6 = (l4 - l5) / (long)n3;
        }
        return "IntervalEstimator: \nEstimated Interval: " + this.getEstimatedInterval(l2) + " (calculated at time " + l2 + ")\n" + "Time cap: " + this.timeCap + ", count = " + this.count.get() + ", currentPosition = " + this.getCurrentPosition() + "\n" + "timeCapStartTime = " + (l2 - this.timeCap) + ", numberOfWindowPositionsSkipped = " + n2 + "\n" + "windowStartTime = " + l3 + ", windowTimeSpan = " + l4 + ", positionDelta = " + n3 + "\n" + "totalPauseTimeInWindow = " + l5 + ", averageInterval = " + l6 + "\n";
    }

    private void eliminateStalePauses(long l2) {
        long l3;
        long l4 = this.determineEarliestQualifyingTimeInWindow(l2);
        do {
            l3 = l4;
            long l5 = l2 - this.timeCap;
            long l6 = Math.max(l5, l3);
            long l7 = this.pauseStartTimes.get(this.earliestPauseIndex);
            while (l7 < l6) {
                this.timeCap -= this.pauseLengths.get(this.earliestPauseIndex);
                l5 = l2 - this.timeCap;
                l6 = Math.max(l5, l3);
                this.pauseStartTimes.set(this.earliestPauseIndex, Long.MAX_VALUE);
                this.pauseLengths.set(this.earliestPauseIndex, 0L);
                this.earliestPauseIndex = (this.earliestPauseIndex + 1) % 32;
                l7 = this.pauseStartTimes.get(this.earliestPauseIndex);
            }
        } while (l3 != (l4 = this.determineEarliestQualifyingTimeInWindow(l2)));
    }

    private long determineEarliestQualifyingTimeInWindow(long l2) {
        int n2 = this.determineNumberOfWindowPositionsOutsideOfTimeCap(l2);
        if (n2 == this.windowLength) {
            return Long.MAX_VALUE;
        }
        int n3 = this.getCurrentPosition() + n2 & this.windowMask;
        return this.intervalEndTimes[n3];
    }

    private int determineNumberOfWindowPositionsOutsideOfTimeCap(long l2) {
        long l3;
        int n2 = this.getCurrentPosition();
        if (this.intervalEndTimes[n2] >= (l3 = l2 - this.timeCap)) {
            return 0;
        }
        int n3 = 0;
        int n4 = this.windowLength;
        while (n3 < n4) {
            int n5 = n3 + n4 >>> 1;
            int n6 = n2 + n5 & this.windowMask;
            long l4 = this.intervalEndTimes[n6];
            if (l4 < l3) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5;
        }
        return n3;
    }

    private static class PauseTracker
    extends WeakReference<TimeCappedMovingAverageIntervalEstimator>
    implements PauseDetectorListener {
        final PauseDetector pauseDetector;

        PauseTracker(PauseDetector pauseDetector, TimeCappedMovingAverageIntervalEstimator timeCappedMovingAverageIntervalEstimator) {
            super(timeCappedMovingAverageIntervalEstimator);
            this.pauseDetector = pauseDetector;
            pauseDetector.addListener(this, true);
        }

        public void stop() {
            this.pauseDetector.removeListener(this);
        }

        @Override
        public void handlePauseEvent(long l2, long l3) {
            TimeCappedMovingAverageIntervalEstimator timeCappedMovingAverageIntervalEstimator = (TimeCappedMovingAverageIntervalEstimator)this.get();
            if (timeCappedMovingAverageIntervalEstimator != null) {
                timeCappedMovingAverageIntervalEstimator.recordPause(l2, l3);
            } else {
                this.stop();
            }
        }
    }
}

