/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.math;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.math.Range;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.io.Serializable;

public final class DoubleRange
extends Range
implements Serializable {
    private static final long serialVersionUID = 71849363892740L;
    private final double min;
    private final double max;
    private transient Double minObject = null;
    private transient Double maxObject = null;
    private transient int hashCode = 0;
    private transient String toString = null;

    public DoubleRange(double d2) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        this.min = d2;
        this.max = d2;
    }

    public DoubleRange(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("The number must not be null");
        }
        this.min = number.doubleValue();
        this.max = number.doubleValue();
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        if (number instanceof Double) {
            this.minObject = (Double)number;
            this.maxObject = (Double)number;
        }
    }

    public DoubleRange(double d2, double d3) {
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new IllegalArgumentException("The numbers must not be NaN");
        }
        if (d3 < d2) {
            this.min = d3;
            this.max = d2;
        } else {
            this.min = d2;
            this.max = d3;
        }
    }

    public DoubleRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The numbers must not be null");
        }
        double d2 = number.doubleValue();
        double d3 = number2.doubleValue();
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new IllegalArgumentException("The numbers must not be NaN");
        }
        if (d3 < d2) {
            this.min = d3;
            this.max = d2;
            if (number2 instanceof Double) {
                this.minObject = (Double)number2;
            }
            if (number instanceof Double) {
                this.maxObject = (Double)number;
            }
        } else {
            this.min = d2;
            this.max = d3;
            if (number instanceof Double) {
                this.minObject = (Double)number;
            }
            if (number2 instanceof Double) {
                this.maxObject = (Double)number2;
            }
        }
    }

    public Number getMinimumNumber() {
        if (this.minObject == null) {
            this.minObject = new Double(this.min);
        }
        return this.minObject;
    }

    public long getMinimumLong() {
        return (long)this.min;
    }

    public int getMinimumInteger() {
        return (int)this.min;
    }

    public double getMinimumDouble() {
        return this.min;
    }

    public float getMinimumFloat() {
        return (float)this.min;
    }

    public Number getMaximumNumber() {
        if (this.maxObject == null) {
            this.maxObject = new Double(this.max);
        }
        return this.maxObject;
    }

    public long getMaximumLong() {
        return (long)this.max;
    }

    public int getMaximumInteger() {
        return (int)this.max;
    }

    public double getMaximumDouble() {
        return this.max;
    }

    public float getMaximumFloat() {
        return (float)this.max;
    }

    public boolean containsNumber(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsDouble(number.doubleValue());
    }

    public boolean containsDouble(double d2) {
        return d2 >= this.min && d2 <= this.max;
    }

    public boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.containsDouble(range.getMinimumDouble()) && this.containsDouble(range.getMaximumDouble());
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.containsDouble(this.min) || range.containsDouble(this.max) || this.containsDouble(range.getMinimumDouble());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleRange)) {
            return false;
        }
        DoubleRange doubleRange = (DoubleRange)object;
        return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(doubleRange.min) && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(doubleRange.max);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().hashCode();
            long l2 = Double.doubleToLongBits(this.min);
            this.hashCode = 37 * this.hashCode + (int)(l2 ^ l2 >> 32);
            l2 = Double.doubleToLongBits(this.max);
            this.hashCode = 37 * this.hashCode + (int)(l2 ^ l2 >> 32);
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StrBuilder strBuilder = new StrBuilder(32);
            strBuilder.append("Range[");
            strBuilder.append(this.min);
            strBuilder.append(',');
            strBuilder.append(this.max);
            strBuilder.append(']');
            this.toString = strBuilder.toString();
        }
        return this.toString;
    }
}

