/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.math;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.math.Range;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.io.Serializable;

public final class LongRange
extends Range
implements Serializable {
    private static final long serialVersionUID = 71849363892720L;
    private final long min;
    private final long max;
    private transient Long minObject = null;
    private transient Long maxObject = null;
    private transient int hashCode = 0;
    private transient String toString = null;

    public LongRange(long l2) {
        this.min = l2;
        this.max = l2;
    }

    public LongRange(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("The number must not be null");
        }
        this.min = number.longValue();
        this.max = number.longValue();
        if (number instanceof Long) {
            this.minObject = (Long)number;
            this.maxObject = (Long)number;
        }
    }

    public LongRange(long l2, long l3) {
        if (l3 < l2) {
            this.min = l3;
            this.max = l2;
        } else {
            this.min = l2;
            this.max = l3;
        }
    }

    public LongRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The numbers must not be null");
        }
        long l2 = number.longValue();
        long l3 = number2.longValue();
        if (l3 < l2) {
            this.min = l3;
            this.max = l2;
            if (number2 instanceof Long) {
                this.minObject = (Long)number2;
            }
            if (number instanceof Long) {
                this.maxObject = (Long)number;
            }
        } else {
            this.min = l2;
            this.max = l3;
            if (number instanceof Long) {
                this.minObject = (Long)number;
            }
            if (number2 instanceof Long) {
                this.maxObject = (Long)number2;
            }
        }
    }

    public Number getMinimumNumber() {
        if (this.minObject == null) {
            this.minObject = new Long(this.min);
        }
        return this.minObject;
    }

    public long getMinimumLong() {
        return this.min;
    }

    public int getMinimumInteger() {
        return (int)this.min;
    }

    public double getMinimumDouble() {
        return this.min;
    }

    public float getMinimumFloat() {
        return this.min;
    }

    public Number getMaximumNumber() {
        if (this.maxObject == null) {
            this.maxObject = new Long(this.max);
        }
        return this.maxObject;
    }

    public long getMaximumLong() {
        return this.max;
    }

    public int getMaximumInteger() {
        return (int)this.max;
    }

    public double getMaximumDouble() {
        return this.max;
    }

    public float getMaximumFloat() {
        return this.max;
    }

    public boolean containsNumber(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsLong(number.longValue());
    }

    public boolean containsLong(long l2) {
        return l2 >= this.min && l2 <= this.max;
    }

    public boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.containsLong(range.getMinimumLong()) && this.containsLong(range.getMaximumLong());
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.containsLong(this.min) || range.containsLong(this.max) || this.containsLong(range.getMinimumLong());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongRange)) {
            return false;
        }
        LongRange longRange = (LongRange)object;
        return this.min == longRange.min && this.max == longRange.max;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().hashCode();
            this.hashCode = 37 * this.hashCode + (int)(this.min ^ this.min >> 32);
            this.hashCode = 37 * this.hashCode + (int)(this.max ^ this.max >> 32);
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StrBuilder strBuilder = new StrBuilder(32);
            strBuilder.append("Range[");
            strBuilder.append(this.min);
            strBuilder.append(',');
            strBuilder.append(this.max);
            strBuilder.append(']');
            this.toString = strBuilder.toString();
        }
        return this.toString;
    }

    public long[] toArray() {
        long[] lArray = new long[(int)(this.max - this.min + 1L)];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = this.min + (long)i2;
        }
        return lArray;
    }
}

