/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.time;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public class DateUtils {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;
    private static final int MODIFY_TRUNCATE = 0;
    private static final int MODIFY_ROUND = 1;
    private static final int MODIFY_CEILING = 2;
    public static final int MILLIS_IN_SECOND = 1000;
    public static final int MILLIS_IN_MINUTE = 60000;
    public static final int MILLIS_IN_HOUR = 3600000;
    public static final int MILLIS_IN_DAY = 86400000;

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameInstant(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(10) == calendar2.get(10) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Date parseDate(String string, String[] stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string, stringArray, true);
    }

    public static Date parseDateStrictly(String string, String[] stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string, stringArray, false);
    }

    private static Date parseDateWithLeniency(String string, String[] stringArray, boolean bl) throws ParseException {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setLenient(bl);
        ParsePosition parsePosition = new ParsePosition(0);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Date date;
            String string2 = stringArray[i2];
            if (stringArray[i2].endsWith("ZZ")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            simpleDateFormat.applyPattern(string2);
            parsePosition.setIndex(0);
            String string3 = string;
            if (stringArray[i2].endsWith("ZZ")) {
                int n2 = DateUtils.indexOfSignChars(string3, 0);
                while (n2 >= 0) {
                    string3 = DateUtils.reformatTimezone(string3, n2);
                    ++n2;
                    n2 = DateUtils.indexOfSignChars(string3, n2);
                }
            }
            if ((date = simpleDateFormat.parse(string3, parsePosition)) == null || parsePosition.getIndex() != string3.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    private static int indexOfSignChars(String string, int n2) {
        int n3 = StringUtils.indexOf(string, '+', n2);
        if (n3 < 0) {
            n3 = StringUtils.indexOf(string, '-', n2);
        }
        return n3;
    }

    private static String reformatTimezone(String string, int n2) {
        String string2 = string;
        if (n2 >= 0 && n2 + 5 < string.length() && Character.isDigit(string.charAt(n2 + 1)) && Character.isDigit(string.charAt(n2 + 2)) && string.charAt(n2 + 3) == ':' && Character.isDigit(string.charAt(n2 + 4)) && Character.isDigit(string.charAt(n2 + 5))) {
            string2 = string.substring(0, n2 + 3) + string.substring(n2 + 4);
        }
        return string2;
    }

    public static Date addYears(Date date, int n2) {
        return DateUtils.add(date, 1, n2);
    }

    public static Date addMonths(Date date, int n2) {
        return DateUtils.add(date, 2, n2);
    }

    public static Date addWeeks(Date date, int n2) {
        return DateUtils.add(date, 3, n2);
    }

    public static Date addDays(Date date, int n2) {
        return DateUtils.add(date, 5, n2);
    }

    public static Date addHours(Date date, int n2) {
        return DateUtils.add(date, 11, n2);
    }

    public static Date addMinutes(Date date, int n2) {
        return DateUtils.add(date, 12, n2);
    }

    public static Date addSeconds(Date date, int n2) {
        return DateUtils.add(date, 13, n2);
    }

    public static Date addMilliseconds(Date date, int n2) {
        return DateUtils.add(date, 14, n2);
    }

    public static Date add(Date date, int n2, int n3) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n2, n3);
        return calendar.getTime();
    }

    public static Date setYears(Date date, int n2) {
        return DateUtils.set(date, 1, n2);
    }

    public static Date setMonths(Date date, int n2) {
        return DateUtils.set(date, 2, n2);
    }

    public static Date setDays(Date date, int n2) {
        return DateUtils.set(date, 5, n2);
    }

    public static Date setHours(Date date, int n2) {
        return DateUtils.set(date, 11, n2);
    }

    public static Date setMinutes(Date date, int n2) {
        return DateUtils.set(date, 12, n2);
    }

    public static Date setSeconds(Date date, int n2) {
        return DateUtils.set(date, 13, n2);
    }

    public static Date setMilliseconds(Date date, int n2) {
        return DateUtils.set(date, 14, n2);
    }

    private static Date set(Date date, int n2, int n3) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(n2, n3);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date round(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n2, 1);
        return calendar.getTime();
    }

    public static Calendar round(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n2, 1);
        return calendar2;
    }

    public static Date round(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    public static Date truncate(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n2, 0);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n2, 0);
        return calendar2;
    }

    public static Date truncate(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    public static Date ceiling(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n2, 2);
        return calendar.getTime();
    }

    public static Calendar ceiling(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n2, 2);
        return calendar2;
    }

    public static Date ceiling(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.ceiling((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.ceiling((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + object.getClass());
    }

    private static void modify(Calendar calendar, int n2, int n3) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n2 == 14) {
            return;
        }
        Date date = calendar.getTime();
        long l2 = date.getTime();
        boolean bl = false;
        int n4 = calendar.get(14);
        if (0 == n3 || n4 < 500) {
            l2 -= (long)n4;
        }
        if (n2 == 13) {
            bl = true;
        }
        int n5 = calendar.get(13);
        if (!(bl || 0 != n3 && n5 >= 30)) {
            l2 -= (long)n5 * 1000L;
        }
        if (n2 == 12) {
            bl = true;
        }
        int n6 = calendar.get(12);
        if (!(bl || 0 != n3 && n6 >= 30)) {
            l2 -= (long)n6 * 60000L;
        }
        if (date.getTime() != l2) {
            date.setTime(l2);
            calendar.setTime(date);
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < fields.length; ++i2) {
            int n7;
            for (n7 = 0; n7 < fields[i2].length; ++n7) {
                if (fields[i2][n7] != n2) continue;
                if (n3 == 2 || n3 == 1 && bl2) {
                    if (n2 == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                        } else {
                            calendar.add(5, -15);
                            calendar.add(2, 1);
                        }
                    } else if (n2 == 9) {
                        if (calendar.get(11) == 0) {
                            calendar.add(11, 12);
                        } else {
                            calendar.add(11, -12);
                            calendar.add(5, 1);
                        }
                    } else {
                        calendar.add(fields[i2][0], 1);
                    }
                }
                return;
            }
            n7 = 0;
            boolean bl3 = false;
            switch (n2) {
                case 1001: {
                    if (fields[i2][0] != 5) break;
                    n7 = calendar.get(5) - 1;
                    if (n7 >= 15) {
                        n7 -= 15;
                    }
                    bl2 = n7 > 7;
                    bl3 = true;
                    break;
                }
                case 9: {
                    if (fields[i2][0] != 11) break;
                    n7 = calendar.get(11);
                    if (n7 >= 12) {
                        n7 -= 12;
                    }
                    bl2 = n7 >= 6;
                    bl3 = true;
                }
            }
            if (!bl3) {
                int n8 = calendar.getActualMinimum(fields[i2][0]);
                int n9 = calendar.getActualMaximum(fields[i2][0]);
                n7 = calendar.get(fields[i2][0]) - n8;
                boolean bl4 = bl2 = n7 > (n9 - n8) / 2;
            }
            if (n7 == 0) continue;
            calendar.set(fields[i2][0], calendar.get(fields[i2][0]) - n7);
        }
        throw new IllegalArgumentException("The field " + n2 + " is not supported");
    }

    public static Iterator iterator(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.iterator(calendar, n2);
    }

    public static Iterator iterator(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = null;
        Calendar calendar3 = null;
        int n3 = 1;
        int n4 = 7;
        switch (n2) {
            case 5: 
            case 6: {
                calendar2 = DateUtils.truncate(calendar, 2);
                calendar3 = (Calendar)calendar2.clone();
                calendar3.add(2, 1);
                calendar3.add(5, -1);
                if (n2 != 6) break;
                n3 = 2;
                n4 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar2 = DateUtils.truncate(calendar, 5);
                calendar3 = DateUtils.truncate(calendar, 5);
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        n4 = 1;
                        break;
                    }
                    case 3: {
                        n3 = calendar.get(7);
                        n4 = n3 - 1;
                        break;
                    }
                    case 4: {
                        n3 = calendar.get(7) - 3;
                        n4 = calendar.get(7) + 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + n2 + " is not valid.");
            }
        }
        if (n3 < 1) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        if (n4 < 1) {
            n4 += 7;
        }
        if (n4 > 7) {
            n4 -= 7;
        }
        while (calendar2.get(7) != n3) {
            calendar2.add(5, -1);
        }
        while (calendar3.get(7) != n4) {
            calendar3.add(5, 1);
        }
        return new DateIterator(calendar2, calendar3);
    }

    public static Iterator iterator(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n2);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    public static long getFragmentInMilliseconds(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 14);
    }

    public static long getFragmentInSeconds(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 13);
    }

    public static long getFragmentInMinutes(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 12);
    }

    public static long getFragmentInHours(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 11);
    }

    public static long getFragmentInDays(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 6);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 14);
    }

    public static long getFragmentInSeconds(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 13);
    }

    public static long getFragmentInMinutes(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 12);
    }

    public static long getFragmentInHours(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 11);
    }

    public static long getFragmentInDays(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 6);
    }

    private static long getFragment(Date date, int n2, int n3) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFragment(calendar, n2, n3);
    }

    private static long getFragment(Calendar calendar, int n2, int n3) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        long l2 = DateUtils.getMillisPerUnit(n3);
        long l3 = 0L;
        switch (n2) {
            case 1: {
                l3 += (long)calendar.get(6) * 86400000L / l2;
                break;
            }
            case 2: {
                l3 += (long)calendar.get(5) * 86400000L / l2;
            }
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                l3 += (long)calendar.get(11) * 3600000L / l2;
            }
            case 11: {
                l3 += (long)calendar.get(12) * 60000L / l2;
            }
            case 12: {
                l3 += (long)calendar.get(13) * 1000L / l2;
            }
            case 13: {
                l3 += (long)(calendar.get(14) * 1) / l2;
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The fragment " + n2 + " is not supported");
            }
        }
        return l3;
    }

    public static boolean truncatedEquals(Calendar calendar, Calendar calendar2, int n2) {
        return DateUtils.truncatedCompareTo(calendar, calendar2, n2) == 0;
    }

    public static boolean truncatedEquals(Date date, Date date2, int n2) {
        return DateUtils.truncatedCompareTo(date, date2, n2) == 0;
    }

    public static int truncatedCompareTo(Calendar calendar, Calendar calendar2, int n2) {
        Calendar calendar3 = DateUtils.truncate(calendar, n2);
        Calendar calendar4 = DateUtils.truncate(calendar2, n2);
        return calendar3.getTime().compareTo(calendar4.getTime());
    }

    public static int truncatedCompareTo(Date date, Date date2, int n2) {
        Date date3 = DateUtils.truncate(date, n2);
        Date date4 = DateUtils.truncate(date2, n2);
        return date3.compareTo(date4);
    }

    private static long getMillisPerUnit(int n2) {
        long l2 = Long.MAX_VALUE;
        switch (n2) {
            case 5: 
            case 6: {
                l2 = 86400000L;
                break;
            }
            case 11: {
                l2 = 3600000L;
                break;
            }
            case 12: {
                l2 = 60000L;
                break;
            }
            case 13: {
                l2 = 1000L;
                break;
            }
            case 14: {
                l2 = 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("The unit " + n2 + " cannot be represented is milleseconds");
            }
        }
        return l2;
    }

    static class DateIterator
    implements Iterator {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar calendar, Calendar calendar2) {
            this.endFinal = calendar2;
            this.spot = calendar;
            this.spot.add(5, -1);
        }

        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        public Object next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return this.spot.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

