/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.client;

import com.contrastsecurity.thirdparty.org.apache.http.ConnectionReuseStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.HttpEntity;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpHost;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.HttpVersion;
import com.contrastsecurity.thirdparty.org.apache.http.auth.AuthSchemeRegistry;
import com.contrastsecurity.thirdparty.org.apache.http.auth.AuthScope;
import com.contrastsecurity.thirdparty.org.apache.http.auth.AuthState;
import com.contrastsecurity.thirdparty.org.apache.http.auth.Credentials;
import com.contrastsecurity.thirdparty.org.apache.http.client.config.RequestConfig;
import com.contrastsecurity.thirdparty.org.apache.http.client.params.HttpClientParamConfig;
import com.contrastsecurity.thirdparty.org.apache.http.client.protocol.RequestClientConnControl;
import com.contrastsecurity.thirdparty.org.apache.http.config.ConnectionConfig;
import com.contrastsecurity.thirdparty.org.apache.http.conn.HttpConnectionFactory;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ManagedHttpClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.RouteInfo;
import com.contrastsecurity.thirdparty.org.apache.http.entity.BufferedHttpEntity;
import com.contrastsecurity.thirdparty.org.apache.http.impl.DefaultConnectionReuseStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.impl.auth.BasicSchemeFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.auth.DigestSchemeFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.auth.HttpAuthenticator;
import com.contrastsecurity.thirdparty.org.apache.http.impl.auth.KerberosSchemeFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.auth.NTLMSchemeFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.auth.SPNegoSchemeFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.client.BasicCredentialsProvider;
import com.contrastsecurity.thirdparty.org.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.execchain.TunnelRefusedException;
import com.contrastsecurity.thirdparty.org.apache.http.message.BasicHttpRequest;
import com.contrastsecurity.thirdparty.org.apache.http.params.BasicHttpParams;
import com.contrastsecurity.thirdparty.org.apache.http.params.HttpParamConfig;
import com.contrastsecurity.thirdparty.org.apache.http.params.HttpParams;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.BasicHttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpProcessor;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpRequestExecutor;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.ImmutableHttpProcessor;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.RequestTargetHost;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.RequestUserAgent;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import com.contrastsecurity.thirdparty.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> managedHttpClientConnectionFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams httpParams) {
        this(null, HttpParamConfig.getConnectionConfig(httpParams), HttpClientParamConfig.getRequestConfig(httpParams));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost httpHost, HttpHost httpHost2, Credentials credentials) throws IOException, HttpException {
        HttpEntity httpEntity;
        int n2;
        HttpResponse httpResponse;
        Args.notNull(httpHost, "Proxy host");
        Args.notNull(httpHost2, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost httpHost3 = httpHost2;
        if (httpHost3.getPort() <= 0) {
            httpHost3 = new HttpHost(httpHost3.getHostName(), 80, httpHost3.getSchemeName());
        }
        HttpRoute httpRoute = new HttpRoute(httpHost3, this.requestConfig.getLocalAddress(), httpHost, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection managedHttpClientConnection = this.connFactory.create(httpRoute, this.connectionConfig);
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", httpHost3.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(new AuthScope(httpHost), credentials);
        basicHttpContext.setAttribute("http.target_host", httpHost2);
        basicHttpContext.setAttribute("http.connection", managedHttpClientConnection);
        basicHttpContext.setAttribute("http.request", basicHttpRequest);
        basicHttpContext.setAttribute("http.route", httpRoute);
        basicHttpContext.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        basicHttpContext.setAttribute("http.auth.credentials-provider", basicCredentialsProvider);
        basicHttpContext.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        basicHttpContext.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(basicHttpRequest, this.httpProcessor, basicHttpContext);
        while (true) {
            if (!managedHttpClientConnection.isOpen()) {
                Socket socket = new Socket(httpHost.getHostName(), httpHost.getPort());
                managedHttpClientConnection.bind(socket);
            }
            this.authenticator.generateAuthResponse(basicHttpRequest, this.proxyAuthState, basicHttpContext);
            httpResponse = this.requestExec.execute(basicHttpRequest, managedHttpClientConnection, basicHttpContext);
            n2 = httpResponse.getStatusLine().getStatusCode();
            if (n2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + httpResponse.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(httpHost, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, basicHttpContext) || !this.authenticator.handleAuthChallenge(httpHost, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, basicHttpContext)) break;
            if (this.reuseStrategy.keepAlive(httpResponse, basicHttpContext)) {
                httpEntity = httpResponse.getEntity();
                EntityUtils.consume(httpEntity);
            } else {
                managedHttpClientConnection.close();
            }
            basicHttpRequest.removeHeaders("Proxy-Authorization");
        }
        n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 > 299) {
            httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpResponse.setEntity(new BufferedHttpEntity(httpEntity));
            }
            managedHttpClientConnection.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + httpResponse.getStatusLine(), httpResponse);
        }
        return managedHttpClientConnection.getSocket();
    }
}

