/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.conn;

import com.contrastsecurity.thirdparty.org.apache.commons.logging.Log;
import com.contrastsecurity.thirdparty.org.apache.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.org.apache.http.HttpHost;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ClientConnectionOperator;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ConnectTimeoutException;
import com.contrastsecurity.thirdparty.org.apache.http.conn.DnsResolver;
import com.contrastsecurity.thirdparty.org.apache.http.conn.HttpInetSocketAddress;
import com.contrastsecurity.thirdparty.org.apache.http.conn.OperatedClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.conn.scheme.Scheme;
import com.contrastsecurity.thirdparty.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import com.contrastsecurity.thirdparty.org.apache.http.conn.scheme.SchemeRegistry;
import com.contrastsecurity.thirdparty.org.apache.http.conn.scheme.SchemeSocketFactory;
import com.contrastsecurity.thirdparty.org.apache.http.impl.conn.DefaultClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.impl.conn.SystemDefaultDnsResolver;
import com.contrastsecurity.thirdparty.org.apache.http.params.HttpConnectionParams;
import com.contrastsecurity.thirdparty.org.apache.http.params.HttpParams;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import com.contrastsecurity.thirdparty.org.apache.http.util.Asserts;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class DefaultClientConnectionOperator
implements ClientConnectionOperator {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final SchemeRegistry schemeRegistry;
    protected final DnsResolver dnsResolver;

    public DefaultClientConnectionOperator(SchemeRegistry schemeRegistry) {
        Args.notNull(schemeRegistry, "Scheme registry");
        this.schemeRegistry = schemeRegistry;
        this.dnsResolver = new SystemDefaultDnsResolver();
    }

    public DefaultClientConnectionOperator(SchemeRegistry schemeRegistry, DnsResolver dnsResolver) {
        Args.notNull(schemeRegistry, "Scheme registry");
        Args.notNull(dnsResolver, "DNS resolver");
        this.schemeRegistry = schemeRegistry;
        this.dnsResolver = dnsResolver;
    }

    @Override
    public OperatedClientConnection createConnection() {
        return new DefaultClientConnection();
    }

    private SchemeRegistry getSchemeRegistry(HttpContext httpContext) {
        SchemeRegistry schemeRegistry = (SchemeRegistry)httpContext.getAttribute("http.scheme-registry");
        if (schemeRegistry == null) {
            schemeRegistry = this.schemeRegistry;
        }
        return schemeRegistry;
    }

    @Override
    public void openConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, InetAddress inetAddress, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Args.notNull(operatedClientConnection, "Connection");
        Args.notNull(httpHost, "Target host");
        Args.notNull(httpParams, "HTTP parameters");
        Asserts.check(!operatedClientConnection.isOpen(), "Connection must not be open");
        SchemeRegistry schemeRegistry = this.getSchemeRegistry(httpContext);
        Scheme scheme = schemeRegistry.getScheme(httpHost.getSchemeName());
        SchemeSocketFactory schemeSocketFactory = scheme.getSchemeSocketFactory();
        InetAddress[] inetAddressArray = this.resolveHostname(httpHost.getHostName());
        int n2 = scheme.resolvePort(httpHost.getPort());
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            HttpInetSocketAddress httpInetSocketAddress;
            block8: {
                InetAddress inetAddress2 = inetAddressArray[i2];
                boolean bl = i2 == inetAddressArray.length - 1;
                Socket socket = schemeSocketFactory.createSocket(httpParams);
                operatedClientConnection.opening(socket, httpHost);
                httpInetSocketAddress = new HttpInetSocketAddress(httpHost, inetAddress2, n2);
                InetSocketAddress inetSocketAddress = null;
                if (inetAddress != null) {
                    inetSocketAddress = new InetSocketAddress(inetAddress, 0);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connecting to " + httpInetSocketAddress);
                }
                try {
                    Socket socket2 = schemeSocketFactory.connectSocket(socket, httpInetSocketAddress, inetSocketAddress, httpParams);
                    if (socket != socket2) {
                        socket = socket2;
                        operatedClientConnection.opening(socket, httpHost);
                    }
                    this.prepareSocket(socket, httpContext, httpParams);
                    operatedClientConnection.openCompleted(schemeSocketFactory.isSecure(socket), httpParams);
                    return;
                }
                catch (ConnectException connectException) {
                    if (bl) {
                        throw connectException;
                    }
                }
                catch (ConnectTimeoutException connectTimeoutException) {
                    if (!bl) break block8;
                    throw connectTimeoutException;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Connect to " + httpInetSocketAddress + " timed out. " + "Connection will be retried using another IP address");
        }
    }

    @Override
    public void updateSecureConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Args.notNull(operatedClientConnection, "Connection");
        Args.notNull(httpHost, "Target host");
        Args.notNull(httpParams, "Parameters");
        Asserts.check(operatedClientConnection.isOpen(), "Connection must be open");
        SchemeRegistry schemeRegistry = this.getSchemeRegistry(httpContext);
        Scheme scheme = schemeRegistry.getScheme(httpHost.getSchemeName());
        Asserts.check(scheme.getSchemeSocketFactory() instanceof SchemeLayeredSocketFactory, "Socket factory must implement SchemeLayeredSocketFactory");
        SchemeLayeredSocketFactory schemeLayeredSocketFactory = (SchemeLayeredSocketFactory)scheme.getSchemeSocketFactory();
        Socket socket = schemeLayeredSocketFactory.createLayeredSocket(operatedClientConnection.getSocket(), httpHost.getHostName(), scheme.resolvePort(httpHost.getPort()), httpParams);
        this.prepareSocket(socket, httpContext, httpParams);
        operatedClientConnection.update(socket, httpHost, schemeLayeredSocketFactory.isSecure(socket), httpParams);
    }

    protected void prepareSocket(Socket socket, HttpContext httpContext, HttpParams httpParams) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(httpParams));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(httpParams));
        int n2 = HttpConnectionParams.getLinger(httpParams);
        if (n2 >= 0) {
            socket.setSoLinger(n2 > 0, n2);
        }
    }

    protected InetAddress[] resolveHostname(String string) throws UnknownHostException {
        return this.dnsResolver.resolve(string);
    }
}

