/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.cookie;

import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.client.utils.DateUtils;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.MalformedCookieException;
import com.contrastsecurity.thirdparty.org.apache.http.cookie.SetCookie;
import com.contrastsecurity.thirdparty.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] stringArray) {
        Args.notNull(stringArray, "Array of date patterns");
        this.datepatterns = stringArray;
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date date = DateUtils.parseDate(string, this.datepatterns);
        if (date == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        setCookie.setExpiryDate(date);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

