/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginNode;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Plugin(name="AppenderSet", category="Core", printObject=true, deferChildren=true)
public class AppenderSet {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private final Configuration configuration;
    private final Map<String, Node> nodeMap;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private AppenderSet(Configuration configuration, Map<String, Node> map) {
        this.configuration = configuration;
        this.nodeMap = map;
    }

    public Appender createAppender(String string, String string2) {
        Node node = this.nodeMap.get(string);
        if (node == null) {
            LOGGER.error("No node named {} in {}", (Object)string, (Object)this);
            return null;
        }
        node.getAttributes().put("name", string2);
        if (node.getType().getElementName().equals("appender")) {
            Node node2 = new Node(node);
            this.configuration.createConfiguration(node2, null);
            if (node2.getObject() instanceof Appender) {
                Appender appender = (Appender)node2.getObject();
                appender.start();
                return appender;
            }
            LOGGER.error("Unable to create Appender of type " + node.getName());
            return null;
        }
        LOGGER.error("No Appender was configured for name {} " + string);
        return null;
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<AppenderSet> {
        @PluginNode
        private Node node;
        @PluginConfiguration
        @Required
        private Configuration configuration;

        @Override
        public AppenderSet build() {
            if (this.configuration == null) {
                LOGGER.error("Configuration is missing from AppenderSet {}", (Object)this);
                return null;
            }
            if (this.node == null) {
                LOGGER.error("No node in AppenderSet {}", (Object)this);
                return null;
            }
            List<Node> list = this.node.getChildren();
            if (list == null) {
                LOGGER.error("No children node in AppenderSet {}", (Object)this);
                return null;
            }
            HashMap<String, Node> hashMap = new HashMap<String, Node>(list.size());
            for (Node node : list) {
                String string = node.getAttributes().get("name");
                if (string == null) {
                    LOGGER.error("The attribute 'name' is missing from the node {} in AppenderSet {}", (Object)node, (Object)list);
                    continue;
                }
                hashMap.put(string, node);
            }
            return new AppenderSet(this.configuration, hashMap);
        }

        public Node getNode() {
            return this.node;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Builder withNode(Node node) {
            this.node = node;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public String toString() {
            return this.getClass().getName() + " [node=" + this.node + ", configuration=" + this.configuration + "]";
        }
    }
}

