/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.MemoryMappedFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.AbstractFilterable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Advertiser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@Plugin(name="MemoryMappedFile", category="Core", elementType="appender", printObject=true)
public final class MemoryMappedFileAppender
extends AbstractOutputStreamAppender<MemoryMappedFileManager> {
    private static final int BIT_POSITION_1GB = 30;
    private static final int MAX_REGION_LENGTH = 0x40000000;
    private static final int MIN_REGION_LENGTH = 256;
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    private MemoryMappedFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, MemoryMappedFileManager memoryMappedFileManager, String string2, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray) {
        super(string, layout, filter, bl, bl2, propertyArray, memoryMappedFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.putAll(memoryMappedFileManager.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        }
        this.fileName = string2;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRegionLength() {
        return ((MemoryMappedFileManager)this.getManager()).getRegionLength();
    }

    @Deprecated
    public static <B extends Builder<B>> MemoryMappedFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, Layout<? extends Serializable> layout, Filter filter, String string7, String string8, Configuration configuration) {
        boolean bl = Booleans.parseBoolean(string2, true);
        boolean bl2 = Booleans.parseBoolean(string4, false);
        boolean bl3 = Booleans.parseBoolean(string6, true);
        boolean bl4 = Boolean.parseBoolean(string7);
        int n2 = Integers.parseInt(string5, 0x2000000);
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)((Builder)((AbstractAppender.Builder)((Builder)((Builder)((Builder)MemoryMappedFileAppender.newBuilder()).setAdvertise(bl4)).setAdvertiseURI(string8)).setAppend(bl)).setConfiguration(configuration)).setFileName(string)).setFilter(filter)).setIgnoreExceptions(bl3)).withImmediateFlush(bl2)).setLayout(layout)).setName(string3)).setRegionLength(n2)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private static int determineValidRegionLength(String string, int n2) {
        if (n2 > 0x40000000) {
            LOGGER.info("MemoryMappedAppender[{}] Reduced region length from {} to max length: {}", (Object)string, (Object)n2, (Object)0x40000000);
            return 0x40000000;
        }
        if (n2 < 256) {
            LOGGER.info("MemoryMappedAppender[{}] Expanded region length from {} to min length: {}", (Object)string, (Object)n2, (Object)256);
            return 256;
        }
        int n3 = Integers.ceilingNextPowerOfTwo(n2);
        if (n2 != n3) {
            LOGGER.info("MemoryMappedAppender[{}] Rounded up region length from {} to next power of two: {}", (Object)string, (Object)n2, (Object)n3);
        }
        return n3;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<MemoryMappedFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;
        @PluginBuilderAttribute(value="regionLength")
        private int regionLength = 0x2000000;
        @PluginBuilderAttribute(value="advertise")
        private boolean advertise;
        @PluginBuilderAttribute(value="advertiseURI")
        private String advertiseURI;

        @Override
        public MemoryMappedFileAppender build() {
            String string = this.getName();
            int n2 = MemoryMappedFileAppender.determineValidRegionLength(string, this.regionLength);
            if (string == null) {
                LOGGER.error("No name provided for MemoryMappedFileAppender");
                return null;
            }
            if (this.fileName == null) {
                LOGGER.error("No filename provided for MemoryMappedFileAppender with name " + string);
                return null;
            }
            Layout<Serializable> layout = this.getOrCreateLayout();
            MemoryMappedFileManager memoryMappedFileManager = MemoryMappedFileManager.getFileManager(this.fileName, this.append, this.isImmediateFlush(), n2, this.advertiseURI, layout);
            if (memoryMappedFileManager == null) {
                return null;
            }
            return new MemoryMappedFileAppender(string, layout, this.getFilter(), memoryMappedFileManager, this.fileName, this.isIgnoreExceptions(), false, this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public B setFileName(String string) {
            this.fileName = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setAppend(boolean bl) {
            this.append = bl;
            return (B)((Builder)this.asBuilder());
        }

        public B setRegionLength(int n2) {
            this.regionLength = n2;
            return (B)((Builder)this.asBuilder());
        }

        public B setAdvertise(boolean bl) {
            this.advertise = bl;
            return (B)((Builder)this.asBuilder());
        }

        public B setAdvertiseURI(String string) {
            this.advertiseURI = string;
            return (B)((Builder)this.asBuilder());
        }
    }
}

