/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.OutputStreamManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Closer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.FileUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NullOutputStream;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Constants;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MemoryMappedFileManager
extends OutputStreamManager {
    static final int DEFAULT_REGION_LENGTH = 0x2000000;
    private static final int MAX_REMAP_COUNT = 10;
    private static final MemoryMappedFileManagerFactory FACTORY = new MemoryMappedFileManagerFactory();
    private static final double NANOS_PER_MILLISEC = 1000000.0;
    private final boolean immediateFlush;
    private final int regionLength;
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;
    private MappedByteBuffer mappedBuffer;
    private long mappingOffset;

    protected MemoryMappedFileManager(RandomAccessFile randomAccessFile, String string, OutputStream outputStream, boolean bl, long l2, int n2, String string2, Layout<? extends Serializable> layout, boolean bl2) throws IOException {
        super(outputStream, string, layout, bl2, ByteBuffer.wrap(Constants.EMPTY_BYTE_ARRAY));
        this.immediateFlush = bl;
        this.randomAccessFile = Objects.requireNonNull(randomAccessFile, "RandomAccessFile");
        this.regionLength = n2;
        this.advertiseURI = string2;
        this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), l2, n2);
        this.byteBuffer = this.mappedBuffer;
        this.mappingOffset = l2;
    }

    public static MemoryMappedFileManager getFileManager(String string, boolean bl, boolean bl2, int n2, String string2, Layout<? extends Serializable> layout) {
        return MemoryMappedFileManager.narrow(MemoryMappedFileManager.class, MemoryMappedFileManager.getManager(string, new FactoryData(bl, bl2, n2, string2, layout), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean bl) {
    }

    @Override
    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl) {
        while (n3 > this.mappedBuffer.remaining()) {
            int n4 = this.mappedBuffer.remaining();
            this.mappedBuffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.remap();
        }
        this.mappedBuffer.put(byArray, n2, n3);
    }

    private synchronized void remap() {
        long l2 = this.mappingOffset + (long)this.mappedBuffer.position();
        int n2 = this.mappedBuffer.remaining() + this.regionLength;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
            long l3 = this.randomAccessFile.length() + (long)this.regionLength;
            LOGGER.debug("{} {} extending {} by {} bytes to {}", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)this.getFileName(), (Object)this.regionLength, (Object)l3);
            long l4 = System.nanoTime();
            this.randomAccessFile.setLength(l3);
            float f2 = (float)((double)(System.nanoTime() - l4) / 1000000.0);
            LOGGER.debug("{} {} extended {} OK in {} millis", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)this.getFileName(), (Object)Float.valueOf(f2));
            this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), l2, n2);
            this.byteBuffer = this.mappedBuffer;
            this.mappingOffset = l2;
        }
        catch (Exception exception) {
            this.logError("Unable to remap", exception);
        }
    }

    @Override
    public synchronized void flush() {
        this.mappedBuffer.force();
    }

    @Override
    public synchronized boolean closeOutputStream() {
        long l2 = this.mappedBuffer.position();
        long l3 = this.mappingOffset + l2;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
        }
        catch (Exception exception) {
            this.logError("Unable to unmap MappedBuffer", exception);
        }
        try {
            LOGGER.debug("MMapAppender closing. Setting {} length to {} (offset {} + position {})", (Object)this.getFileName(), (Object)l3, (Object)this.mappingOffset, (Object)l2);
            this.randomAccessFile.setLength(l3);
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            this.logError("Unable to close MemoryMappedFile", iOException);
            return false;
        }
    }

    public static MappedByteBuffer mmap(FileChannel fileChannel, String string, long l2, int n2) throws IOException {
        int n3 = 1;
        while (true) {
            try {
                LOGGER.debug("MMapAppender remapping {} start={}, size={}", (Object)string, (Object)l2, (Object)n2);
                long l3 = System.nanoTime();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l2, n2);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                float f2 = (float)((double)(System.nanoTime() - l3) / 1000000.0);
                LOGGER.debug("MMapAppender remapped {} OK in {} millis", (Object)string, (Object)Float.valueOf(f2));
                return mappedByteBuffer;
            }
            catch (IOException iOException) {
                if (iOException.getMessage() == null || !iOException.getMessage().endsWith("user-mapped section open")) {
                    throw iOException;
                }
                LOGGER.debug("Remap attempt {}/{} failed. Retrying...", (Object)n3, (Object)10, (Object)iOException);
                if (n3 < 10) {
                    Thread.yield();
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw iOException;
                    }
                }
                ++n3;
                continue;
            }
            break;
        }
    }

    private static void unsafeUnmap(MappedByteBuffer mappedByteBuffer) throws PrivilegedActionException {
        LOGGER.debug("MMapAppender unmapping old buffer...");
        long l2 = System.nanoTime();
        AccessController.doPrivileged(() -> {
            Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)mappedByteBuffer, new Object[0]);
            Method method2 = object.getClass().getMethod("clean", new Class[0]);
            method2.invoke(object, new Object[0]);
            return null;
        });
        float f2 = (float)((double)(System.nanoTime() - l2) / 1000000.0);
        LOGGER.debug("MMapAppender unmapped buffer OK in {} millis", (Object)Float.valueOf(f2));
    }

    public String getFileName() {
        return this.getName();
    }

    public int getRegionLength() {
        return this.regionLength;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("fileURI", this.advertiseURI);
        return hashMap;
    }

    @Override
    protected void flushBuffer(ByteBuffer byteBuffer) {
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mappedBuffer;
    }

    @Override
    public ByteBuffer drain(ByteBuffer byteBuffer) {
        this.remap();
        return this.mappedBuffer;
    }

    private static class MemoryMappedFileManagerFactory
    implements ManagerFactory<MemoryMappedFileManager, FactoryData> {
        private MemoryMappedFileManagerFactory() {
        }

        @Override
        public MemoryMappedFileManager createManager(String string, FactoryData factoryData) {
            File file = new File(string);
            if (!factoryData.append) {
                file.delete();
            }
            boolean bl = !factoryData.append || !file.exists();
            NullOutputStream nullOutputStream = NullOutputStream.getInstance();
            RandomAccessFile randomAccessFile = null;
            try {
                FileUtils.makeParentDirs(file);
                randomAccessFile = new RandomAccessFile(string, "rw");
                long l2 = factoryData.append ? randomAccessFile.length() : 0L;
                randomAccessFile.setLength(l2 + (long)factoryData.regionLength);
                return new MemoryMappedFileManager(randomAccessFile, string, nullOutputStream, factoryData.immediateFlush, l2, factoryData.regionLength, factoryData.advertiseURI, factoryData.layout, bl);
            }
            catch (Exception exception) {
                AbstractManager.LOGGER.error("MemoryMappedFileManager (" + string + ") " + exception, (Throwable)exception);
                Closer.closeSilently(randomAccessFile);
                return null;
            }
        }
    }

    private static class FactoryData {
        private final boolean append;
        private final boolean immediateFlush;
        private final int regionLength;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;

        public FactoryData(boolean bl, boolean bl2, int n2, String string, Layout<? extends Serializable> layout) {
            this.append = bl;
            this.immediateFlush = bl2;
            this.regionLength = n2;
            this.advertiseURI = string;
            this.layout = layout;
        }
    }
}

