/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.AbstractFilterable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Advertiser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@Plugin(name="RollingFile", category="Core", elementType="appender", printObject=true)
public final class RollingFileAppender
extends AbstractOutputStreamAppender<RollingFileManager> {
    public static final String PLUGIN_NAME = "RollingFile";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final String fileName;
    private final String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;

    private RollingFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, RollingFileManager rollingFileManager, String string2, String string3, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray) {
        super(string, layout, filter, bl, bl2, propertyArray, rollingFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        }
        this.fileName = string2;
        this.filePattern = string3;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl = super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return bl;
    }

    @Override
    public void append(LogEvent logEvent) {
        ((RollingFileManager)this.getManager()).checkRollover(logEvent);
        super.append(logEvent);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return ((RollingFileManager)this.getManager()).getTriggeringPolicy();
    }

    @Deprecated
    public static <B extends Builder<B>> RollingFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, String string7, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, Layout<? extends Serializable> layout, Filter filter, String string8, String string9, String string10, Configuration configuration) {
        int n2 = Integers.parseInt(string6, 8192);
        return ((Builder)((Builder)((Builder)((AbstractAppender.Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)((Builder)((Builder)((Builder)((Builder)((AbstractOutputStreamAppender.Builder)((Builder)((Builder)((Builder)RollingFileAppender.newBuilder()).withAdvertise(Boolean.parseBoolean(string9))).withAdvertiseUri(string10)).withAppend(Booleans.parseBoolean(string3, true))).withBufferedIo(Booleans.parseBoolean(string5, true))).withBufferSize(n2)).setConfiguration(configuration)).withFileName(string)).withFilePattern(string2)).setFilter(filter)).setIgnoreExceptions(Booleans.parseBoolean(string8, true))).withImmediateFlush(Booleans.parseBoolean(string7, true))).setLayout(layout)).withCreateOnDemand(false)).withLocking(false)).setName(string4)).withPolicy(triggeringPolicy)).withStrategy(rolloverStrategy)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<RollingFileAppender> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        @Override
        public RollingFileAppender build() {
            if (!this.isValid()) {
                return null;
            }
            boolean bl = this.isBufferedIo();
            int n2 = this.getBufferSize();
            if (!bl && n2 > 0) {
                LOGGER.warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)n2);
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a {} must be configured", (Object)this.getName(), (Object)DirectFileRolloverStrategy.class.getSimpleName());
                return null;
            }
            Layout<Serializable> layout = this.getOrCreateLayout();
            RollingFileManager rollingFileManager = RollingFileManager.getFileManager(this.fileName, this.filePattern, this.append, bl, this.policy, this.strategy, this.advertiseUri, layout, n2, this.isImmediateFlush(), this.createOnDemand, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
            if (rollingFileManager == null) {
                return null;
            }
            rollingFileManager.initialize();
            return new RollingFileAppender(this.getName(), layout, this.getFilter(), rollingFileManager, this.fileName, this.filePattern, this.isIgnoreExceptions(), !bl || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        public B withAdvertise(boolean bl) {
            this.advertise = bl;
            return (B)((Builder)this.asBuilder());
        }

        public B withAdvertiseUri(String string) {
            this.advertiseUri = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withAppend(boolean bl) {
            this.append = bl;
            return (B)((Builder)this.asBuilder());
        }

        public B withFileName(String string) {
            this.fileName = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withCreateOnDemand(boolean bl) {
            this.createOnDemand = bl;
            return (B)((Builder)this.asBuilder());
        }

        public B withLocking(boolean bl) {
            this.locking = bl;
            return (B)((Builder)this.asBuilder());
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public TriggeringPolicy getPolicy() {
            return this.policy;
        }

        public RolloverStrategy getStrategy() {
            return this.strategy;
        }

        public B withFilePattern(String string) {
            this.filePattern = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withPolicy(TriggeringPolicy triggeringPolicy) {
            this.policy = triggeringPolicy;
            return (B)((Builder)this.asBuilder());
        }

        public B withStrategy(RolloverStrategy rolloverStrategy) {
            this.strategy = rolloverStrategy;
            return (B)((Builder)this.asBuilder());
        }

        public B withFilePermissions(String string) {
            this.filePermissions = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withFileOwner(String string) {
            this.fileOwner = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withFileGroup(String string) {
            this.fileGroup = string;
            return (B)((Builder)this.asBuilder());
        }
    }
}

