/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.AppenderControl;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThread;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

class ScopedAsyncAppenderEventDispatcher
extends Log4jThread {
    private static final LogEvent STOP_EVENT = new Log4jLogEvent();
    private static final AtomicLong THREAD_COUNTER = new AtomicLong(0L);
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AppenderControl errorAppender;
    private final List<AppenderControl> appenders;
    private final BlockingQueue<LogEvent> queue;
    private final AtomicBoolean stoppedRef;

    ScopedAsyncAppenderEventDispatcher(String string, AppenderControl appenderControl, List<AppenderControl> list, BlockingQueue<LogEvent> blockingQueue) {
        super("AsyncAppenderEventDispatcher-" + THREAD_COUNTER.incrementAndGet() + "-" + string);
        this.setDaemon(true);
        this.errorAppender = appenderControl;
        this.appenders = list;
        this.queue = blockingQueue;
        this.stoppedRef = new AtomicBoolean();
    }

    List<Appender> getAppenders() {
        return this.appenders.stream().map(AppenderControl::getAppender).collect(Collectors.toList());
    }

    @Override
    @ScopedSensor
    public void run() {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        ScopedAsyncAppenderEventDispatcher scopedAsyncAppenderEventDispatcher = this;
        try {
            LOGGER.trace("{} has started.", (Object)scopedAsyncAppenderEventDispatcher.getName());
            scopedAsyncAppenderEventDispatcher.dispatchAll();
            scopedAsyncAppenderEventDispatcher.dispatchRemaining();
            scopedAsyncAppenderEventDispatcher = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (scopedAsyncAppenderEventDispatcher != null) {
            throw scopedAsyncAppenderEventDispatcher;
        }
    }

    private void dispatchAll() {
        while (!this.stoppedRef.get()) {
            LogEvent logEvent;
            try {
                logEvent = this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
                break;
            }
            if (logEvent == STOP_EVENT) break;
            logEvent.setEndOfBatch(this.queue.isEmpty());
            this.dispatch(logEvent);
        }
        LOGGER.trace("{} has stopped.", (Object)this.getName());
    }

    private void dispatchRemaining() {
        LogEvent logEvent;
        int n2 = 0;
        while ((logEvent = (LogEvent)this.queue.poll()) != null) {
            if (logEvent == STOP_EVENT) continue;
            logEvent.setEndOfBatch(this.queue.isEmpty());
            this.dispatch(logEvent);
            ++n2;
        }
        LOGGER.trace("{} has processed the last {} remaining event(s).", (Object)this.getName(), (Object)n2);
    }

    void dispatch(LogEvent logEvent) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.appenders.size(); ++i2) {
            AppenderControl appenderControl = this.appenders.get(i2);
            try {
                appenderControl.callAppender(logEvent);
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                LOGGER.trace("{} has failed to call appender {}", (Object)this.getName(), (Object)appenderControl.getAppenderName(), (Object)throwable);
            }
        }
        if (!bl && this.errorAppender != null) {
            try {
                this.errorAppender.callAppender(logEvent);
            }
            catch (Throwable throwable) {
                LOGGER.trace("{} has failed to call the error appender {}", (Object)this.getName(), (Object)this.errorAppender.getAppenderName(), (Object)throwable);
            }
        }
    }

    void stop(long l2) throws InterruptedException {
        boolean bl = this.stoppedRef.compareAndSet(false, true);
        if (bl) {
            LOGGER.trace("{} is signaled to stop.", (Object)this.getName());
        }
        while (Thread.State.NEW.equals((Object)this.getState())) {
        }
        boolean bl2 = this.queue.offer(STOP_EVENT);
        if (!bl2) {
            this.interrupt();
        }
        this.join(l2);
    }
}

