/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.DefaultConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.ThresholdFilter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.AbstractStringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.HtmlLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.MailManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.MailManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.SmtpManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.ServiceLoaderUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;

@Plugin(name="SMTP", category="Core", elementType="appender", printObject=true)
public final class SmtpAppender
extends AbstractAppender {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final MailManager manager;

    private SmtpAppender(String string, Filter filter, Layout<? extends Serializable> layout, MailManager mailManager, boolean bl, Property[] propertyArray) {
        super(string, filter, layout, bl, propertyArray);
        this.manager = mailManager;
    }

    public MailManager getManager() {
        return this.manager;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static SmtpAppender createAppender(@PluginConfiguration Configuration configuration, @PluginAttribute(value="name") @Required String string, @PluginAttribute(value="to") String string2, @PluginAttribute(value="cc") String string3, @PluginAttribute(value="bcc") String string4, @PluginAttribute(value="from") String string5, @PluginAttribute(value="replyTo") String string6, @PluginAttribute(value="subject") String string7, @PluginAttribute(value="smtpProtocol") String string8, @PluginAttribute(value="smtpHost") String string9, @PluginAttribute(value="smtpPort", defaultString="0") @ValidPort String string10, @PluginAttribute(value="smtpUsername") String string11, @PluginAttribute(value="smtpPassword", sensitive=true) String string12, @PluginAttribute(value="smtpDebug") String string13, @PluginAttribute(value="bufferSize") String string14, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String string15) {
        if (string == null) {
            LOGGER.error("No name provided for SmtpAppender");
            return null;
        }
        return ((Builder)((Builder)((Builder)SmtpAppender.newBuilder().setIgnoreExceptions(Booleans.parseBoolean(string15, true))).setSmtpPort(AbstractAppender.parseInt(string10, 0)).setSmtpDebug(Boolean.parseBoolean(string13)).setBufferSize(string14 == null ? 512 : Integers.parseInt(string14)).setLayout((Layout)layout)).setFilter(filter).setConfiguration(configuration != null ? configuration : new DefaultConfiguration())).build();
    }

    @Override
    public boolean isFiltered(LogEvent logEvent) {
        boolean bl = super.isFiltered(logEvent);
        if (bl) {
            this.manager.add(logEvent);
        }
        return bl;
    }

    @Override
    public void append(LogEvent logEvent) {
        this.manager.sendEvents(this.getLayout(), logEvent);
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<SmtpAppender> {
        @PluginBuilderAttribute
        private String to;
        @PluginBuilderAttribute
        private String cc;
        @PluginBuilderAttribute
        private String bcc;
        @PluginBuilderAttribute
        private String from;
        @PluginBuilderAttribute
        private String replyTo;
        @PluginBuilderAttribute
        private String subject;
        @PluginBuilderAttribute
        private String smtpProtocol = "smtp";
        @PluginBuilderAttribute
        private String smtpHost;
        @PluginBuilderAttribute
        @ValidPort
        private int smtpPort;
        @PluginBuilderAttribute
        private String smtpUsername;
        @PluginBuilderAttribute(sensitive=true)
        private String smtpPassword;
        @PluginBuilderAttribute
        private boolean smtpDebug;
        @PluginBuilderAttribute
        private int bufferSize = 512;
        @PluginElement(value="SSL")
        private SslConfiguration sslConfiguration;

        public Builder setTo(String string) {
            this.to = string;
            return this;
        }

        public Builder setCc(String string) {
            this.cc = string;
            return this;
        }

        public Builder setBcc(String string) {
            this.bcc = string;
            return this;
        }

        public Builder setFrom(String string) {
            this.from = string;
            return this;
        }

        public Builder setReplyTo(String string) {
            this.replyTo = string;
            return this;
        }

        public Builder setSubject(String string) {
            this.subject = string;
            return this;
        }

        public Builder setSmtpProtocol(String string) {
            this.smtpProtocol = string;
            return this;
        }

        public Builder setSmtpHost(String string) {
            this.smtpHost = string;
            return this;
        }

        public Builder setSmtpPort(int n2) {
            this.smtpPort = n2;
            return this;
        }

        public Builder setSmtpUsername(String string) {
            this.smtpUsername = string;
            return this;
        }

        public Builder setSmtpPassword(String string) {
            this.smtpPassword = string;
            return this;
        }

        public Builder setSmtpDebug(boolean bl) {
            this.smtpDebug = bl;
            return this;
        }

        public Builder setBufferSize(int n2) {
            this.bufferSize = n2;
            return this;
        }

        public Builder setSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        @Override
        public Builder setLayout(Layout<? extends Serializable> layout) {
            return (Builder)super.setLayout(layout);
        }

        @Override
        public Builder setFilter(Filter filter) {
            return (Builder)super.setFilter(filter);
        }

        @Override
        public SmtpAppender build() {
            if (this.getLayout() == null) {
                this.setLayout((Layout)HtmlLayout.createDefaultLayout());
            }
            if (this.getFilter() == null) {
                this.setFilter(ThresholdFilter.createFilter(null, null, null));
            }
            if (Strings.isEmpty(this.smtpProtocol)) {
                this.smtpProtocol = "smtp";
            }
            AbstractStringLayout.Serializer serializer = PatternLayout.newSerializerBuilder().setConfiguration(this.getConfiguration()).setPattern(this.subject).build();
            MailManager.FactoryData factoryData = new MailManager.FactoryData(this.to, this.cc, this.bcc, this.from, this.replyTo, this.subject, serializer, this.smtpProtocol, this.smtpHost, this.smtpPort, this.smtpUsername, this.smtpPassword, this.smtpDebug, this.bufferSize, this.sslConfiguration, this.getFilter().toString());
            MailManagerFactory mailManagerFactory = ServiceLoaderUtil.loadServices(MailManagerFactory.class, MethodHandles.lookup()).findAny().orElseGet(() -> SmtpManager.FACTORY);
            MailManager mailManager = AbstractManager.getManager(factoryData.getManagerName(), mailManagerFactory, factoryData);
            if (mailManager == null) {
                LOGGER.error("Unabled to instantiate SmtpAppender named {}", (Object)this.getName());
                return null;
            }
            return new SmtpAppender(this.getName(), this.getFilter(), this.getLayout(), mailManager, this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }
}

