/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAliases;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.AbstractSocketManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Advertiser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.DatagramSocketManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Protocol;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.SocketOptions;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.SslSocketManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.TcpSocketManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Booleans;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@Plugin(name="Socket", category="Core", elementType="appender", printObject=true)
public class SocketAppender
extends AbstractOutputStreamAppender<AbstractSocketManager> {
    private final Object advertisement;
    private final Advertiser advertiser;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    protected SocketAppender(String string, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager abstractSocketManager, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray) {
        super(string, layout, filter, bl, bl2, propertyArray, abstractSocketManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.putAll(abstractSocketManager.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        } else {
            this.advertisement = null;
        }
        this.advertiser = advertiser;
    }

    @Deprecated
    protected SocketAppender(String string, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager abstractSocketManager, boolean bl, boolean bl2, Advertiser advertiser) {
        this(string, layout, filter, abstractSocketManager, bl, bl2, advertiser, Property.EMPTY_ARRAY);
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Deprecated
    @PluginFactory
    public static SocketAppender createAppender(String string, int n2, Protocol protocol, SslConfiguration sslConfiguration, int n3, int n4, boolean bl, String string2, boolean bl2, boolean bl3, Layout<? extends Serializable> layout, Filter filter, boolean bl4, Configuration configuration) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)SocketAppender.newBuilder().setAdvertise(bl4)).setConfiguration(configuration)).setConnectTimeoutMillis(n3)).setFilter(filter)).setHost(string)).setIgnoreExceptions(bl3)).setImmediateFail(bl)).setLayout(layout)).setName(string2)).setPort(n2)).setProtocol(protocol)).setReconnectDelayMillis(n4)).setSslConfiguration(sslConfiguration)).build();
    }

    @Deprecated
    public static SocketAppender createAppender(String string, String string2, String string3, SslConfiguration sslConfiguration, int n2, String string4, String string5, String string6, String string7, String string8, Layout<? extends Serializable> layout, Filter filter, String string9, Configuration configuration) {
        boolean bl = Booleans.parseBoolean(string7, true);
        boolean bl2 = Boolean.parseBoolean(string9);
        boolean bl3 = Booleans.parseBoolean(string8, true);
        boolean bl4 = Booleans.parseBoolean(string5, true);
        int n3 = AbstractAppender.parseInt(string4, 0);
        int n4 = AbstractAppender.parseInt(string2, 0);
        Protocol protocol = string3 == null ? Protocol.UDP : Protocol.valueOf(string3);
        return SocketAppender.createAppender(string, n4, protocol, sslConfiguration, n2, n3, bl4, string6, bl, bl3, layout, filter, bl2, configuration);
    }

    @Deprecated
    protected static AbstractSocketManager createSocketManager(String string, Protocol protocol, String string2, int n2, int n3, SslConfiguration sslConfiguration, int n4, boolean bl, Layout<? extends Serializable> layout, int n5) {
        return SocketAppender.createSocketManager(string, protocol, string2, n2, n3, sslConfiguration, n4, bl, layout, n5, null);
    }

    protected static AbstractSocketManager createSocketManager(String string, Protocol protocol, String string2, int n2, int n3, SslConfiguration sslConfiguration, int n4, boolean bl, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        if (protocol == Protocol.TCP && sslConfiguration != null) {
            protocol = Protocol.SSL;
        }
        if (protocol != Protocol.SSL && sslConfiguration != null) {
            LOGGER.info("Appender {} ignoring SSL configuration for {} protocol", (Object)string, (Object)protocol);
        }
        switch (protocol) {
            case TCP: {
                return TcpSocketManager.getSocketManager(string2, n2, n3, n4, bl, layout, n5, socketOptions);
            }
            case UDP: {
                return DatagramSocketManager.getSocketManager(string2, n2, layout, n5);
            }
            case SSL: {
                return SslSocketManager.getSocketManager(sslConfiguration, string2, n2, n3, n4, bl, layout, n5, socketOptions);
            }
        }
        throw new IllegalArgumentException(protocol.toString());
    }

    @Override
    protected void directEncodeEvent(LogEvent logEvent) {
        this.writeByteArrayToManager(logEvent);
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<SocketAppender> {
        @Override
        public SocketAppender build() {
            Protocol protocol;
            boolean bl = this.isImmediateFlush();
            boolean bl2 = this.isBufferedIo();
            Layout<Serializable> layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for SocketAppender");
                return null;
            }
            String string = this.getName();
            if (string == null) {
                LOGGER.error("No name provided for SocketAppender");
                return null;
            }
            Protocol protocol2 = this.getProtocol();
            Protocol protocol3 = protocol = protocol2 != null ? protocol2 : Protocol.TCP;
            if (protocol == Protocol.UDP) {
                bl = true;
            }
            AbstractSocketManager abstractSocketManager = SocketAppender.createSocketManager(string, protocol, this.getHost(), this.getPort(), this.getConnectTimeoutMillis(), this.getSslConfiguration(), this.getReconnectDelayMillis(), this.getImmediateFail(), layout, this.getBufferSize(), this.getSocketOptions());
            return new SocketAppender(string, layout, this.getFilter(), abstractSocketManager, this.isIgnoreExceptions(), !bl2 || bl, this.getAdvertise() ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends AbstractOutputStreamAppender.Builder<B> {
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private int connectTimeoutMillis;
        @PluginBuilderAttribute
        @ValidHost
        private String host = "localhost";
        @PluginBuilderAttribute
        private boolean immediateFail = true;
        @PluginBuilderAttribute
        @ValidPort
        private int port;
        @PluginBuilderAttribute
        private Protocol protocol = Protocol.TCP;
        @PluginBuilderAttribute
        @PluginAliases(value={"reconnectDelay", "reconnectionDelay", "delayMillis", "reconnectionDelayMillis"})
        private int reconnectDelayMillis;
        @PluginElement(value="SocketOptions")
        private SocketOptions socketOptions;
        @PluginElement(value="SslConfiguration")
        @PluginAliases(value={"SslConfig"})
        private SslConfiguration sslConfiguration;

        public boolean getAdvertise() {
            return this.advertise;
        }

        public int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public SslConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }

        public boolean getImmediateFail() {
            return this.immediateFail;
        }

        public B setAdvertise(boolean bl) {
            this.advertise = bl;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setConnectTimeoutMillis(int n2) {
            this.connectTimeoutMillis = n2;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setHost(String string) {
            this.host = string;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setImmediateFail(boolean bl) {
            this.immediateFail = bl;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setPort(int n2) {
            this.port = n2;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setProtocol(Protocol protocol) {
            this.protocol = protocol;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setReconnectDelayMillis(int n2) {
            this.reconnectDelayMillis = n2;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setSocketOptions(SocketOptions socketOptions) {
            this.socketOptions = socketOptions;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public B setSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withAdvertise(boolean bl) {
            this.advertise = bl;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withConnectTimeoutMillis(int n2) {
            this.connectTimeoutMillis = n2;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withHost(String string) {
            this.host = string;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withImmediateFail(boolean bl) {
            this.immediateFail = bl;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withPort(int n2) {
            this.port = n2;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withProtocol(Protocol protocol) {
            this.protocol = protocol;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withReconnectDelayMillis(int n2) {
            this.reconnectDelayMillis = n2;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withSocketOptions(SocketOptions socketOptions) {
            this.socketOptions = socketOptions;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        @Deprecated
        public B withSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public int getReconnectDelayMillis() {
            return this.reconnectDelayMillis;
        }

        public SocketOptions getSocketOptions() {
            return this.socketOptions;
        }
    }
}

