/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.nosql;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.nosql.NoSqlConnection;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Closer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.KeyValuePair;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.MapMessage;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Stream;

public final class NoSqlDatabaseManager<W>
extends AbstractDatabaseManager {
    private static final NoSQLDatabaseManagerFactory FACTORY = new NoSQLDatabaseManagerFactory();
    private final NoSqlProvider<NoSqlConnection<W, ? extends NoSqlObject<W>>> provider;
    private NoSqlConnection<W, ? extends NoSqlObject<W>> connection;
    private final KeyValuePair[] additionalFields;

    @Deprecated
    public static NoSqlDatabaseManager<?> getNoSqlDatabaseManager(String string, int n2, NoSqlProvider<?> noSqlProvider) {
        return (NoSqlDatabaseManager)AbstractDatabaseManager.getManager(string, new FactoryData(null, n2, noSqlProvider, null), FACTORY);
    }

    public static NoSqlDatabaseManager<?> getNoSqlDatabaseManager(String string, int n2, NoSqlProvider<?> noSqlProvider, KeyValuePair[] keyValuePairArray, Configuration configuration) {
        return (NoSqlDatabaseManager)AbstractDatabaseManager.getManager(string, new FactoryData(configuration, n2, noSqlProvider, keyValuePairArray), FACTORY);
    }

    private NoSqlDatabaseManager(String string, int n2, NoSqlProvider<NoSqlConnection<W, ? extends NoSqlObject<W>>> noSqlProvider, KeyValuePair[] keyValuePairArray, Configuration configuration) {
        super(string, n2, null, configuration);
        this.provider = noSqlProvider;
        this.additionalFields = keyValuePairArray;
    }

    private NoSqlObject<W> buildMarkerEntity(Marker marker) {
        NoSqlObject<W> noSqlObject = this.connection.createObject();
        noSqlObject.set("name", marker.getName());
        Marker[] markerArray = marker.getParents();
        if (markerArray != null) {
            NoSqlObject[] noSqlObjectArray = new NoSqlObject[markerArray.length];
            for (int i2 = 0; i2 < markerArray.length; ++i2) {
                noSqlObjectArray[i2] = this.buildMarkerEntity(markerArray[i2]);
            }
            noSqlObject.set("parents", noSqlObjectArray);
        }
        return noSqlObject;
    }

    @Override
    protected boolean commitAndClose() {
        return true;
    }

    @Override
    protected void connectAndStart() {
        try {
            this.connection = this.provider.getConnection();
        }
        catch (Exception exception) {
            throw new AppenderLoggingException("Failed to get connection from NoSQL connection provider.", exception);
        }
    }

    private NoSqlObject<W>[] convertStackTrace(StackTraceElement[] stackTraceElementArray) {
        NoSqlObject[] noSqlObjectArray = this.connection.createList(stackTraceElementArray.length);
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            noSqlObjectArray[i2] = this.convertStackTraceElement(stackTraceElementArray[i2]);
        }
        return noSqlObjectArray;
    }

    private NoSqlObject<W> convertStackTraceElement(StackTraceElement stackTraceElement) {
        NoSqlObject<W> noSqlObject = this.connection.createObject();
        noSqlObject.set("className", stackTraceElement.getClassName());
        noSqlObject.set("methodName", stackTraceElement.getMethodName());
        noSqlObject.set("fileName", stackTraceElement.getFileName());
        noSqlObject.set("lineNumber", stackTraceElement.getLineNumber());
        return noSqlObject;
    }

    private void setAdditionalFields(NoSqlObject<W> noSqlObject) {
        if (this.additionalFields != null) {
            NoSqlObject noSqlObject2 = this.connection.createObject();
            StrSubstitutor strSubstitutor = this.getStrSubstitutor();
            Stream.of(this.additionalFields).forEach(keyValuePair -> noSqlObject2.set(keyValuePair.getKey(), strSubstitutor != null ? strSubstitutor.replace(keyValuePair.getValue()) : keyValuePair.getValue()));
            noSqlObject.set("additionalFields", noSqlObject2);
        }
    }

    private void setFields(LogEvent logEvent, NoSqlObject<W> noSqlObject) {
        NoSqlObject noSqlObject2;
        Object object2;
        noSqlObject.set("level", logEvent.getLevel());
        noSqlObject.set("loggerName", logEvent.getLoggerName());
        noSqlObject.set("message", logEvent.getMessage() == null ? null : logEvent.getMessage().getFormattedMessage());
        StackTraceElement stackTraceElement = logEvent.getSource();
        if (stackTraceElement == null) {
            noSqlObject.set("source", (Object)null);
        } else {
            noSqlObject.set("source", this.convertStackTraceElement(stackTraceElement));
        }
        Marker marker = logEvent.getMarker();
        if (marker == null) {
            noSqlObject.set("marker", (Object)null);
        } else {
            noSqlObject.set("marker", this.buildMarkerEntity(marker));
        }
        noSqlObject.set("threadId", logEvent.getThreadId());
        noSqlObject.set("threadName", logEvent.getThreadName());
        noSqlObject.set("threadPriority", logEvent.getThreadPriority());
        noSqlObject.set("millis", logEvent.getTimeMillis());
        noSqlObject.set("date", new Date(logEvent.getTimeMillis()));
        Throwable throwable = logEvent.getThrown();
        if (throwable == null) {
            noSqlObject.set("thrown", (Object)null);
        } else {
            object2 = this.connection.createObject();
            noSqlObject2 = object2;
            noSqlObject2.set("type", throwable.getClass().getName());
            noSqlObject2.set("message", throwable.getMessage());
            noSqlObject2.set("stackTrace", this.convertStackTrace(throwable.getStackTrace()));
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
                NoSqlObject noSqlObject3 = this.connection.createObject();
                noSqlObject3.set("type", throwable.getClass().getName());
                noSqlObject3.set("message", throwable.getMessage());
                noSqlObject3.set("stackTrace", this.convertStackTrace(throwable.getStackTrace()));
                noSqlObject2.set("cause", noSqlObject3);
                noSqlObject2 = noSqlObject3;
            }
            noSqlObject.set("thrown", (NoSqlObject<W>)object2);
        }
        object2 = logEvent.getContextData();
        if (object2 == null) {
            noSqlObject.set("contextMap", (Object)null);
        } else {
            noSqlObject2 = this.connection.createObject();
            object2.forEach((string, object) -> noSqlObject2.set((String)string, object));
            noSqlObject.set("contextMap", noSqlObject2);
        }
        noSqlObject2 = logEvent.getContextStack();
        if (noSqlObject2 == null) {
            noSqlObject.set("contextStack", (Object)null);
        } else {
            noSqlObject.set("contextStack", noSqlObject2.asList().toArray());
        }
    }

    private void setFields(MapMessage<?, ?> mapMessage, NoSqlObject<W> noSqlObject) {
        mapMessage.forEach((string, object) -> noSqlObject.set((String)string, object));
    }

    @Override
    protected boolean shutdownInternal() {
        return Closer.closeSilently(this.connection);
    }

    @Override
    protected void startupInternal() {
    }

    @Override
    protected void writeInternal(LogEvent logEvent, Serializable serializable) {
        if (!this.isRunning() || this.connection == null || this.connection.isClosed()) {
            throw new AppenderLoggingException("Cannot write logging event; NoSQL manager not connected to the database.");
        }
        NoSqlObject<W> noSqlObject = this.connection.createObject();
        if (serializable instanceof MapMessage) {
            this.setFields((MapMessage)serializable, noSqlObject);
        } else {
            this.setFields(logEvent, noSqlObject);
        }
        this.setAdditionalFields(noSqlObject);
        this.connection.insertObject(noSqlObject);
    }

    private static final class NoSQLDatabaseManagerFactory
    implements ManagerFactory<NoSqlDatabaseManager<?>, FactoryData> {
        private NoSQLDatabaseManagerFactory() {
        }

        @Override
        public NoSqlDatabaseManager<?> createManager(String string, FactoryData factoryData) {
            Objects.requireNonNull(factoryData, "data");
            return new NoSqlDatabaseManager(string, factoryData.getBufferSize(), factoryData.provider, factoryData.additionalFields, factoryData.getConfiguration());
        }
    }

    private static final class FactoryData
    extends AbstractDatabaseManager.AbstractFactoryData {
        private final NoSqlProvider<?> provider;
        private final KeyValuePair[] additionalFields;

        protected FactoryData(Configuration configuration, int n2, NoSqlProvider<?> noSqlProvider, KeyValuePair[] keyValuePairArray) {
            super(configuration, n2, null);
            this.provider = Objects.requireNonNull(noSqlProvider, "provider");
            this.additionalFields = keyValuePairArray;
        }
    }
}

