/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.FileExtension;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.Action;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

@Plugin(name="DefaultRolloverStrategy", category="Core", printObject=true)
public class DefaultRolloverStrategy
extends AbstractRolloverStrategy {
    private static final int MIN_WINDOW_SIZE = 1;
    private static final int DEFAULT_WINDOW_SIZE = 7;
    private final int maxIndex;
    private final int minIndex;
    private final boolean useMax;
    private final int compressionLevel;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;
    private final PatternProcessor tempCompressedFilePattern;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @PluginFactory
    @Deprecated
    public static DefaultRolloverStrategy createStrategy(@PluginAttribute(value="max") String string, @PluginAttribute(value="min") String string2, @PluginAttribute(value="fileIndex") String string3, @PluginAttribute(value="compressionLevel") String string4, @PluginElement(value="Actions") Action[] actionArray, @PluginAttribute(value="stopCustomActionsOnError", defaultBoolean=true) boolean bl, @PluginConfiguration Configuration configuration) {
        return DefaultRolloverStrategy.newBuilder().withMin(string2).withMax(string).withFileIndex(string3).withCompressionLevelStr(string4).withCustomActions(actionArray).withStopCustomActionsOnError(bl).withConfig(configuration).build();
    }

    @Deprecated
    protected DefaultRolloverStrategy(int n2, int n3, boolean bl, int n4, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl2) {
        this(n2, n3, bl, n4, strSubstitutor, actionArray, bl2, null);
    }

    protected DefaultRolloverStrategy(int n2, int n3, boolean bl, int n4, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl2, String string) {
        super(strSubstitutor);
        this.minIndex = n2;
        this.maxIndex = n3;
        this.useMax = bl;
        this.compressionLevel = n4;
        this.stopCustomActionsOnError = bl2;
        this.customActions = actionArray == null ? Collections.emptyList() : Arrays.asList(actionArray);
        this.tempCompressedFilePattern = string != null ? new PatternProcessor(string) : null;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public boolean isUseMax() {
        return this.useMax;
    }

    public PatternProcessor getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    private int purge(int n2, int n3, RollingFileManager rollingFileManager) {
        return this.useMax ? this.purgeAscending(n2, n3, rollingFileManager) : this.purgeDescending(n2, n3, rollingFileManager);
    }

    private int purgeAscending(int n2, int n3, RollingFileManager rollingFileManager) {
        Comparable<StringBuilder> comparable;
        boolean bl;
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager);
        int n4 = n3 - n2 + 1;
        LOGGER.debug("Eligible files: {}", (Object)sortedMap);
        boolean bl2 = bl = !sortedMap.isEmpty() && sortedMap.lastKey() >= this.maxIndex;
        while (sortedMap.size() >= n4) {
            try {
                LOGGER.debug("Eligible files: {}", (Object)sortedMap);
                comparable = sortedMap.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)sortedMap.get(comparable)).toFile().getAbsolutePath());
                Files.delete((Path)sortedMap.get(comparable));
                sortedMap.remove(comparable);
                bl = true;
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}, {}", (Object)sortedMap.firstKey(), (Object)iOException.getMessage(), (Object)iOException);
                break;
            }
        }
        comparable = new StringBuilder();
        if (bl) {
            for (Map.Entry<Integer, Path> entry : sortedMap.entrySet()) {
                ((StringBuilder)comparable).setLength(0);
                rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)comparable, (Object)(entry.getKey() - 1));
                String string = entry.getValue().toFile().getName();
                String string2 = ((StringBuilder)comparable).toString();
                int n5 = this.suffixLength(string2);
                if (n5 > 0 && this.suffixLength(string) == 0) {
                    string2 = string2.substring(0, string2.length() - n5);
                }
                FileRenameAction fileRenameAction = new FileRenameAction(entry.getValue().toFile(), new File(string2), true);
                try {
                    LOGGER.debug("DefaultRolloverStrategy.purgeAscending executing {}", (Object)fileRenameAction);
                    if (fileRenameAction.execute()) continue;
                    return -1;
                }
                catch (Exception exception) {
                    LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)exception);
                    return -1;
                }
            }
        }
        return sortedMap.size() > 0 ? (sortedMap.lastKey() < n3 ? sortedMap.lastKey() + 1 : n3) : n2;
    }

    private int purgeDescending(int n2, int n3, RollingFileManager rollingFileManager) {
        Comparable<StringBuilder> comparable;
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager, false);
        int n4 = n3 - n2 + 1;
        LOGGER.debug("Eligible files: {}", (Object)sortedMap);
        while (sortedMap.size() >= n4) {
            try {
                comparable = sortedMap.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)sortedMap.get(comparable)).toFile().getAbsolutePath());
                Files.delete((Path)sortedMap.get(comparable));
                sortedMap.remove(comparable);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}, {}", (Object)sortedMap.firstKey(), (Object)iOException.getMessage(), (Object)iOException);
                break;
            }
        }
        comparable = new StringBuilder();
        for (Map.Entry<Integer, Path> entry : sortedMap.entrySet()) {
            ((StringBuilder)comparable).setLength(0);
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)comparable, (Object)(entry.getKey() + 1));
            String string = entry.getValue().toFile().getName();
            String string2 = ((StringBuilder)comparable).toString();
            int n5 = this.suffixLength(string2);
            if (n5 > 0 && this.suffixLength(string) == 0) {
                string2 = string2.substring(0, string2.length() - n5);
            }
            FileRenameAction fileRenameAction = new FileRenameAction(entry.getValue().toFile(), new File(string2), true);
            try {
                LOGGER.debug("DefaultRolloverStrategy.purgeDescending executing {}", (Object)fileRenameAction);
                if (fileRenameAction.execute()) continue;
                return -1;
            }
            catch (Exception exception) {
                LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)exception);
                return -1;
            }
        }
        return n2;
    }

    @Override
    public RolloverDescription rollover(RollingFileManager rollingFileManager) throws SecurityException {
        Object object;
        Object object2;
        String string;
        int n2;
        SortedMap<Integer, Path> sortedMap;
        StringBuilder stringBuilder = new StringBuilder(255);
        if (this.minIndex == Integer.MIN_VALUE) {
            sortedMap = this.getEligibleFiles(rollingFileManager);
            n2 = sortedMap.size() > 0 ? sortedMap.lastKey() + 1 : 1;
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, stringBuilder, (Object)n2);
        } else {
            if (this.maxIndex < 0) {
                return null;
            }
            long l2 = System.nanoTime();
            n2 = this.purge(this.minIndex, this.maxIndex, rollingFileManager);
            if (n2 < 0) {
                return null;
            }
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, stringBuilder, (Object)n2);
            if (LOGGER.isTraceEnabled()) {
                double d2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                LOGGER.trace("DefaultRolloverStrategy.purge() took {} milliseconds", (Object)d2);
            }
        }
        sortedMap = rollingFileManager.getFileName();
        String string2 = string = stringBuilder.toString();
        Action action = null;
        FileExtension fileExtension = rollingFileManager.getFileExtension();
        if (fileExtension != null) {
            object2 = new File(string);
            string = string.substring(0, string.length() - fileExtension.length());
            if (this.tempCompressedFilePattern != null) {
                stringBuilder.delete(0, stringBuilder.length());
                this.tempCompressedFilePattern.formatFileName(this.strSubstitutor, stringBuilder, (Object)n2);
                object = stringBuilder.toString();
                File file = new File((String)object);
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                action = new CompositeAction(Arrays.asList(fileExtension.createCompressAction(string, (String)object, true, this.compressionLevel), new FileRenameAction(file, (File)object2, true)), true);
            } else {
                action = fileExtension.createCompressAction(string, string2, true, this.compressionLevel);
            }
        }
        if (((String)((Object)sortedMap)).equals(string)) {
            LOGGER.warn("Attempt to rename file {} to itself will be ignored", (Object)sortedMap);
            return new RolloverDescriptionImpl((String)((Object)sortedMap), false, null, null);
        }
        if (action != null && rollingFileManager.isAttributeViewEnabled()) {
            object2 = PosixViewAttributeAction.newBuilder().withBasePath(string2).withFollowLinks(false).withMaxDepth(1).withPathConditions(PathCondition.EMPTY_ARRAY).withSubst(this.getStrSubstitutor()).withFilePermissions(rollingFileManager.getFilePermissions()).withFileOwner(rollingFileManager.getFileOwner()).withFileGroup(rollingFileManager.getFileGroup()).build();
            action = new CompositeAction(Arrays.asList(action, object2), false);
        }
        object2 = new FileRenameAction(new File((String)((Object)sortedMap)), new File(string), rollingFileManager.isRenameEmptyFiles());
        object = this.merge(action, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl((String)((Object)sortedMap), false, (Action)object2, (Action)object);
    }

    public String toString() {
        return "DefaultRolloverStrategy(min=" + this.minIndex + ", max=" + this.maxIndex + ", useMax=" + this.useMax + ")";
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<DefaultRolloverStrategy> {
        @PluginBuilderAttribute(value="max")
        private String max;
        @PluginBuilderAttribute(value="min")
        private String min;
        @PluginBuilderAttribute(value="fileIndex")
        private String fileIndex;
        @PluginBuilderAttribute(value="compressionLevel")
        private String compressionLevelStr;
        @PluginElement(value="Actions")
        private Action[] customActions;
        @PluginBuilderAttribute(value="stopCustomActionsOnError")
        private boolean stopCustomActionsOnError = true;
        @PluginBuilderAttribute(value="tempCompressedFilePattern")
        private String tempCompressedFilePattern;
        @PluginConfiguration
        private Configuration config;

        @Override
        public DefaultRolloverStrategy build() {
            boolean bl;
            int n2;
            int n3;
            if (this.fileIndex != null && this.fileIndex.equalsIgnoreCase("nomax")) {
                n3 = Integer.MIN_VALUE;
                n2 = Integer.MAX_VALUE;
                bl = false;
            } else {
                bl = this.fileIndex == null ? true : this.fileIndex.equalsIgnoreCase("max");
                n3 = 1;
                if (this.min != null && (n3 = Integers.parseInt(this.min)) < 1) {
                    AbstractRolloverStrategy.LOGGER.error("Minimum window size too small. Limited to 1");
                    n3 = 1;
                }
                n2 = 7;
                if (this.max != null && (n2 = Integer.parseInt(this.max.trim())) < n3) {
                    n2 = n3 < 7 ? 7 : n3;
                    AbstractRolloverStrategy.LOGGER.error("Maximum window size must be greater than the minimum windows size. Set to " + n2);
                }
            }
            String string = this.compressionLevelStr != null ? this.compressionLevelStr.trim() : this.compressionLevelStr;
            int n4 = Integers.parseInt(string, -1);
            StrSubstitutor strSubstitutor = this.config != null ? this.config.getStrSubstitutor() : new StrSubstitutor();
            return new DefaultRolloverStrategy(n3, n2, bl, n4, strSubstitutor, this.customActions, this.stopCustomActionsOnError, this.tempCompressedFilePattern);
        }

        public String getMax() {
            return this.max;
        }

        public Builder withMax(String string) {
            this.max = string;
            return this;
        }

        public String getMin() {
            return this.min;
        }

        public Builder withMin(String string) {
            this.min = string;
            return this;
        }

        public String getFileIndex() {
            return this.fileIndex;
        }

        public Builder withFileIndex(String string) {
            this.fileIndex = string;
            return this;
        }

        public String getCompressionLevelStr() {
            return this.compressionLevelStr;
        }

        public Builder withCompressionLevelStr(String string) {
            this.compressionLevelStr = string;
            return this;
        }

        public Action[] getCustomActions() {
            return this.customActions;
        }

        public Builder withCustomActions(Action[] actionArray) {
            this.customActions = actionArray;
            return this;
        }

        public boolean isStopCustomActionsOnError() {
            return this.stopCustomActionsOnError;
        }

        public Builder withStopCustomActionsOnError(boolean bl) {
            this.stopCustomActionsOnError = bl;
            return this;
        }

        public String getTempCompressedFilePattern() {
            return this.tempCompressedFilePattern;
        }

        public Builder withTempCompressedFilePattern(String string) {
            this.tempCompressedFilePattern = string;
            return this;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Builder withConfig(Configuration configuration) {
            this.config = configuration;
            return this;
        }
    }
}

