/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.FileExtension;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RolloverFrequency;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.DatePatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.FormattingInfo;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class PatternProcessor {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final String KEY = "FileConverter";
    private static final char YEAR_CHAR = 'y';
    private static final char MONTH_CHAR = 'M';
    private static final char[] WEEK_CHARS = new char[]{'w', 'W'};
    private static final char[] DAY_CHARS = new char[]{'D', 'd', 'F', 'E'};
    private static final char[] HOUR_CHARS = new char[]{'H', 'K', 'h', 'k'};
    private static final char MINUTE_CHAR = 'm';
    private static final char SECOND_CHAR = 's';
    private static final char MILLIS_CHAR = 'S';
    private final ArrayPatternConverter[] patternConverters;
    private final FormattingInfo[] patternFields;
    private final FileExtension fileExtension;
    private long prevFileTime = 0L;
    private long nextFileTime = 0L;
    private long currentFileTime = 0L;
    private boolean isTimeBased = false;
    private RolloverFrequency frequency = null;
    private final String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public PatternProcessor(String string) {
        this.pattern = string;
        PatternParser patternParser = this.createPatternParser();
        ArrayList<PatternConverter> arrayList = new ArrayList<PatternConverter>();
        ArrayList<FormattingInfo> arrayList2 = new ArrayList<FormattingInfo>();
        patternParser.parse(string, arrayList, arrayList2, false, false, false);
        this.patternFields = arrayList2.toArray(FormattingInfo.EMPTY_ARRAY);
        ArrayPatternConverter[] arrayPatternConverterArray = new ArrayPatternConverter[arrayList.size()];
        this.patternConverters = arrayList.toArray(arrayPatternConverterArray);
        this.fileExtension = FileExtension.lookupForFile(string);
        for (ArrayPatternConverter arrayPatternConverter : this.patternConverters) {
            if (!(arrayPatternConverter instanceof DatePatternConverter)) continue;
            DatePatternConverter datePatternConverter = (DatePatternConverter)arrayPatternConverter;
            this.frequency = this.calculateFrequency(datePatternConverter.getPattern());
        }
    }

    public PatternProcessor(String string, PatternProcessor patternProcessor) {
        this(string);
        this.prevFileTime = patternProcessor.prevFileTime;
        this.nextFileTime = patternProcessor.nextFileTime;
        this.currentFileTime = patternProcessor.currentFileTime;
    }

    public FormattingInfo[] getPatternFields() {
        return this.patternFields;
    }

    public ArrayPatternConverter[] getPatternConverters() {
        return this.patternConverters;
    }

    public void setTimeBased(boolean bl) {
        this.isTimeBased = bl;
    }

    public long getCurrentFileTime() {
        return this.currentFileTime;
    }

    public void setCurrentFileTime(long l2) {
        this.currentFileTime = l2;
    }

    public long getPrevFileTime() {
        return this.prevFileTime;
    }

    public void setPrevFileTime(long l2) {
        LOGGER.debug("Setting prev file time to {}", (Object)new Date(l2));
        this.prevFileTime = l2;
    }

    public FileExtension getFileExtension() {
        return this.fileExtension;
    }

    public long getNextTime(long l2, int n2, boolean bl) {
        this.prevFileTime = this.nextFileTime;
        if (this.frequency == null) {
            throw new IllegalStateException("Pattern does not contain a date");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        Calendar calendar2 = Calendar.getInstance();
        calendar.setMinimalDaysInFirstWeek(7);
        calendar2.setMinimalDaysInFirstWeek(7);
        calendar2.set(calendar.get(1), 0, 1, 0, 0, 0);
        calendar2.set(14, 0);
        if (this.frequency == RolloverFrequency.ANNUALLY) {
            this.increment(calendar2, 1, n2, bl);
            long l3 = calendar2.getTimeInMillis();
            calendar2.add(1, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l3);
        }
        calendar2.set(2, calendar.get(2));
        if (this.frequency == RolloverFrequency.MONTHLY) {
            this.increment(calendar2, 2, n2, bl);
            long l4 = calendar2.getTimeInMillis();
            calendar2.add(2, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l4);
        }
        if (this.frequency == RolloverFrequency.WEEKLY) {
            calendar2.set(3, calendar.get(3));
            this.increment(calendar2, 3, n2, bl);
            calendar2.set(7, calendar.getFirstDayOfWeek());
            long l5 = calendar2.getTimeInMillis();
            calendar2.add(3, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l5);
        }
        calendar2.set(6, calendar.get(6));
        if (this.frequency == RolloverFrequency.DAILY) {
            this.increment(calendar2, 6, n2, bl);
            long l6 = calendar2.getTimeInMillis();
            calendar2.add(6, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l6);
        }
        calendar2.set(11, calendar.get(11));
        if (this.frequency == RolloverFrequency.HOURLY) {
            this.increment(calendar2, 11, n2, bl);
            long l7 = calendar2.getTimeInMillis();
            calendar2.add(11, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l7);
        }
        calendar2.set(12, calendar.get(12));
        if (this.frequency == RolloverFrequency.EVERY_MINUTE) {
            this.increment(calendar2, 12, n2, bl);
            long l8 = calendar2.getTimeInMillis();
            calendar2.add(12, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l8);
        }
        calendar2.set(13, calendar.get(13));
        if (this.frequency == RolloverFrequency.EVERY_SECOND) {
            this.increment(calendar2, 13, n2, bl);
            long l9 = calendar2.getTimeInMillis();
            calendar2.add(13, -1);
            this.nextFileTime = calendar2.getTimeInMillis();
            return this.debugGetNextTime(l9);
        }
        calendar2.set(14, calendar.get(14));
        this.increment(calendar2, 14, n2, bl);
        long l10 = calendar2.getTimeInMillis();
        calendar2.add(14, -1);
        this.nextFileTime = calendar2.getTimeInMillis();
        return this.debugGetNextTime(l10);
    }

    public void updateTime() {
        if (this.nextFileTime != 0L || !this.isTimeBased) {
            this.prevFileTime = this.nextFileTime;
            this.currentFileTime = 0L;
        }
    }

    private long debugGetNextTime(long l2) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PatternProcessor.getNextTime returning {}, nextFileTime={}, prevFileTime={}, current={}, freq={}", (Object)this.format(l2), (Object)this.format(this.nextFileTime), (Object)this.format(this.prevFileTime), (Object)this.format(System.currentTimeMillis()), (Object)this.frequency);
        }
        return l2;
    }

    private String format(long l2) {
        return new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.SSS").format(new Date(l2));
    }

    private void increment(Calendar calendar, int n2, int n3, boolean bl) {
        int n4 = bl ? n3 - calendar.get(n2) % n3 : n3;
        calendar.add(n2, n4);
    }

    public final void formatFileName(StringBuilder stringBuilder, boolean bl, Object object) {
        long l2;
        long l3 = l2 = bl ? this.currentFileTime : this.prevFileTime;
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
        }
        this.formatFileName(stringBuilder, new Date(l2), object);
    }

    public final void formatFileName(StrSubstitutor strSubstitutor, StringBuilder stringBuilder, Object object) {
        this.formatFileName(strSubstitutor, stringBuilder, false, object);
    }

    public final void formatFileName(StrSubstitutor strSubstitutor, StringBuilder stringBuilder, boolean bl, Object object) {
        LOGGER.debug("Formatting file name. useCurrentTime={}. currentFileTime={}, prevFileTime={}", (Object)bl, (Object)this.currentFileTime, (Object)this.prevFileTime);
        long l2 = bl ? (this.currentFileTime != 0L ? this.currentFileTime : System.currentTimeMillis()) : (this.prevFileTime != 0L ? this.prevFileTime : System.currentTimeMillis());
        this.formatFileName(stringBuilder, new Date(l2), object);
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent.Builder().setTimeMillis(l2).build();
        String string = strSubstitutor.replace((LogEvent)log4jLogEvent, stringBuilder);
        stringBuilder.setLength(0);
        stringBuilder.append(string);
    }

    protected final void formatFileName(StringBuilder stringBuilder, Object ... objectArray) {
        for (int i2 = 0; i2 < this.patternConverters.length; ++i2) {
            int n2 = stringBuilder.length();
            this.patternConverters[i2].format(stringBuilder, objectArray);
            if (this.patternFields[i2] == null) continue;
            this.patternFields[i2].format(n2, stringBuilder);
        }
    }

    private RolloverFrequency calculateFrequency(String string) {
        if (this.patternContains(string, 'S')) {
            return RolloverFrequency.EVERY_MILLISECOND;
        }
        if (this.patternContains(string, 's')) {
            return RolloverFrequency.EVERY_SECOND;
        }
        if (this.patternContains(string, 'm')) {
            return RolloverFrequency.EVERY_MINUTE;
        }
        if (this.patternContains(string, HOUR_CHARS)) {
            return RolloverFrequency.HOURLY;
        }
        if (this.patternContains(string, DAY_CHARS)) {
            return RolloverFrequency.DAILY;
        }
        if (this.patternContains(string, WEEK_CHARS)) {
            return RolloverFrequency.WEEKLY;
        }
        if (this.patternContains(string, 'M')) {
            return RolloverFrequency.MONTHLY;
        }
        if (this.patternContains(string, 'y')) {
            return RolloverFrequency.ANNUALLY;
        }
        return null;
    }

    private PatternParser createPatternParser() {
        return new PatternParser(null, KEY, null);
    }

    private boolean patternContains(String string, char ... cArray) {
        for (char c2 : cArray) {
            if (!this.patternContains(string, c2)) continue;
            return true;
        }
        return false;
    }

    private boolean patternContains(String string, char c2) {
        return string.indexOf(c2) >= 0;
    }

    public RolloverFrequency getFrequency() {
        return this.frequency;
    }

    public long getNextFileTime() {
        return this.nextFileTime;
    }
}

