/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.FileUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NullOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;

public class RollingRandomAccessFileManager
extends RollingFileManager {
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RollingRandomAccessFileManagerFactory FACTORY = new RollingRandomAccessFileManagerFactory();
    private RandomAccessFile randomAccessFile;

    @Deprecated
    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2, int n2, long l2, long l3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl3) {
        this(loggerContext, randomAccessFile, string, string2, outputStream, bl, bl2, n2, l2, l3, triggeringPolicy, rolloverStrategy, string3, layout, null, null, null, bl3);
    }

    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2, int n2, long l2, long l3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, String string4, String string5, String string6, boolean bl3) {
        super(loggerContext, string, string2, outputStream, bl, false, l2, l3, triggeringPolicy, rolloverStrategy, string3, layout, string4, string5, string6, bl3, ByteBuffer.wrap(new byte[n2]));
        this.randomAccessFile = randomAccessFile;
        this.writeHeader();
    }

    private void writeHeader() {
        if (this.layout == null) {
            return;
        }
        byte[] byArray = this.layout.getHeader();
        if (byArray == null) {
            return;
        }
        try {
            if (this.randomAccessFile != null && this.randomAccessFile.length() == 0L) {
                this.randomAccessFile.write(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            this.logError("Unable to write header", iOException);
        }
    }

    public static RollingRandomAccessFileManager getRollingRandomAccessFileManager(String string, String string2, boolean bl, boolean bl2, int n2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, String string4, String string5, String string6, Configuration configuration) {
        if (rolloverStrategy instanceof DirectWriteRolloverStrategy && string != null) {
            LOGGER.error("The fileName attribute must not be specified with the DirectWriteRolloverStrategy");
            return null;
        }
        String string7 = string == null ? string2 : string;
        return RollingRandomAccessFileManager.narrow(RollingRandomAccessFileManager.class, RollingRandomAccessFileManager.getManager(string7, new FactoryData(string, string2, bl, bl2, n2, triggeringPolicy, rolloverStrategy, string3, layout, string4, string5, string6, configuration), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean bl) {
    }

    @Override
    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl) {
        super.write(byArray, n2, n3, bl);
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n2, int n3) {
        try {
            if (this.randomAccessFile == null) {
                this.createFileAfterRollover();
            }
            this.randomAccessFile.write(byArray, n2, n3);
            this.size += (long)n3;
        }
        catch (IOException iOException) {
            String string = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(string, iOException);
        }
    }

    @Override
    protected void createFileAfterRollover() throws IOException {
        String string = this.getFileName();
        File file = new File(string);
        FileUtils.makeParentDirs(file);
        this.createFileAfterRollover(string);
    }

    private void createFileAfterRollover(String string) throws IOException {
        this.randomAccessFile = new RandomAccessFile(string, "rw");
        if (this.isAttributeViewEnabled()) {
            this.defineAttributeView(Paths.get(string, new String[0]));
        }
        if (this.isAppend()) {
            this.randomAccessFile.seek(this.randomAccessFile.length());
        }
        this.writeHeader();
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
    }

    @Override
    public synchronized boolean closeOutputStream() {
        this.flush();
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
                return true;
            }
            catch (IOException iOException) {
                this.logError("Unable to close RandomAccessFile", iOException);
                return false;
            }
        }
        return true;
    }

    @Override
    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public void updateData(Object object) {
        FactoryData factoryData = (FactoryData)object;
        this.setRolloverStrategy(factoryData.getRolloverStrategy());
        this.setPatternProcessor(new PatternProcessor(factoryData.getPattern(), this.getPatternProcessor()));
        this.setTriggeringPolicy(factoryData.getTriggeringPolicy());
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final String fileName;
        private final String pattern;
        private final boolean append;
        private final boolean immediateFlush;
        private final int bufferSize;
        private final TriggeringPolicy policy;
        private final RolloverStrategy strategy;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;
        private final String filePermissions;
        private final String fileOwner;
        private final String fileGroup;

        public FactoryData(String string, String string2, boolean bl, boolean bl2, int n2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, String string4, String string5, String string6, Configuration configuration) {
            super(configuration);
            this.fileName = string;
            this.pattern = string2;
            this.append = bl;
            this.immediateFlush = bl2;
            this.bufferSize = n2;
            this.policy = triggeringPolicy;
            this.strategy = rolloverStrategy;
            this.advertiseURI = string3;
            this.layout = layout;
            this.filePermissions = string4;
            this.fileOwner = string5;
            this.fileGroup = string6;
        }

        public String getPattern() {
            return this.pattern;
        }

        public TriggeringPolicy getTriggeringPolicy() {
            return this.policy;
        }

        public RolloverStrategy getRolloverStrategy() {
            return this.strategy;
        }
    }

    private static class RollingRandomAccessFileManagerFactory
    implements ManagerFactory<RollingRandomAccessFileManager, FactoryData> {
        private RollingRandomAccessFileManagerFactory() {
        }

        @Override
        public RollingRandomAccessFileManager createManager(String string, FactoryData factoryData) {
            File file = null;
            long l2 = 0L;
            long l3 = System.currentTimeMillis();
            RandomAccessFile randomAccessFile = null;
            if (factoryData.fileName != null) {
                file = new File(string);
                if (!factoryData.append) {
                    file.delete();
                }
                long l4 = l2 = factoryData.append ? file.length() : 0L;
                if (file.exists()) {
                    l3 = file.lastModified();
                }
                try {
                    FileUtils.makeParentDirs(file);
                    randomAccessFile = new RandomAccessFile(string, "rw");
                    if (factoryData.append) {
                        long l5 = randomAccessFile.length();
                        LOGGER.trace("RandomAccessFile {} seek to {}", (Object)string, (Object)l5);
                        randomAccessFile.seek(l5);
                    } else {
                        LOGGER.trace("RandomAccessFile {} set length to 0", (Object)string);
                        randomAccessFile.setLength(0L);
                    }
                }
                catch (IOException iOException) {
                    LOGGER.error("Cannot access RandomAccessFile " + iOException, (Throwable)iOException);
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException2) {
                            LOGGER.error("Cannot close RandomAccessFile {}", (Object)string, (Object)iOException2);
                        }
                    }
                    return null;
                }
            }
            boolean bl = !factoryData.append || file == null || !file.exists();
            RollingRandomAccessFileManager rollingRandomAccessFileManager = new RollingRandomAccessFileManager(factoryData.getLoggerContext(), randomAccessFile, string, factoryData.pattern, NullOutputStream.getInstance(), factoryData.append, factoryData.immediateFlush, factoryData.bufferSize, l2, l3, factoryData.policy, factoryData.strategy, factoryData.advertiseURI, factoryData.layout, factoryData.filePermissions, factoryData.fileOwner, factoryData.fileGroup, bl);
            if (rollingRandomAccessFileManager.isAttributeViewEnabled()) {
                rollingRandomAccessFileManager.defineAttributeView(file.toPath());
            }
            return rollingRandomAccessFileManager;
        }
    }
}

