/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

@Plugin(name="TimeBasedTriggeringPolicy", category="Core", printObject=true)
public final class TimeBasedTriggeringPolicy
extends AbstractTriggeringPolicy {
    private long nextRolloverMillis;
    private final int interval;
    private final boolean modulate;
    private final long maxRandomDelayMillis;
    private RollingFileManager manager;

    private TimeBasedTriggeringPolicy(int n2, boolean bl, long l2) {
        this.interval = n2;
        this.modulate = bl;
        this.maxRandomDelayMillis = l2;
    }

    public int getInterval() {
        return this.interval;
    }

    public long getNextRolloverMillis() {
        return this.nextRolloverMillis;
    }

    @Override
    public void initialize(RollingFileManager rollingFileManager) {
        this.manager = rollingFileManager;
        long l2 = rollingFileManager.getFileTime();
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
        }
        rollingFileManager.getPatternProcessor().getNextTime(l2, this.interval, this.modulate);
        rollingFileManager.getPatternProcessor().setTimeBased(true);
        this.nextRolloverMillis = ThreadLocalRandom.current().nextLong(0L, 1L + this.maxRandomDelayMillis) + rollingFileManager.getPatternProcessor().getNextTime(l2, this.interval, this.modulate);
    }

    @Override
    public boolean isTriggeringEvent(LogEvent logEvent) {
        long l2 = logEvent.getTimeMillis();
        if (l2 >= this.nextRolloverMillis) {
            this.nextRolloverMillis = ThreadLocalRandom.current().nextLong(0L, 1L + this.maxRandomDelayMillis) + this.manager.getPatternProcessor().getNextTime(l2, this.interval, this.modulate);
            this.manager.getPatternProcessor().setCurrentFileTime(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    @Deprecated
    public static TimeBasedTriggeringPolicy createPolicy(@PluginAttribute(value="interval") String string, @PluginAttribute(value="modulate") String string2) {
        return TimeBasedTriggeringPolicy.newBuilder().withInterval(Integers.parseInt(string, 1)).withModulate(Boolean.parseBoolean(string2)).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "TimeBasedTriggeringPolicy(nextRolloverMillis=" + this.nextRolloverMillis + ", interval=" + this.interval + ", modulate=" + this.modulate + ")";
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<TimeBasedTriggeringPolicy> {
        @PluginBuilderAttribute
        private int interval = 1;
        @PluginBuilderAttribute
        private boolean modulate = false;
        @PluginBuilderAttribute
        private int maxRandomDelay = 0;

        @Override
        public TimeBasedTriggeringPolicy build() {
            long l2 = TimeUnit.SECONDS.toMillis(this.maxRandomDelay);
            return new TimeBasedTriggeringPolicy(this.interval, this.modulate, l2);
        }

        public int getInterval() {
            return this.interval;
        }

        public boolean isModulate() {
            return this.modulate;
        }

        public int getMaxRandomDelay() {
            return this.maxRandomDelay;
        }

        public Builder withInterval(int n2) {
            this.interval = n2;
            return this;
        }

        public Builder withModulate(boolean bl) {
            this.modulate = bl;
            return this;
        }

        public Builder withMaxRandomDelay(int n2) {
            this.maxRandomDelay = n2;
            return this;
        }
    }
}

