/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async;

import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventFactory;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventHandler;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventTranslatorTwoArg;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.ExceptionHandler;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.RingBuffer;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.Sequence;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.SequenceReportingEventHandler;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.TimeoutException;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.WaitStrategy;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.dsl.Disruptor;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.dsl.ProducerType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.DisruptorUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.EventRoute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.InternalAsyncUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.RingBufferLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.LogEventFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.MutableLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThread;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThreadFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.ReusableMessage;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AsyncLoggerConfigDisruptor
extends AbstractLifeCycle
implements AsyncLoggerConfigDelegate {
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final EventFactory<Log4jEventWrapper> FACTORY = Log4jEventWrapper::new;
    private static final EventFactory<Log4jEventWrapper> MUTABLE_FACTORY = () -> new Log4jEventWrapper(new MutableLogEvent());
    private static final EventTranslatorTwoArg<Log4jEventWrapper, LogEvent, AsyncLoggerConfig> TRANSLATOR = (log4jEventWrapper, l2, logEvent, asyncLoggerConfig) -> {
        ((Log4jEventWrapper)log4jEventWrapper).event = logEvent;
        ((Log4jEventWrapper)log4jEventWrapper).loggerConfig = asyncLoggerConfig;
    };
    private static final EventTranslatorTwoArg<Log4jEventWrapper, LogEvent, AsyncLoggerConfig> MUTABLE_TRANSLATOR = (log4jEventWrapper, l2, logEvent, asyncLoggerConfig) -> {
        ((MutableLogEvent)((Log4jEventWrapper)log4jEventWrapper).event).initFrom((LogEvent)logEvent);
        ((Log4jEventWrapper)log4jEventWrapper).loggerConfig = asyncLoggerConfig;
    };
    private int ringBufferSize;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private Boolean mutable = Boolean.FALSE;
    private volatile Disruptor<Log4jEventWrapper> disruptor;
    private long backgroundThreadId;
    private EventFactory<Log4jEventWrapper> factory;
    private EventTranslatorTwoArg<Log4jEventWrapper, LogEvent, AsyncLoggerConfig> translator;
    private volatile boolean alreadyLoggedWarning;
    private final AsyncWaitStrategyFactory asyncWaitStrategyFactory;
    private WaitStrategy waitStrategy;
    private final Object queueFullEnqueueLock = new Object();

    public AsyncLoggerConfigDisruptor(AsyncWaitStrategyFactory asyncWaitStrategyFactory) {
        this.asyncWaitStrategyFactory = asyncWaitStrategyFactory;
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    @Override
    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.mutable = this.mutable != false || logEventFactory instanceof ReusableLogEventFactory;
    }

    @Override
    public synchronized void start() {
        if (this.disruptor != null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor not starting new disruptor for this configuration, using existing object.");
            return;
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor creating new disruptor for this configuration.");
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLoggerConfig.RingBufferSize");
        this.waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLoggerConfig.WaitStrategy", this.asyncWaitStrategyFactory);
        Log4jThreadFactory log4jThreadFactory = new Log4jThreadFactory("AsyncLoggerConfig", true, 5){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = super.newThread(runnable);
                AsyncLoggerConfigDisruptor.this.backgroundThreadId = thread.getId();
                return thread;
            }
        };
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.translator = this.mutable != false ? MUTABLE_TRANSLATOR : TRANSLATOR;
        this.factory = this.mutable != false ? MUTABLE_FACTORY : FACTORY;
        this.disruptor = new Disruptor(this.factory, this.ringBufferSize, (ThreadFactory)log4jThreadFactory, ProducerType.MULTI, this.waitStrategy);
        ExceptionHandler<Log4jEventWrapper> exceptionHandler = DisruptorUtil.getAsyncLoggerConfigExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(exceptionHandler);
        Log4jEventWrapperHandler[] log4jEventWrapperHandlerArray = new Log4jEventWrapperHandler[]{new Log4jEventWrapperHandler()};
        this.disruptor.handleEventsWith((EventHandler[])log4jEventWrapperHandlerArray);
        LOGGER.debug("Starting AsyncLoggerConfig disruptor for this configuration with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), (Object)exceptionHandler);
        this.disruptor.start();
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        Disruptor<Log4jEventWrapper> disruptor = this.disruptor;
        if (disruptor == null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor for this configuration already shut down.");
            return true;
        }
        this.setStopping();
        LOGGER.trace("AsyncLoggerConfigDisruptor: shutting down disruptor for this configuration.");
        this.disruptor = null;
        for (int i2 = 0; AsyncLoggerConfigDisruptor.hasBacklog(disruptor) && i2 < 200; ++i2) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            disruptor.shutdown(l2, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.warn("AsyncLoggerConfigDisruptor: shutdown timed out after {} {}", (Object)l2, (Object)timeUnit);
            disruptor.halt();
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor has been shut down.");
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> disruptor) {
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    @Override
    public EventRoute getEventRoute(Level level) {
        int n2 = this.remainingDisruptorCapacity();
        if (n2 < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, level);
    }

    private int remainingDisruptorCapacity() {
        Disruptor<Log4jEventWrapper> disruptor = this.disruptor;
        if (this.hasLog4jBeenShutDown(disruptor)) {
            return -1;
        }
        return (int)disruptor.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<Log4jEventWrapper> disruptor) {
        if (disruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    @Override
    public void enqueueEvent(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        try {
            LogEvent logEvent2 = this.prepareEvent(logEvent);
            this.enqueue(logEvent2, asyncLoggerConfig);
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.warn("Ignoring log event after log4j was shut down: {} [{}] {}", (Object)logEvent.getLevel(), (Object)logEvent.getLoggerName(), (Object)(logEvent.getMessage().getFormattedMessage() + (logEvent.getThrown() == null ? "" : Throwables.toStringList(logEvent.getThrown()))));
        }
    }

    private LogEvent prepareEvent(LogEvent logEvent) {
        LogEvent logEvent2 = this.ensureImmutable(logEvent);
        if (logEvent2.getMessage() instanceof ReusableMessage) {
            if (logEvent2 instanceof Log4jLogEvent) {
                ((Log4jLogEvent)logEvent2).makeMessageImmutable();
            } else if (logEvent2 instanceof MutableLogEvent) {
                if (this.translator != MUTABLE_TRANSLATOR) {
                    logEvent2 = ((MutableLogEvent)logEvent2).createMemento();
                }
            } else {
                this.showWarningAboutCustomLogEventWithReusableMessage(logEvent2);
            }
        } else {
            InternalAsyncUtil.makeMessageImmutable(logEvent2.getMessage());
        }
        return logEvent2;
    }

    private void showWarningAboutCustomLogEventWithReusableMessage(LogEvent logEvent) {
        if (!this.alreadyLoggedWarning) {
            LOGGER.warn("Custom log event of type {} contains a mutable message of type {}. AsyncLoggerConfig does not know how to make an immutable copy of this message. This may result in ConcurrentModificationExceptions or incorrect log messages if the application modifies objects in the message while the background thread is writing it to the appenders.", (Object)logEvent.getClass().getName(), (Object)logEvent.getMessage().getClass().getName());
            this.alreadyLoggedWarning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        if (this.synchronizeEnqueueWhenQueueFull()) {
            Object object = this.queueFullEnqueueLock;
            synchronized (object) {
                this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)logEvent, (Object)asyncLoggerConfig);
            }
        } else {
            this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)logEvent, (Object)asyncLoggerConfig);
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_CONFIG_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    @Override
    public boolean tryEnqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        LogEvent logEvent2 = this.prepareEvent(logEvent);
        return this.disruptor.getRingBuffer().tryPublishEvent(this.translator, (Object)logEvent2, (Object)asyncLoggerConfig);
    }

    private LogEvent ensureImmutable(LogEvent logEvent) {
        LogEvent logEvent2 = logEvent;
        if (logEvent instanceof RingBufferLogEvent) {
            logEvent2 = ((RingBufferLogEvent)logEvent).createMemento();
        }
        return logEvent2;
    }

    @Override
    public RingBufferAdmin createRingBufferAdmin(String string, String string2) {
        return RingBufferAdmin.forAsyncLoggerConfig(this.disruptor.getRingBuffer(), string, string2);
    }

    private static class Log4jEventWrapperHandler
    implements SequenceReportingEventHandler<Log4jEventWrapper> {
        private static final int NOTIFY_PROGRESS_THRESHOLD = 50;
        private Sequence sequenceCallback;
        private int counter;

        private Log4jEventWrapperHandler() {
        }

        public void setSequenceCallback(Sequence sequence) {
            this.sequenceCallback = sequence;
        }

        public void onEvent(Log4jEventWrapper log4jEventWrapper, long l2, boolean bl) throws Exception {
            log4jEventWrapper.event.setEndOfBatch(bl);
            log4jEventWrapper.loggerConfig.logToAsyncLoggerConfigsOnCurrentThread(log4jEventWrapper.event);
            log4jEventWrapper.clear();
            this.notifyIntermediateProgress(l2);
        }

        private void notifyIntermediateProgress(long l2) {
            if (++this.counter > 50) {
                this.sequenceCallback.set(l2);
                this.counter = 0;
            }
        }
    }

    public static class Log4jEventWrapper {
        private AsyncLoggerConfig loggerConfig;
        private LogEvent event;

        public Log4jEventWrapper() {
        }

        public Log4jEventWrapper(MutableLogEvent mutableLogEvent) {
            this.event = mutableLogEvent;
        }

        public void clear() {
            this.loggerConfig = null;
            if (this.event instanceof MutableLogEvent) {
                ((MutableLogEvent)this.event).clear();
            } else {
                this.event = null;
            }
        }

        public String toString() {
            return String.valueOf(this.event);
        }
    }
}

