/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async;

import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventFactory;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventHandler;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventTranslator;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.EventTranslatorVararg;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.ExceptionHandler;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.RingBuffer;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.TimeoutException;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.WaitStrategy;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.dsl.Disruptor;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.dsl.ProducerType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.DisruptorUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.EventRoute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.RingBufferLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.RingBufferLogEventHandler;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThread;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThreadFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.Message;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class AsyncLoggerDisruptor
extends AbstractLifeCycle {
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private final Object queueFullEnqueueLock = new Object();
    private volatile Disruptor<RingBufferLogEvent> disruptor;
    private String contextName;
    private final Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier;
    private boolean useThreadLocalTranslator = true;
    private long backgroundThreadId;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private int ringBufferSize;
    private WaitStrategy waitStrategy;

    AsyncLoggerDisruptor(String string, Supplier<AsyncWaitStrategyFactory> supplier) {
        this.contextName = string;
        this.waitStrategyFactorySupplier = Objects.requireNonNull(supplier, "waitStrategyFactorySupplier");
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String string) {
        this.contextName = string;
    }

    Disruptor<RingBufferLogEvent> getDisruptor() {
        return this.disruptor;
    }

    @Override
    public synchronized void start() {
        if (this.disruptor != null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor not starting new disruptor for this context, using existing object.", (Object)this.contextName);
            return;
        }
        if (this.isStarting()) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor is already starting.", (Object)this.contextName);
            return;
        }
        this.setStarting();
        LOGGER.trace("[{}] AsyncLoggerDisruptor creating new disruptor for this context.", (Object)this.contextName);
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLogger.RingBufferSize");
        AsyncWaitStrategyFactory asyncWaitStrategyFactory = this.waitStrategyFactorySupplier.get();
        this.waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLogger.WaitStrategy", asyncWaitStrategyFactory);
        Log4jThreadFactory log4jThreadFactory = new Log4jThreadFactory("AsyncLogger[" + this.contextName + "]", true, 5){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = super.newThread(runnable);
                AsyncLoggerDisruptor.this.backgroundThreadId = thread.getId();
                return thread;
            }
        };
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.disruptor = new Disruptor((EventFactory)RingBufferLogEvent.FACTORY, this.ringBufferSize, (ThreadFactory)log4jThreadFactory, ProducerType.MULTI, this.waitStrategy);
        ExceptionHandler<RingBufferLogEvent> exceptionHandler = DisruptorUtil.getAsyncLoggerExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(exceptionHandler);
        RingBufferLogEventHandler[] ringBufferLogEventHandlerArray = new RingBufferLogEventHandler[]{new RingBufferLogEventHandler()};
        this.disruptor.handleEventsWith((EventHandler[])ringBufferLogEventHandlerArray);
        LOGGER.debug("[{}] Starting AsyncLogger disruptor for this context with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.contextName, (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), (Object)exceptionHandler);
        this.disruptor.start();
        LOGGER.trace("[{}] AsyncLoggers use a {} translator", (Object)this.contextName, (Object)(this.useThreadLocalTranslator ? "threadlocal" : "vararg"));
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        Disruptor<RingBufferLogEvent> disruptor = this.getDisruptor();
        if (disruptor == null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor for this context already shut down.", (Object)this.contextName);
            return true;
        }
        this.setStopping();
        LOGGER.debug("[{}] AsyncLoggerDisruptor: shutting down disruptor for this context.", (Object)this.contextName);
        this.disruptor = null;
        for (int i2 = 0; AsyncLoggerDisruptor.hasBacklog(disruptor) && i2 < 200; ++i2) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            disruptor.shutdown(l2, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.warn("[{}] AsyncLoggerDisruptor: shutdown timed out after {} {}", (Object)this.contextName, (Object)l2, (Object)timeUnit);
            disruptor.halt();
        }
        LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor has been shut down.", (Object)this.contextName);
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> disruptor) {
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    public RingBufferAdmin createRingBufferAdmin(String string) {
        RingBuffer ringBuffer = this.disruptor == null ? null : this.disruptor.getRingBuffer();
        return RingBufferAdmin.forAsyncLogger(ringBuffer, string);
    }

    EventRoute getEventRoute(Level level) {
        int n2 = this.remainingDisruptorCapacity();
        if (n2 < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, level);
    }

    private int remainingDisruptorCapacity() {
        Disruptor<RingBufferLogEvent> disruptor = this.disruptor;
        if (this.hasLog4jBeenShutDown(disruptor)) {
            return -1;
        }
        return (int)disruptor.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<RingBufferLogEvent> disruptor) {
        if (disruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    boolean tryPublish(RingBufferLogEventTranslator ringBufferLogEventTranslator) {
        try {
            return this.disruptor.getRingBuffer().tryPublishEvent((EventTranslator)ringBufferLogEventTranslator);
        }
        catch (NullPointerException nullPointerException) {
            this.logWarningOnNpeFromDisruptorPublish(ringBufferLogEventTranslator);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueLogMessageWhenQueueFull(RingBufferLogEventTranslator ringBufferLogEventTranslator) {
        block6: {
            try {
                if (this.synchronizeEnqueueWhenQueueFull()) {
                    Object object = this.queueFullEnqueueLock;
                    synchronized (object) {
                        this.disruptor.publishEvent((EventTranslator)ringBufferLogEventTranslator);
                        break block6;
                    }
                }
                this.disruptor.publishEvent((EventTranslator)ringBufferLogEventTranslator);
            }
            catch (NullPointerException nullPointerException) {
                this.logWarningOnNpeFromDisruptorPublish(ringBufferLogEventTranslator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueLogMessageWhenQueueFull(EventTranslatorVararg<RingBufferLogEvent> eventTranslatorVararg, AsyncLogger asyncLogger, StackTraceElement stackTraceElement, String string, Level level, Marker marker, Message message, Throwable throwable) {
        block6: {
            try {
                if (this.synchronizeEnqueueWhenQueueFull()) {
                    Object object = this.queueFullEnqueueLock;
                    synchronized (object) {
                        this.disruptor.getRingBuffer().publishEvent(eventTranslatorVararg, new Object[]{asyncLogger, stackTraceElement, string, level, marker, message, throwable});
                        break block6;
                    }
                }
                this.disruptor.getRingBuffer().publishEvent(eventTranslatorVararg, new Object[]{asyncLogger, stackTraceElement, string, level, marker, message, throwable});
            }
            catch (NullPointerException nullPointerException) {
                this.logWarningOnNpeFromDisruptorPublish(level, string, message, throwable);
            }
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_LOGGER_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    private void logWarningOnNpeFromDisruptorPublish(RingBufferLogEventTranslator ringBufferLogEventTranslator) {
        this.logWarningOnNpeFromDisruptorPublish(ringBufferLogEventTranslator.level, ringBufferLogEventTranslator.loggerName, ringBufferLogEventTranslator.message, ringBufferLogEventTranslator.thrown);
    }

    private void logWarningOnNpeFromDisruptorPublish(Level level, String string, Message message, Throwable throwable) {
        LOGGER.warn("[{}] Ignoring log event after log4j was shut down: {} [{}] {}{}", (Object)this.contextName, (Object)level, (Object)string, (Object)message.getFormattedMessage(), throwable == null ? "" : Throwables.toStringList(throwable));
    }

    public boolean isUseThreadLocals() {
        return this.useThreadLocalTranslator;
    }

    public void setUseThreadLocals(boolean bl) {
        this.useThreadLocalTranslator = bl;
        LOGGER.trace("[{}] AsyncLoggers have been modified to use a {} translator", (Object)this.contextName, (Object)(this.useThreadLocalTranslator ? "threadlocal" : "vararg"));
    }
}

