/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.BlockingQueueFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.jctools.queues.MpscArrayQueue;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

@Plugin(name="JCToolsBlockingQueue", category="Core", elementType="BlockingQueueFactory")
public class JCToolsBlockingQueueFactory<E>
implements BlockingQueueFactory<E> {
    private final WaitStrategy waitStrategy;

    private JCToolsBlockingQueueFactory(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    @Override
    public BlockingQueue<E> create(int n2) {
        return new MpscBlockingQueue(n2, this.waitStrategy);
    }

    @PluginFactory
    public static <E> JCToolsBlockingQueueFactory<E> createFactory(@PluginAttribute(value="WaitStrategy", defaultString="PARK") WaitStrategy waitStrategy) {
        return new JCToolsBlockingQueueFactory<E>(waitStrategy);
    }

    private static interface Idle {
        public int idle(int var1);
    }

    public static enum WaitStrategy {
        SPIN(n2 -> n2 + 1),
        YIELD(n2 -> {
            Thread.yield();
            return n2 + 1;
        }),
        PARK(n2 -> {
            LockSupport.parkNanos(1L);
            return n2 + 1;
        }),
        PROGRESSIVE(n2 -> {
            if (n2 > 200) {
                LockSupport.parkNanos(1L);
            } else if (n2 > 100) {
                Thread.yield();
            }
            return n2 + 1;
        });

        private final Idle idle;

        private int idle(int n2) {
            return this.idle.idle(n2);
        }

        private WaitStrategy(Idle idle) {
            this.idle = idle;
        }
    }

    private static final class MpscBlockingQueue<E>
    extends MpscArrayQueue<E>
    implements BlockingQueue<E> {
        private final WaitStrategy waitStrategy;

        MpscBlockingQueue(int n2, WaitStrategy waitStrategy) {
            super(n2);
            this.waitStrategy = waitStrategy;
        }

        @Override
        public int drainTo(Collection<? super E> collection) {
            return this.drainTo(collection, this.capacity());
        }

        @Override
        public int drainTo(Collection<? super E> collection, int n2) {
            return this.drain(object -> collection.add(object), n2);
        }

        @Override
        public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
            int n2 = 0;
            long l3 = System.nanoTime() + timeUnit.toNanos(l2);
            do {
                if (this.offer(e2)) {
                    return true;
                }
                if (System.nanoTime() - l3 > 0L) {
                    return false;
                }
                n2 = this.waitStrategy.idle(n2);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        @Override
        public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
            int n2 = 0;
            long l3 = System.nanoTime() + timeUnit.toNanos(l2);
            do {
                Object object;
                if ((object = this.poll()) != null) {
                    return (E)object;
                }
                if (System.nanoTime() - l3 > 0L) {
                    return null;
                }
                n2 = this.waitStrategy.idle(n2);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        @Override
        public void put(E e2) throws InterruptedException {
            int n2 = 0;
            do {
                if (this.offer(e2)) {
                    return;
                }
                n2 = this.waitStrategy.idle(n2);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        @Override
        public boolean offer(E e2) {
            return this.offerIfBelowThreshold(e2, this.capacity() - 32);
        }

        @Override
        public int remainingCapacity() {
            return this.capacity() - this.size();
        }

        @Override
        public E take() throws InterruptedException {
            int n2 = 100;
            do {
                Object object;
                if ((object = this.relaxedPoll()) != null) {
                    return (E)object;
                }
                n2 = this.waitStrategy.idle(n2);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
    }
}

