/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.convert;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.convert.EnumConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ReflectionUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.TypeUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeConverterRegistry {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static volatile TypeConverterRegistry INSTANCE;
    private static final Object INSTANCE_LOCK;
    private final ConcurrentMap<Type, TypeConverter<?>> registry = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeConverterRegistry getInstance() {
        TypeConverterRegistry typeConverterRegistry = INSTANCE;
        if (typeConverterRegistry == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                typeConverterRegistry = INSTANCE;
                if (typeConverterRegistry == null) {
                    INSTANCE = typeConverterRegistry = new TypeConverterRegistry();
                }
            }
        }
        return typeConverterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConverter<?> findCompatibleConverter(Type type) {
        Object object;
        Objects.requireNonNull(type, "No type was provided");
        TypeConverter typeConverter = (TypeConverter)this.registry.get(type);
        if (typeConverter != null) {
            return typeConverter;
        }
        if (type instanceof Class && ((Class)(object = (Class)type)).isEnum()) {
            EnumConverter<Enum> enumConverter = new EnumConverter<Enum>(((Class)object).asSubclass(Enum.class));
            Object object2 = INSTANCE_LOCK;
            synchronized (object2) {
                return this.registerConverter(type, enumConverter);
            }
        }
        for (Map.Entry entry : this.registry.entrySet()) {
            Type type2 = (Type)entry.getKey();
            if (!TypeUtil.isAssignable(type, type2)) continue;
            LOGGER.debug("Found compatible TypeConverter<{}> for type [{}].", (Object)type2, (Object)type);
            TypeConverter typeConverter2 = (TypeConverter)entry.getValue();
            Object object3 = INSTANCE_LOCK;
            synchronized (object3) {
                return this.registerConverter(type, typeConverter2);
            }
        }
        throw new UnknownFormatConversionException(type.toString());
    }

    private TypeConverterRegistry() {
        LOGGER.trace("TypeConverterRegistry initializing.");
        PluginManager pluginManager = new PluginManager("TypeConverter");
        pluginManager.collectPlugins();
        this.loadKnownTypeConverters(pluginManager.getPlugins().values());
        this.registerPrimitiveTypes();
    }

    private void loadKnownTypeConverters(Collection<PluginType<?>> collection) {
        for (PluginType<?> pluginType : collection) {
            Class<?> clazz = pluginType.getPluginClass();
            if (!TypeConverter.class.isAssignableFrom(clazz)) continue;
            Class<TypeConverter> clazz2 = clazz.asSubclass(TypeConverter.class);
            Type type = TypeConverterRegistry.getTypeConverterSupportedType(clazz2);
            TypeConverter typeConverter = ReflectionUtil.instantiate(clazz2);
            this.registerConverter(type, typeConverter);
        }
    }

    private TypeConverter<?> registerConverter(Type type, TypeConverter<?> typeConverter) {
        TypeConverter typeConverter2 = (TypeConverter)this.registry.get(type);
        if (typeConverter2 != null) {
            Comparable comparable;
            Comparable comparable2;
            boolean bl = typeConverter instanceof Comparable ? (comparable2 = (Comparable)((Object)typeConverter)).compareTo(typeConverter2) < 0 : (typeConverter2 instanceof Comparable ? (comparable = (Comparable)((Object)typeConverter2)).compareTo(typeConverter) > 0 : false);
            if (bl) {
                LOGGER.debug("Replacing TypeConverter [{}] for type [{}] with [{}] after comparison.", (Object)typeConverter2, (Object)type, (Object)typeConverter);
                this.registry.put(type, typeConverter);
                return typeConverter;
            }
            LOGGER.warn("Ignoring TypeConverter [{}] for type [{}] that conflicts with [{}], since they are not comparable.", (Object)typeConverter, (Object)type, (Object)typeConverter2);
            return typeConverter2;
        }
        this.registry.put(type, typeConverter);
        return typeConverter;
    }

    private static Type getTypeConverterSupportedType(Class<? extends TypeConverter> clazz) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !TypeConverter.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return Void.TYPE;
    }

    private void registerPrimitiveTypes() {
        this.registerTypeAlias((Type)((Object)Boolean.class), Boolean.TYPE);
        this.registerTypeAlias((Type)((Object)Byte.class), Byte.TYPE);
        this.registerTypeAlias((Type)((Object)Character.class), Character.TYPE);
        this.registerTypeAlias((Type)((Object)Double.class), Double.TYPE);
        this.registerTypeAlias((Type)((Object)Float.class), Float.TYPE);
        this.registerTypeAlias((Type)((Object)Integer.class), Integer.TYPE);
        this.registerTypeAlias((Type)((Object)Long.class), Long.TYPE);
        this.registerTypeAlias((Type)((Object)Short.class), Short.TYPE);
    }

    private void registerTypeAlias(Type type, Type type2) {
        this.registry.putIfAbsent(type2, (TypeConverter<?>)this.registry.get(type));
    }

    static {
        INSTANCE_LOCK = new Object();
    }
}

