/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.ThreadContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.ContextDataInjector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.LocationAwareLogEventFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.LogEventFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.MutableLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Clock;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ClockFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringMap;
import java.util.List;

public class ReusableLogEventFactory
implements LocationAwareLogEventFactory,
LogEventFactory {
    private static final ThreadNameCachingStrategy THREAD_NAME_CACHING_STRATEGY = ThreadNameCachingStrategy.create();
    private static final Clock CLOCK = ClockFactory.getClock();
    private static final ThreadLocal<MutableLogEvent> mutableLogEventThreadLocal = new ThreadLocal();
    private final ContextDataInjector injector = ContextDataInjectorFactory.createInjector();

    @Override
    public LogEvent createEvent(String string, Marker marker, String string2, Level level, Message message, List<Property> list, Throwable throwable) {
        return this.createEvent(string, marker, string2, null, level, message, list, throwable);
    }

    @Override
    public LogEvent createEvent(String string, Marker marker, String string2, StackTraceElement stackTraceElement, Level level, Message message, List<Property> list, Throwable throwable) {
        MutableLogEvent mutableLogEvent = ReusableLogEventFactory.getOrCreateMutableLogEvent();
        mutableLogEvent.reserved = true;
        mutableLogEvent.setLoggerName(string);
        mutableLogEvent.setMarker(marker);
        mutableLogEvent.setLoggerFqcn(string2);
        mutableLogEvent.setLevel(level == null ? Level.OFF : level);
        mutableLogEvent.setMessage(message);
        mutableLogEvent.initTime(CLOCK, Log4jLogEvent.getNanoClock());
        mutableLogEvent.setThrown(throwable);
        mutableLogEvent.setSource(stackTraceElement);
        mutableLogEvent.setContextData(this.injector.injectContextData(list, (StringMap)mutableLogEvent.getContextData()));
        mutableLogEvent.setContextStack(ThreadContext.getDepth() == 0 ? ThreadContext.EMPTY_STACK : ThreadContext.cloneStack());
        if (THREAD_NAME_CACHING_STRATEGY == ThreadNameCachingStrategy.UNCACHED) {
            mutableLogEvent.setThreadName(Thread.currentThread().getName());
            mutableLogEvent.setThreadPriority(Thread.currentThread().getPriority());
        }
        return mutableLogEvent;
    }

    private static MutableLogEvent getOrCreateMutableLogEvent() {
        MutableLogEvent mutableLogEvent = mutableLogEventThreadLocal.get();
        return mutableLogEvent == null || mutableLogEvent.reserved ? ReusableLogEventFactory.createInstance(mutableLogEvent) : mutableLogEvent;
    }

    private static MutableLogEvent createInstance(MutableLogEvent mutableLogEvent) {
        MutableLogEvent mutableLogEvent2 = new MutableLogEvent();
        mutableLogEvent2.setThreadId(Thread.currentThread().getId());
        mutableLogEvent2.setThreadName(Thread.currentThread().getName());
        mutableLogEvent2.setThreadPriority(Thread.currentThread().getPriority());
        if (mutableLogEvent == null) {
            mutableLogEventThreadLocal.set(mutableLogEvent2);
        }
        return mutableLogEvent2;
    }

    public static void release(LogEvent logEvent) {
        if (logEvent instanceof MutableLogEvent) {
            MutableLogEvent mutableLogEvent = (MutableLogEvent)logEvent;
            mutableLogEvent.clear();
            mutableLogEvent.reserved = false;
        }
    }
}

