/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ExtendedClassInfo;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ThrowableProxy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.LoaderUtil;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ThrowableProxyHelper {
    private ThrowableProxyHelper() {
    }

    static ExtendedStackTraceElement[] toExtendedStackTrace(ThrowableProxy throwableProxy, Deque<Class<?>> deque, Map<String, CacheEntry> map, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        int n2;
        if (stackTraceElementArray != null) {
            int n3;
            int n4 = stackTraceElementArray.length - 1;
            for (n3 = stackTraceElementArray2.length - 1; n4 >= 0 && n3 >= 0 && stackTraceElementArray[n4].equals(stackTraceElementArray2[n3]); --n4, --n3) {
            }
            throwableProxy.setCommonElementCount(stackTraceElementArray2.length - 1 - n3);
            n2 = n3 + 1;
        } else {
            throwableProxy.setCommonElementCount(0);
            n2 = stackTraceElementArray2.length;
        }
        ExtendedStackTraceElement[] extendedStackTraceElementArray = new ExtendedStackTraceElement[n2];
        Class<?> clazz = deque.isEmpty() ? null : deque.peek();
        ClassLoader classLoader = null;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ExtendedClassInfo extendedClassInfo;
            CacheEntry cacheEntry;
            StackTraceElement stackTraceElement = stackTraceElementArray2[i2];
            String string = stackTraceElement.getClassName();
            if (clazz != null && string.equals(clazz.getName())) {
                cacheEntry = ThrowableProxyHelper.toCacheEntry(clazz, true);
                extendedClassInfo = cacheEntry.element;
                classLoader = cacheEntry.loader;
                deque.pop();
                clazz = deque.isEmpty() ? null : deque.peek();
            } else {
                CacheEntry cacheEntry2;
                cacheEntry = map.get(string);
                if (cacheEntry != null) {
                    cacheEntry2 = cacheEntry;
                    extendedClassInfo = cacheEntry2.element;
                    if (cacheEntry2.loader != null) {
                        classLoader = cacheEntry2.loader;
                    }
                } else {
                    cacheEntry2 = ThrowableProxyHelper.toCacheEntry(ThrowableProxyHelper.loadClass(classLoader, string), false);
                    extendedClassInfo = cacheEntry2.element;
                    map.put(string, cacheEntry2);
                    if (cacheEntry2.loader != null) {
                        classLoader = cacheEntry2.loader;
                    }
                }
            }
            extendedStackTraceElementArray[i2] = new ExtendedStackTraceElement(stackTraceElement, extendedClassInfo);
        }
        return extendedStackTraceElementArray;
    }

    static ThrowableProxy[] toSuppressedProxies(Throwable throwable, Set<Throwable> set) {
        try {
            Throwable[] throwableArray = throwable.getSuppressed();
            if (throwableArray == null || throwableArray.length == 0) {
                return ThrowableProxy.EMPTY_ARRAY;
            }
            ArrayList<ThrowableProxy> arrayList = new ArrayList<ThrowableProxy>(throwableArray.length);
            if (set == null) {
                set = new HashSet<Throwable>(throwableArray.length);
            }
            for (int i2 = 0; i2 < throwableArray.length; ++i2) {
                Throwable throwable2 = throwableArray[i2];
                if (!set.add(throwable2)) continue;
                arrayList.add(new ThrowableProxy(throwable2, set));
            }
            return arrayList.toArray(ThrowableProxy.EMPTY_ARRAY);
        }
        catch (Exception exception) {
            StatusLogger.getLogger().error(exception);
            return null;
        }
    }

    private static CacheEntry toCacheEntry(Class<?> clazz, boolean bl) {
        String string = "?";
        Object object = "?";
        ClassLoader classLoader = null;
        if (clazz != null) {
            Object object2;
            Object object3;
            try {
                object3 = clazz.getProtectionDomain().getCodeSource();
                if (object3 != null && (object2 = ((CodeSource)object3).getLocation()) != null) {
                    String string2 = ((URL)object2).toString().replace('\\', '/');
                    int n2 = string2.lastIndexOf("/");
                    if (n2 >= 0 && n2 == string2.length() - 1) {
                        n2 = string2.lastIndexOf("/", n2 - 1);
                    }
                    string = string2.substring(n2 + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = clazz.getPackage();
            if (object3 != null && (object2 = ((Package)object3).getImplementationVersion()) != null) {
                object = object2;
            }
            try {
                classLoader = clazz.getClassLoader();
            }
            catch (SecurityException securityException) {
                classLoader = null;
            }
        }
        return new CacheEntry(new ExtendedClassInfo(bl, string, (String)object), classLoader);
    }

    private static Class<?> loadClass(ClassLoader classLoader, String string) {
        Class<?> clazz;
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            clazz = LoaderUtil.loadClass(string);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return ThrowableProxyHelper.loadClass(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
        return clazz;
    }

    private static Class<?> loadClass(String string) {
        try {
            return Loader.loadClass(string, ThrowableProxyHelper.class.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError | SecurityException throwable) {
            return null;
        }
    }

    static final class CacheEntry {
        private final ExtendedClassInfo element;
        private final ClassLoader loader;

        private CacheEntry(ExtendedClassInfo extendedClassInfo, ClassLoader classLoader) {
            this.element = extendedClassInfo;
            this.loader = classLoader;
        }
    }
}

