/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class FormattingInfo {
    private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final char[] ZEROS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    private static final FormattingInfo DEFAULT = new FormattingInfo(false, 0, Integer.MAX_VALUE, true);
    private final int minLength;
    private final int maxLength;
    private final boolean leftAlign;
    private final boolean leftTruncate;
    private final boolean zeroPad;
    public static final FormattingInfo[] EMPTY_ARRAY = new FormattingInfo[0];

    public FormattingInfo(boolean bl, int n2, int n3, boolean bl2) {
        this(bl, n2, n3, bl2, false);
    }

    public FormattingInfo(boolean bl, int n2, int n3, boolean bl2, boolean bl3) {
        this.leftAlign = bl;
        this.minLength = n2;
        this.maxLength = n3;
        this.leftTruncate = bl2;
        this.zeroPad = bl3;
    }

    public static FormattingInfo getDefault() {
        return DEFAULT;
    }

    public boolean isLeftAligned() {
        return this.leftAlign;
    }

    public boolean isLeftTruncate() {
        return this.leftTruncate;
    }

    public boolean isZeroPad() {
        return this.zeroPad;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void format(int n2, StringBuilder stringBuilder) {
        int n3 = stringBuilder.length() - n2;
        if (n3 > this.maxLength) {
            if (this.leftTruncate) {
                stringBuilder.delete(n2, stringBuilder.length() - this.maxLength);
            } else {
                stringBuilder.delete(n2 + this.maxLength, n2 + stringBuilder.length());
            }
        } else if (n3 < this.minLength) {
            if (this.leftAlign) {
                int n4 = stringBuilder.length();
                stringBuilder.setLength(n2 + this.minLength);
                for (int i2 = n4; i2 < stringBuilder.length(); ++i2) {
                    stringBuilder.setCharAt(i2, ' ');
                }
            } else {
                int n5;
                char[] cArray;
                char[] cArray2 = cArray = this.zeroPad ? ZEROS : SPACES;
                for (n5 = this.minLength - n3; n5 > cArray.length; n5 -= cArray.length) {
                    stringBuilder.insert(n2, cArray);
                }
                stringBuilder.insert(n2, cArray, 0, n5);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[leftAlign=");
        stringBuilder.append(this.leftAlign);
        stringBuilder.append(", maxLength=");
        stringBuilder.append(this.maxLength);
        stringBuilder.append(", minLength=");
        stringBuilder.append(this.minLength);
        stringBuilder.append(", leftTruncate=");
        stringBuilder.append(this.leftTruncate);
        stringBuilder.append(", zeroPad=");
        stringBuilder.append(this.zeroPad);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

