/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.OptionConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
abstract class SimpleLiteralPatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private SimpleLiteralPatternConverter() {
        super("SimpleLiteral", "literal");
    }

    static LogEventPatternConverter of(String string, boolean bl) {
        String string2 = bl ? OptionConverter.convertSpecialChars(string) : string;
        return SimpleLiteralPatternConverter.of(string2);
    }

    static LogEventPatternConverter of(String string) {
        if (string == null || string.isEmpty()) {
            return Noop.INSTANCE;
        }
        if (" ".equals(string)) {
            return Space.INSTANCE;
        }
        return new StringValue(string);
    }

    @Override
    public final void format(LogEvent logEvent, StringBuilder stringBuilder) {
        this.format(stringBuilder);
    }

    @Override
    public final void format(Object object, StringBuilder stringBuilder) {
        this.format(stringBuilder);
    }

    @Override
    public final void format(StringBuilder stringBuilder, Object ... objectArray) {
        this.format(stringBuilder);
    }

    abstract void format(StringBuilder var1);

    @Override
    public final boolean isVariable() {
        return false;
    }

    @Override
    public final boolean handlesThrowable() {
        return false;
    }

    private static final class StringValue
    extends SimpleLiteralPatternConverter {
        private final String literal;

        StringValue(String string) {
            this.literal = string;
        }

        @Override
        void format(StringBuilder stringBuilder) {
            stringBuilder.append(this.literal);
        }
    }

    private static final class Space
    extends SimpleLiteralPatternConverter {
        private static final Space INSTANCE = new Space();

        private Space() {
        }

        @Override
        void format(StringBuilder stringBuilder) {
            stringBuilder.append(' ');
        }
    }

    private static final class Noop
    extends SimpleLiteralPatternConverter {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        void format(StringBuilder stringBuilder) {
        }
    }
}

