/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ContextAnchor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector.ContextSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContextShutdownAware;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StackLocatorUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ClassLoaderContextSelector
implements ContextSelector,
LoggerContextShutdownAware {
    private static final AtomicReference<LoggerContext> DEFAULT_CONTEXT = new AtomicReference();
    protected static final StatusLogger LOGGER = StatusLogger.getLogger();
    protected static final ConcurrentMap<String, AtomicReference<WeakReference<LoggerContext>>> CONTEXT_MAP = new ConcurrentHashMap<String, AtomicReference<WeakReference<LoggerContext>>>();

    @Override
    public void shutdown(String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        LoggerContext loggerContext = null;
        if (bl) {
            loggerContext = ContextAnchor.THREAD_CONTEXT.get();
        } else if (classLoader != null) {
            loggerContext = this.findContext(classLoader);
        } else {
            Class<?> clazz = StackLocatorUtil.getCallerClass(string);
            if (clazz != null) {
                loggerContext = this.findContext(clazz.getClassLoader());
            }
            if (loggerContext == null) {
                loggerContext = ContextAnchor.THREAD_CONTEXT.get();
            }
        }
        if (loggerContext != null) {
            loggerContext.stop(50L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void contextShutdown(com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContext loggerContext) {
        if (loggerContext instanceof LoggerContext) {
            this.removeContext((LoggerContext)loggerContext);
        }
    }

    @Override
    public boolean hasContext(String string, ClassLoader classLoader, boolean bl) {
        Class<?> clazz;
        LoggerContext loggerContext = bl ? ContextAnchor.THREAD_CONTEXT.get() : (classLoader != null ? this.findContext(classLoader) : ((clazz = StackLocatorUtil.getCallerClass(string)) != null ? this.findContext(clazz.getClassLoader()) : ContextAnchor.THREAD_CONTEXT.get()));
        return loggerContext != null && loggerContext.isStarted();
    }

    private LoggerContext findContext(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
        String string = this.toContextMapKey(classLoader2);
        AtomicReference atomicReference = (AtomicReference)CONTEXT_MAP.get(string);
        if (atomicReference != null) {
            WeakReference weakReference = (WeakReference)atomicReference.get();
            return (LoggerContext)weakReference.get();
        }
        return null;
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, boolean bl) {
        return this.getContext(string, classLoader, bl, null);
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, boolean bl, URI uRI) {
        return this.getContext(string, classLoader, null, bl, uRI);
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, Map.Entry<String, Object> entry, boolean bl, URI uRI) {
        if (bl) {
            LoggerContext loggerContext = ContextAnchor.THREAD_CONTEXT.get();
            if (loggerContext != null) {
                return loggerContext;
            }
            return this.getDefault();
        }
        if (classLoader != null) {
            return this.locateContext(classLoader, entry, uRI);
        }
        Class<?> clazz = StackLocatorUtil.getCallerClass(string);
        if (clazz != null) {
            return this.locateContext(clazz.getClassLoader(), entry, uRI);
        }
        LoggerContext loggerContext = ContextAnchor.THREAD_CONTEXT.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        return this.getDefault();
    }

    @Override
    public void removeContext(LoggerContext loggerContext) {
        for (Map.Entry entry : CONTEXT_MAP.entrySet()) {
            LoggerContext loggerContext2 = (LoggerContext)((WeakReference)((AtomicReference)entry.getValue()).get()).get();
            if (loggerContext2 != loggerContext) continue;
            CONTEXT_MAP.remove(entry.getKey());
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        return true;
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        ArrayList<LoggerContext> arrayList = new ArrayList<LoggerContext>();
        Collection collection = CONTEXT_MAP.values();
        for (AtomicReference atomicReference : collection) {
            LoggerContext loggerContext = (LoggerContext)((WeakReference)atomicReference.get()).get();
            if (loggerContext == null) continue;
            arrayList.add(loggerContext);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private LoggerContext locateContext(ClassLoader classLoader, Map.Entry<String, Object> entry, URI uRI) {
        ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
        String string = this.toContextMapKey(classLoader2);
        AtomicReference atomicReference = (AtomicReference)CONTEXT_MAP.get(string);
        if (atomicReference == null) {
            Object object;
            Object object2;
            if (uRI == null) {
                for (object2 = classLoader2.getParent(); object2 != null; object2 = ((ClassLoader)object2).getParent()) {
                    LoggerContext loggerContext;
                    atomicReference = (AtomicReference)CONTEXT_MAP.get(this.toContextMapKey((ClassLoader)object2));
                    if (atomicReference == null || (loggerContext = (LoggerContext)((Reference)(object = (WeakReference)atomicReference.get())).get()) == null) continue;
                    return loggerContext;
                }
            }
            object2 = this.createContext(string, uRI);
            if (entry != null) {
                ((LoggerContext)object2).putObject(entry.getKey(), entry.getValue());
            }
            if ((object = (LoggerContext)((WeakReference)CONTEXT_MAP.computeIfAbsent(string, arg_0 -> ClassLoaderContextSelector.lambda$locateContext$0((LoggerContext)object2, arg_0)).get()).get()) == object2) {
                ((LoggerContext)object2).addShutdownListener(this);
            }
            return object;
        }
        WeakReference weakReference = (WeakReference)atomicReference.get();
        LoggerContext loggerContext = (LoggerContext)weakReference.get();
        if (loggerContext != null) {
            if (entry != null && loggerContext.getObject(entry.getKey()) == null) {
                loggerContext.putObject(entry.getKey(), entry.getValue());
            }
            if (loggerContext.getConfigLocation() == null && uRI != null) {
                LOGGER.debug("Setting configuration to {}", (Object)uRI);
                loggerContext.setConfigLocation(uRI);
            } else if (loggerContext.getConfigLocation() != null && uRI != null && !loggerContext.getConfigLocation().equals(uRI)) {
                LOGGER.warn("locateContext called with URI {}. Existing LoggerContext has URI {}", (Object)uRI, (Object)loggerContext.getConfigLocation());
            }
            return loggerContext;
        }
        loggerContext = this.createContext(string, uRI);
        if (entry != null) {
            loggerContext.putObject(entry.getKey(), entry.getValue());
        }
        atomicReference.compareAndSet(weakReference, new WeakReference<LoggerContext>(loggerContext));
        return loggerContext;
    }

    protected LoggerContext createContext(String string, URI uRI) {
        return new LoggerContext(string, null, uRI);
    }

    protected String toContextMapKey(ClassLoader classLoader) {
        return Integer.toHexString(System.identityHashCode(classLoader));
    }

    protected LoggerContext getDefault() {
        LoggerContext loggerContext = DEFAULT_CONTEXT.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        DEFAULT_CONTEXT.compareAndSet(null, this.createContext(this.defaultContextName(), null));
        return DEFAULT_CONTEXT.get();
    }

    protected String defaultContextName() {
        return "Default";
    }

    private static /* synthetic */ AtomicReference lambda$locateContext$0(LoggerContext loggerContext, String string) {
        return new AtomicReference<WeakReference<LoggerContext>>(new WeakReference<LoggerContext>(loggerContext));
    }
}

