/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;

public final class CronExpression {
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final Integer ALL_SPEC = 99;
    protected static final Integer NO_SPEC = 98;
    protected static final Map<String, Integer> monthMap = new HashMap<String, Integer>(20);
    protected static final Map<String, Integer> dayMap = new HashMap<String, Integer>(60);
    private final String cronExpression;
    private TimeZone timeZone = null;
    protected transient TreeSet<Integer> seconds;
    protected transient TreeSet<Integer> minutes;
    protected transient TreeSet<Integer> hours;
    protected transient TreeSet<Integer> daysOfMonth;
    protected transient TreeSet<Integer> months;
    protected transient TreeSet<Integer> daysOfWeek;
    protected transient TreeSet<Integer> years;
    protected transient boolean lastdayOfWeek = false;
    protected transient int nthdayOfWeek = 0;
    protected transient boolean lastdayOfMonth = false;
    protected transient boolean nearestWeekday = false;
    protected transient int lastdayOffset = 0;
    protected transient boolean expressionParsed = false;
    public static final int MAX_YEAR;
    public static final Calendar MIN_CAL;
    public static final Date MIN_DATE;

    public CronExpression(String string) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("cronExpression cannot be null");
        }
        this.cronExpression = string.toUpperCase(Locale.US);
        this.buildExpression(this.cronExpression);
    }

    public boolean isSatisfiedBy(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(13, -1);
        Date date3 = this.getTimeAfter(calendar.getTime());
        return date3 != null && date3.equals(date2);
    }

    public Date getNextValidTimeAfter(Date date) {
        return this.getTimeAfter(date);
    }

    public Date getNextInvalidTimeAfter(Date date) {
        Date date2;
        long l2 = 1000L;
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        calendar.set(14, 0);
        Date date3 = calendar.getTime();
        while (l2 == 1000L && (date2 = this.getTimeAfter(date3)) != null) {
            l2 = date2.getTime() - date3.getTime();
            if (l2 != 1000L) continue;
            date3 = date2;
        }
        return new Date(date3.getTime() + 1000L);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        return this.cronExpression;
    }

    public static boolean isValidExpression(String string) {
        try {
            new CronExpression(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public static void validateExpression(String string) throws ParseException {
        new CronExpression(string);
    }

    protected void buildExpression(String string) throws ParseException {
        this.expressionParsed = true;
        try {
            boolean bl;
            TreeSet<Integer> treeSet;
            Object object;
            int n2;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t", false);
            for (n2 = 0; stringTokenizer.hasMoreTokens() && n2 <= 6; ++n2) {
                object = stringTokenizer.nextToken().trim();
                if (n2 == 3 && ((String)object).indexOf(76) != -1 && ((String)object).length() > 1 && ((String)object).contains(",")) {
                    throw new ParseException("Support for specifying 'L' and 'LW' with other days of the month is not implemented", -1);
                }
                if (n2 == 5 && ((String)object).indexOf(76) != -1 && ((String)object).length() > 1 && ((String)object).contains(",")) {
                    throw new ParseException("Support for specifying 'L' with other days of the week is not implemented", -1);
                }
                if (n2 == 5 && ((String)object).indexOf(35) != -1 && ((String)object).indexOf(35, ((String)object).indexOf(35) + 1) != -1) {
                    throw new ParseException("Support for specifying multiple \"nth\" days is not implemented.", -1);
                }
                treeSet = new StringTokenizer((String)object, ",");
                while (((StringTokenizer)((Object)treeSet)).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)((Object)treeSet)).nextToken();
                    this.storeExpressionVals(0, string2, n2);
                }
            }
            if (n2 <= 5) {
                throw new ParseException("Unexpected end of expression.", string.length());
            }
            if (n2 <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
            object = this.getSet(5);
            treeSet = this.getSet(3);
            boolean bl2 = !treeSet.contains(NO_SPEC);
            boolean bl3 = bl = !((TreeSet)object).contains(NO_SPEC);
            if (!(bl2 && !bl || bl && !bl2)) {
                throw new ParseException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", 0);
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException("Illegal cron expression format (" + exception.toString() + ")", 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int storeExpressionVals(int n2, String string, int n3) throws ParseException {
        int n4 = 0;
        int n5 = this.skipWhiteSpace(n2, string);
        if (n5 >= string.length()) {
            return n5;
        }
        char c2 = string.charAt(n5);
        if (!(c2 < 'A' || c2 > 'Z' || string.equals("L") || string.equals("LW") || string.matches("^L-[0-9]*[W]?"))) {
            String string2 = string.substring(n5, n5 + 3);
            int n6 = -1;
            int n7 = -1;
            if (n3 == 4) {
                n6 = this.getMonthNumber(string2) + 1;
                if (n6 <= 0) {
                    throw new ParseException("Invalid Month value: '" + string2 + "'", n5);
                }
                if (string.length() > n5 + 3 && (c2 = string.charAt(n5 + 3)) == '-' && (n7 = this.getMonthNumber(string2 = string.substring(n5 += 4, n5 + 3)) + 1) <= 0) {
                    throw new ParseException("Invalid Month value: '" + string2 + "'", n5);
                }
            } else {
                if (n3 != 5) throw new ParseException("Illegal characters for this position: '" + string2 + "'", n5);
                n6 = this.getDayOfWeekNumber(string2);
                if (n6 < 0) {
                    throw new ParseException("Invalid Day-of-Week value: '" + string2 + "'", n5);
                }
                if (string.length() > n5 + 3) {
                    c2 = string.charAt(n5 + 3);
                    switch (c2) {
                        case '-': {
                            string2 = string.substring(n5 += 4, n5 + 3);
                            n7 = this.getDayOfWeekNumber(string2);
                            if (n7 < 0) {
                                throw new ParseException("Invalid Day-of-Week value: '" + string2 + "'", n5);
                            }
                            break;
                        }
                        case '#': {
                            try {
                                this.nthdayOfWeek = Integers.parseInt(string.substring(n5 += 4));
                                if (this.nthdayOfWeek < 1) throw new Exception();
                                if (this.nthdayOfWeek > 5) {
                                    throw new Exception();
                                }
                                break;
                            }
                            catch (Exception exception) {
                                throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", n5);
                            }
                        }
                        case 'L': {
                            this.lastdayOfWeek = true;
                            ++n5;
                            break;
                        }
                    }
                }
            }
            if (n7 != -1) {
                n4 = 1;
            }
            this.addToSet(n6, n7, n4, n3);
            return n5 + 3;
        }
        switch (c2) {
            case '?': {
                int n8;
                if (++n5 + 1 < string.length() && string.charAt(n5) != ' ' && string.charAt(n5 + 1) != '\t') {
                    throw new ParseException("Illegal character after '?': " + string.charAt(n5), n5);
                }
                if (n3 != 5 && n3 != 3) {
                    throw new ParseException("'?' can only be specfied for Day-of-Month or Day-of-Week.", n5);
                }
                if (n3 == 5 && !this.lastdayOfMonth && (n8 = this.daysOfMonth.last().intValue()) == 98) {
                    throw new ParseException("'?' can only be specfied for Day-of-Month -OR- Day-of-Week.", n5);
                }
                this.addToSet(98, -1, 0, n3);
                return n5;
            }
            case '*': 
            case '/': {
                if (c2 == '*' && n5 + 1 >= string.length()) {
                    this.addToSet(99, -1, n4, n3);
                    return n5 + 1;
                }
                if (c2 == '/') {
                    if (n5 + 1 >= string.length()) throw new ParseException("'/' must be followed by an integer.", n5);
                    if (string.charAt(n5 + 1) == ' ') throw new ParseException("'/' must be followed by an integer.", n5);
                    if (string.charAt(n5 + 1) == '\t') {
                        throw new ParseException("'/' must be followed by an integer.", n5);
                    }
                }
                if (c2 == '*') {
                    ++n5;
                }
                if ((c2 = string.charAt(n5)) == '/') {
                    if (++n5 >= string.length()) {
                        throw new ParseException("Unexpected end of string.", n5);
                    }
                    n4 = this.getNumericValue(string, n5);
                    ++n5;
                    if (n4 > 10) {
                        ++n5;
                    }
                    if (n4 > 59) {
                        if (n3 == 0) throw new ParseException("Increment > 60 : " + n4, n5);
                        if (n3 == 1) {
                            throw new ParseException("Increment > 60 : " + n4, n5);
                        }
                    }
                    if (n4 > 23 && n3 == 2) {
                        throw new ParseException("Increment > 24 : " + n4, n5);
                    }
                    if (n4 > 31 && n3 == 3) {
                        throw new ParseException("Increment > 31 : " + n4, n5);
                    }
                    if (n4 > 7 && n3 == 5) {
                        throw new ParseException("Increment > 7 : " + n4, n5);
                    }
                    if (n4 > 12 && n3 == 4) {
                        throw new ParseException("Increment > 12 : " + n4, n5);
                    }
                } else {
                    n4 = 1;
                }
                this.addToSet(99, -1, n4, n3);
                return n5;
            }
            case 'L': {
                ++n5;
                if (n3 == 3) {
                    this.lastdayOfMonth = true;
                }
                if (n3 == 5) {
                    this.addToSet(7, 7, 0, n3);
                }
                if (n3 != 3) return n5;
                if (string.length() <= n5) return n5;
                c2 = string.charAt(n5);
                if (c2 == '-') {
                    ValueSet valueSet = this.getValue(0, string, n5 + 1);
                    this.lastdayOffset = valueSet.value;
                    if (this.lastdayOffset > 30) {
                        throw new ParseException("Offset from last day must be <= 30", n5 + 1);
                    }
                    n5 = valueSet.pos;
                }
                if (string.length() <= n5) return n5;
                c2 = string.charAt(n5);
                if (c2 != 'W') return n5;
                this.nearestWeekday = true;
                ++n5;
                return n5;
            }
        }
        if (c2 < '0') throw new ParseException("Unexpected character: " + c2, n5);
        if (c2 > '9') throw new ParseException("Unexpected character: " + c2, n5);
        int n9 = Integer.parseInt(String.valueOf(c2));
        if (++n5 < string.length()) {
            c2 = string.charAt(n5);
            if (c2 < '0') return this.checkNext(n5, string, n9, n3);
            if (c2 > '9') return this.checkNext(n5, string, n9, n3);
            ValueSet valueSet = this.getValue(n9, string, n5);
            n9 = valueSet.value;
            n5 = valueSet.pos;
            return this.checkNext(n5, string, n9, n3);
        }
        this.addToSet(n9, -1, -1, n3);
        return n5;
    }

    protected int checkNext(int n2, String string, int n3, int n4) throws ParseException {
        int n5 = -1;
        int n6 = n2;
        if (n6 >= string.length()) {
            this.addToSet(n3, n5, -1, n4);
            return n6;
        }
        char c2 = string.charAt(n2);
        if (c2 == 'L') {
            if (n4 == 5) {
                if (n3 < 1 || n3 > 7) {
                    throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
                }
            } else {
                throw new ParseException("'L' option is not valid here. (pos=" + n6 + ")", n6);
            }
            this.lastdayOfWeek = true;
            TreeSet<Integer> treeSet = this.getSet(n4);
            treeSet.add(n3);
            return ++n6;
        }
        if (c2 == 'W') {
            if (n4 != 3) {
                throw new ParseException("'W' option is not valid here. (pos=" + n6 + ")", n6);
            }
            this.nearestWeekday = true;
            if (n3 > 31) {
                throw new ParseException("The 'W' option does not make sense with values larger than 31 (max number of days in a month)", n6);
            }
            TreeSet<Integer> treeSet = this.getSet(n4);
            treeSet.add(n3);
            return ++n6;
        }
        switch (c2) {
            case '#': {
                if (n4 != 5) {
                    throw new ParseException("'#' option is not valid here. (pos=" + n6 + ")", n6);
                }
                ++n6;
                try {
                    this.nthdayOfWeek = Integers.parseInt(string.substring(n6));
                    if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", n6);
                }
                TreeSet<Integer> treeSet = this.getSet(n4);
                treeSet.add(n3);
                return ++n6;
            }
            case '-': {
                int n7;
                c2 = string.charAt(++n6);
                n5 = n7 = Integer.parseInt(String.valueOf(c2));
                if (++n6 >= string.length()) {
                    this.addToSet(n3, n5, 1, n4);
                    return n6;
                }
                c2 = string.charAt(n6);
                if (c2 >= '0' && c2 <= '9') {
                    ValueSet valueSet = this.getValue(n7, string, n6);
                    n5 = valueSet.value;
                    n6 = valueSet.pos;
                }
                if (n6 < string.length() && (c2 = string.charAt(n6)) == '/') {
                    c2 = string.charAt(++n6);
                    int n8 = Integer.parseInt(String.valueOf(c2));
                    if (++n6 >= string.length()) {
                        this.addToSet(n3, n5, n8, n4);
                        return n6;
                    }
                    c2 = string.charAt(n6);
                    if (c2 >= '0' && c2 <= '9') {
                        ValueSet valueSet = this.getValue(n8, string, n6);
                        int n9 = valueSet.value;
                        this.addToSet(n3, n5, n9, n4);
                        n6 = valueSet.pos;
                    } else {
                        this.addToSet(n3, n5, n8, n4);
                    }
                    return n6;
                }
                this.addToSet(n3, n5, 1, n4);
                return n6;
            }
            case '/': {
                c2 = string.charAt(++n6);
                int n10 = Integer.parseInt(String.valueOf(c2));
                if (++n6 >= string.length()) {
                    this.addToSet(n3, n5, n10, n4);
                    return n6;
                }
                c2 = string.charAt(n6);
                if (c2 >= '0' && c2 <= '9') {
                    ValueSet valueSet = this.getValue(n10, string, n6);
                    int n11 = valueSet.value;
                    this.addToSet(n3, n5, n11, n4);
                    n6 = valueSet.pos;
                    return n6;
                }
                throw new ParseException("Unexpected character '" + c2 + "' after '/'", n6);
            }
        }
        this.addToSet(n3, n5, 0, n4);
        return ++n6;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getExpressionSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("seconds: ");
        stringBuilder.append(this.getExpressionSetSummary(this.seconds));
        stringBuilder.append("\n");
        stringBuilder.append("minutes: ");
        stringBuilder.append(this.getExpressionSetSummary(this.minutes));
        stringBuilder.append("\n");
        stringBuilder.append("hours: ");
        stringBuilder.append(this.getExpressionSetSummary(this.hours));
        stringBuilder.append("\n");
        stringBuilder.append("daysOfMonth: ");
        stringBuilder.append(this.getExpressionSetSummary(this.daysOfMonth));
        stringBuilder.append("\n");
        stringBuilder.append("months: ");
        stringBuilder.append(this.getExpressionSetSummary(this.months));
        stringBuilder.append("\n");
        stringBuilder.append("daysOfWeek: ");
        stringBuilder.append(this.getExpressionSetSummary(this.daysOfWeek));
        stringBuilder.append("\n");
        stringBuilder.append("lastdayOfWeek: ");
        stringBuilder.append(this.lastdayOfWeek);
        stringBuilder.append("\n");
        stringBuilder.append("nearestWeekday: ");
        stringBuilder.append(this.nearestWeekday);
        stringBuilder.append("\n");
        stringBuilder.append("NthDayOfWeek: ");
        stringBuilder.append(this.nthdayOfWeek);
        stringBuilder.append("\n");
        stringBuilder.append("lastdayOfMonth: ");
        stringBuilder.append(this.lastdayOfMonth);
        stringBuilder.append("\n");
        stringBuilder.append("years: ");
        stringBuilder.append(this.getExpressionSetSummary(this.years));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    protected String getExpressionSetSummary(Set<Integer> set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Integer> iterator = set.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            String string = n2.toString();
            if (!bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    protected String getExpressionSetSummary(ArrayList<Integer> arrayList) {
        if (arrayList.contains(NO_SPEC)) {
            return "?";
        }
        if (arrayList.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Integer> iterator = arrayList.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            String string = n2.toString();
            if (!bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    protected int skipWhiteSpace(int n2, String string) {
        while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
            ++n2;
        }
        return n2;
    }

    protected int findNextWhiteSpace(int n2, String string) {
        while (n2 < string.length() && (string.charAt(n2) != ' ' || string.charAt(n2) != '\t')) {
            ++n2;
        }
        return n2;
    }

    protected void addToSet(int n2, int n3, int n4, int n5) throws ParseException {
        TreeSet<Integer> treeSet = this.getSet(n5);
        switch (n5) {
            case 0: 
            case 1: {
                if (n2 >= 0 && n2 <= 59 && n3 <= 59 || n2 == 99) break;
                throw new ParseException("Minute and Second values must be between 0 and 59", -1);
            }
            case 2: {
                if (n2 >= 0 && n2 <= 23 && n3 <= 23 || n2 == 99) break;
                throw new ParseException("Hour values must be between 0 and 23", -1);
            }
            case 3: {
                if (n2 >= 1 && n2 <= 31 && n3 <= 31 || n2 == 99 || n2 == 98) break;
                throw new ParseException("Day of month values must be between 1 and 31", -1);
            }
            case 4: {
                if (n2 >= 1 && n2 <= 12 && n3 <= 12 || n2 == 99) break;
                throw new ParseException("Month values must be between 1 and 12", -1);
            }
            case 5: {
                if (n2 != 0 && n2 <= 7 && n3 <= 7 || n2 == 99 || n2 == 98) break;
                throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
            }
        }
        if ((n4 == 0 || n4 == -1) && n2 != 99) {
            if (n2 != -1) {
                treeSet.add(n2);
            } else {
                treeSet.add(NO_SPEC);
            }
            return;
        }
        int n6 = n2;
        int n7 = n3;
        if (n2 == 99 && n4 <= 0) {
            n4 = 1;
            treeSet.add(ALL_SPEC);
        }
        switch (n5) {
            case 0: 
            case 1: {
                if (n7 == -1) {
                    n7 = 59;
                }
                if (n6 != -1 && n6 != 99) break;
                n6 = 0;
                break;
            }
            case 2: {
                if (n7 == -1) {
                    n7 = 23;
                }
                if (n6 != -1 && n6 != 99) break;
                n6 = 0;
                break;
            }
            case 3: {
                if (n7 == -1) {
                    n7 = 31;
                }
                if (n6 != -1 && n6 != 99) break;
                n6 = 1;
                break;
            }
            case 4: {
                if (n7 == -1) {
                    n7 = 12;
                }
                if (n6 != -1 && n6 != 99) break;
                n6 = 1;
                break;
            }
            case 5: {
                if (n7 == -1) {
                    n7 = 7;
                }
                if (n6 != -1 && n6 != 99) break;
                n6 = 1;
                break;
            }
            case 6: {
                if (n7 == -1) {
                    n7 = MAX_YEAR;
                }
                if (n6 != -1 && n6 != 99) break;
                n6 = 1970;
                break;
            }
        }
        int n8 = -1;
        if (n7 < n6) {
            switch (n5) {
                case 0: {
                    n8 = 60;
                    break;
                }
                case 1: {
                    n8 = 60;
                    break;
                }
                case 2: {
                    n8 = 24;
                    break;
                }
                case 4: {
                    n8 = 12;
                    break;
                }
                case 5: {
                    n8 = 7;
                    break;
                }
                case 3: {
                    n8 = 31;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Start year must be less than stop year");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type encountered");
                }
            }
            n7 += n8;
        }
        for (int i2 = n6; i2 <= n7; i2 += n4) {
            if (n8 == -1) {
                treeSet.add(i2);
                continue;
            }
            int n9 = i2 % n8;
            if (n9 == 0 && (n5 == 4 || n5 == 5 || n5 == 3)) {
                n9 = n8;
            }
            treeSet.add(n9);
        }
    }

    TreeSet<Integer> getSet(int n2) {
        switch (n2) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    protected ValueSet getValue(int n2, String string, int n3) {
        char c2 = string.charAt(n3);
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(n2));
        while (c2 >= '0' && c2 <= '9') {
            stringBuilder.append(c2);
            if (++n3 >= string.length()) break;
            c2 = string.charAt(n3);
        }
        ValueSet valueSet = new ValueSet();
        valueSet.pos = n3 < string.length() ? n3 : n3 + 1;
        valueSet.value = Integers.parseInt(stringBuilder.toString());
        return valueSet;
    }

    protected int getNumericValue(String string, int n2) {
        int n3 = this.findNextWhiteSpace(n2, string);
        String string2 = string.substring(n2, n3);
        return Integers.parseInt(string2);
    }

    protected int getMonthNumber(String string) {
        Integer n2 = monthMap.get(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    protected int getDayOfWeekNumber(String string) {
        Integer n2 = dayMap.get(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public Date getTimeAfter(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        date = new Date(date.getTime() + 1000L);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(14, 0);
        boolean bl = false;
        while (!bl) {
            int n2;
            int n3;
            boolean bl2;
            if (gregorianCalendar.get(1) > 2999) {
                return null;
            }
            int n4 = gregorianCalendar.get(13);
            int n5 = gregorianCalendar.get(12);
            SortedSet<Integer> sortedSet = this.seconds.tailSet(n4);
            if (sortedSet != null && sortedSet.size() != 0) {
                n4 = sortedSet.first();
            } else {
                n4 = this.seconds.first();
                gregorianCalendar.set(12, ++n5);
            }
            gregorianCalendar.set(13, n4);
            n5 = gregorianCalendar.get(12);
            int n6 = gregorianCalendar.get(11);
            int n7 = -1;
            sortedSet = this.minutes.tailSet(n5);
            if (sortedSet != null && sortedSet.size() != 0) {
                n7 = n5;
                n5 = sortedSet.first();
            } else {
                n5 = this.minutes.first();
                ++n6;
            }
            if (n5 != n7) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, n5);
                this.setCalendarHour(gregorianCalendar, n6);
                continue;
            }
            gregorianCalendar.set(12, n5);
            n6 = gregorianCalendar.get(11);
            int n8 = gregorianCalendar.get(5);
            n7 = -1;
            sortedSet = this.hours.tailSet(n6);
            if (sortedSet != null && sortedSet.size() != 0) {
                n7 = n6;
                n6 = sortedSet.first();
            } else {
                n6 = this.hours.first();
                ++n8;
            }
            if (n6 != n7) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(5, n8);
                this.setCalendarHour(gregorianCalendar, n6);
                continue;
            }
            gregorianCalendar.set(11, n6);
            n8 = gregorianCalendar.get(5);
            int n9 = gregorianCalendar.get(2) + 1;
            n7 = -1;
            int n10 = n9;
            boolean bl3 = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl4 = bl2 = !this.daysOfWeek.contains(NO_SPEC);
            if (bl3 && !bl2) {
                sortedSet = this.daysOfMonth.tailSet(n8);
                if (this.lastdayOfMonth) {
                    if (!this.nearestWeekday) {
                        n7 = n8;
                        n8 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1));
                        if (n7 > (n8 -= this.lastdayOffset)) {
                            if (++n9 > 12) {
                                n9 = 1;
                                n10 = 3333;
                                ((Calendar)gregorianCalendar).add(1, 1);
                            }
                            n8 = 1;
                        }
                    } else {
                        n7 = n8;
                        n8 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1));
                        Calendar calendar = Calendar.getInstance(this.getTimeZone());
                        calendar.set(13, 0);
                        calendar.set(12, 0);
                        calendar.set(11, 0);
                        calendar.set(5, n8 -= this.lastdayOffset);
                        calendar.set(2, n9 - 1);
                        calendar.set(1, gregorianCalendar.get(1));
                        n3 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1));
                        n2 = calendar.get(7);
                        if (n2 == 7 && n8 == 1) {
                            n8 += 2;
                        } else if (n2 == 7) {
                            --n8;
                        } else if (n2 == 1 && n8 == n3) {
                            n8 -= 2;
                        } else if (n2 == 1) {
                            ++n8;
                        }
                        calendar.set(13, n4);
                        calendar.set(12, n5);
                        calendar.set(11, n6);
                        calendar.set(5, n8);
                        calendar.set(2, n9 - 1);
                        Date date2 = calendar.getTime();
                        if (date2.before(date)) {
                            n8 = 1;
                            ++n9;
                        }
                    }
                } else if (this.nearestWeekday) {
                    n7 = n8;
                    n8 = this.daysOfMonth.first();
                    Calendar calendar = Calendar.getInstance(this.getTimeZone());
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(5, n8);
                    calendar.set(2, n9 - 1);
                    calendar.set(1, gregorianCalendar.get(1));
                    n3 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1));
                    n2 = calendar.get(7);
                    if (n2 == 7 && n8 == 1) {
                        n8 += 2;
                    } else if (n2 == 7) {
                        --n8;
                    } else if (n2 == 1 && n8 == n3) {
                        n8 -= 2;
                    } else if (n2 == 1) {
                        ++n8;
                    }
                    calendar.set(13, n4);
                    calendar.set(12, n5);
                    calendar.set(11, n6);
                    calendar.set(5, n8);
                    calendar.set(2, n9 - 1);
                    Date date3 = calendar.getTime();
                    if (date3.before(date)) {
                        n8 = this.daysOfMonth.first();
                        ++n9;
                    }
                } else if (sortedSet != null && sortedSet.size() != 0) {
                    int n11;
                    n7 = n8;
                    n8 = sortedSet.first();
                    if (n8 > (n11 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1)))) {
                        n8 = this.daysOfMonth.first();
                        ++n9;
                    }
                } else {
                    n8 = this.daysOfMonth.first();
                    ++n9;
                }
                if (n8 != n7 || n9 != n10) {
                    gregorianCalendar.set(13, 0);
                    gregorianCalendar.set(12, 0);
                    gregorianCalendar.set(11, 0);
                    gregorianCalendar.set(5, n8);
                    gregorianCalendar.set(2, n9 - 1);
                    continue;
                }
            } else if (bl2 && !bl3) {
                if (this.lastdayOfWeek) {
                    int n12;
                    int n13 = this.daysOfWeek.first();
                    n3 = gregorianCalendar.get(7);
                    n2 = 0;
                    if (n3 < n13) {
                        n2 = n13 - n3;
                    }
                    if (n3 > n13) {
                        n2 = n13 + (7 - n3);
                    }
                    if (n8 + n2 > (n12 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1)))) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(2, n9);
                        continue;
                    }
                    while (n8 + n2 + 7 <= n12) {
                        n2 += 7;
                    }
                    n8 += n2;
                    if (n2 > 0) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, n8);
                        gregorianCalendar.set(2, n9 - 1);
                        continue;
                    }
                } else if (this.nthdayOfWeek != 0) {
                    int n14 = this.daysOfWeek.first();
                    n3 = gregorianCalendar.get(7);
                    n2 = 0;
                    if (n3 < n14) {
                        n2 = n14 - n3;
                    } else if (n3 > n14) {
                        n2 = n14 + (7 - n3);
                    }
                    boolean bl5 = false;
                    if (n2 > 0) {
                        bl5 = true;
                    }
                    int n15 = (n8 += n2) / 7;
                    if (n8 % 7 > 0) {
                        ++n15;
                    }
                    if ((n2 = (this.nthdayOfWeek - n15) * 7) < 0 || (n8 += n2) > this.getLastDayOfMonth(n9, gregorianCalendar.get(1))) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(2, n9);
                        continue;
                    }
                    if (n2 > 0 || bl5) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, n8);
                        gregorianCalendar.set(2, n9 - 1);
                        continue;
                    }
                } else {
                    int n16;
                    int n17 = gregorianCalendar.get(7);
                    n3 = this.daysOfWeek.first();
                    sortedSet = this.daysOfWeek.tailSet(n17);
                    if (sortedSet != null && sortedSet.size() > 0) {
                        n3 = sortedSet.first();
                    }
                    n2 = 0;
                    if (n17 < n3) {
                        n2 = n3 - n17;
                    }
                    if (n17 > n3) {
                        n2 = n3 + (7 - n17);
                    }
                    if (n8 + n2 > (n16 = this.getLastDayOfMonth(n9, gregorianCalendar.get(1)))) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(2, n9);
                        continue;
                    }
                    if (n2 > 0) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, n8 + n2);
                        gregorianCalendar.set(2, n9 - 1);
                        continue;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
            }
            gregorianCalendar.set(5, n8);
            n9 = gregorianCalendar.get(2) + 1;
            int n18 = gregorianCalendar.get(1);
            n7 = -1;
            if (n18 > MAX_YEAR) {
                return null;
            }
            sortedSet = this.months.tailSet(n9);
            if (sortedSet != null && sortedSet.size() != 0) {
                n7 = n9;
                n9 = sortedSet.first();
            } else {
                n9 = this.months.first();
                ++n18;
            }
            if (n9 != n7) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(2, n9 - 1);
                gregorianCalendar.set(1, n18);
                continue;
            }
            gregorianCalendar.set(2, n9 - 1);
            n18 = gregorianCalendar.get(1);
            n7 = -1;
            sortedSet = this.years.tailSet(n18);
            if (sortedSet == null || sortedSet.size() == 0) {
                return null;
            }
            n7 = n18;
            n18 = sortedSet.first();
            if (n18 != n7) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(1, n18);
                continue;
            }
            gregorianCalendar.set(1, n18);
            bl = true;
        }
        return gregorianCalendar.getTime();
    }

    protected void setCalendarHour(Calendar calendar, int n2) {
        calendar.set(11, n2);
        if (calendar.get(11) != n2 && n2 != 24) {
            calendar.set(11, n2 + 1);
        }
    }

    protected Date getTimeBefore(Date date) {
        Date date2;
        Date date3;
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        calendar.set(14, 0);
        Date date4 = date3 = calendar.getTime();
        long l2 = this.findMinIncrement();
        do {
            Date date5;
            if ((date2 = this.getTimeAfter(date5 = new Date(date4.getTime() - l2))) == null || date2.before(MIN_DATE)) {
                return null;
            }
            date4 = date5;
        } while (date2.compareTo(date3) >= 0);
        return date2;
    }

    public Date getPrevFireTime(Date date) {
        return this.getTimeBefore(date);
    }

    private long findMinIncrement() {
        if (this.seconds.size() != 1) {
            return this.minInSet(this.seconds) * 1000;
        }
        if (this.seconds.first() == 99) {
            return 1000L;
        }
        if (this.minutes.size() != 1) {
            return this.minInSet(this.minutes) * 60000;
        }
        if (this.minutes.first() == 99) {
            return 60000L;
        }
        if (this.hours.size() != 1) {
            return this.minInSet(this.hours) * 3600000;
        }
        if (this.hours.first() == 99) {
            return 3600000L;
        }
        return 86400000L;
    }

    private int minInSet(TreeSet<Integer> treeSet) {
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        boolean bl = true;
        for (int n4 : treeSet) {
            if (bl) {
                n2 = n4;
                bl = false;
                continue;
            }
            int n5 = n4 - n2;
            if (n5 >= n3) continue;
            n3 = n5;
        }
        return n3;
    }

    public Date getFinalFireTime() {
        return null;
    }

    protected boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0;
    }

    protected int getLastDayOfMonth(int n2, int n3) {
        switch (n2) {
            case 1: {
                return 31;
            }
            case 2: {
                return this.isLeapYear(n3) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + n2);
    }

    static {
        monthMap.put("JAN", 0);
        monthMap.put("FEB", 1);
        monthMap.put("MAR", 2);
        monthMap.put("APR", 3);
        monthMap.put("MAY", 4);
        monthMap.put("JUN", 5);
        monthMap.put("JUL", 6);
        monthMap.put("AUG", 7);
        monthMap.put("SEP", 8);
        monthMap.put("OCT", 9);
        monthMap.put("NOV", 10);
        monthMap.put("DEC", 11);
        dayMap.put("SUN", 1);
        dayMap.put("MON", 2);
        dayMap.put("TUE", 3);
        dayMap.put("WED", 4);
        dayMap.put("THU", 5);
        dayMap.put("FRI", 6);
        dayMap.put("SAT", 7);
        MAX_YEAR = Calendar.getInstance().get(1) + 100;
        MIN_CAL = Calendar.getInstance();
        MIN_CAL.set(1970, 0, 1);
        MIN_DATE = MIN_CAL.getTime();
    }

    private class ValueSet {
        public int value;
        public int pos;

        private ValueSet() {
        }
    }
}

