/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationListener;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Source;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Watcher;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WatcherFactory {
    private static Logger LOGGER = StatusLogger.getLogger();
    private static PluginManager pluginManager = new PluginManager("Watcher");
    private static volatile WatcherFactory factory;
    private final Map<String, PluginType<?>> plugins;

    private WatcherFactory(List<String> list) {
        pluginManager.collectPlugins(list);
        this.plugins = pluginManager.getPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WatcherFactory getInstance(List<String> list) {
        if (factory == null) {
            PluginManager pluginManager = WatcherFactory.pluginManager;
            synchronized (pluginManager) {
                if (factory == null) {
                    factory = new WatcherFactory(list);
                }
            }
        }
        return factory;
    }

    public Watcher newWatcher(Source source, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> list, long l2) {
        if (source.getFile() != null) {
            return new ConfigurationFileWatcher(configuration, reconfigurable, list, l2);
        }
        String string = source.getURI().getScheme();
        PluginType<?> pluginType = this.plugins.get(string);
        if (pluginType != null) {
            return WatcherFactory.instantiate(string, pluginType.getPluginClass(), configuration, reconfigurable, list, l2);
        }
        LOGGER.info("No Watcher plugin is available for protocol '{}'", (Object)string);
        return null;
    }

    public static <T extends Watcher> T instantiate(String string, Class<T> clazz, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> list, long l2) {
        Objects.requireNonNull(clazz, "No class provided");
        try {
            Constructor<T> constructor = clazz.getConstructor(Configuration.class, Reconfigurable.class, List.class, Long.TYPE);
            return (T)((Watcher)constructor.newInstance(configuration, reconfigurable, list, l2));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No valid constructor for Watcher plugin " + string, noSuchMethodException);
        }
        catch (InstantiationException | LinkageError throwable) {
            throw new IllegalArgumentException(throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwables.rethrow(invocationTargetException.getCause());
            throw new InternalError("Unreachable");
        }
    }
}

