/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.internal;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.UrlConnectionFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.AuthorizationProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.internal.Status;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result getInputStream(LastModifiedSource lastModifiedSource, AuthorizationProvider authorizationProvider) {
        Result result = new Result();
        try {
            long l2 = lastModifiedSource.getLastModified();
            HttpURLConnection httpURLConnection = (HttpURLConnection)UrlConnectionFactory.createConnection(lastModifiedSource.getURI().toURL(), l2, SslConfigurationFactory.getSslConfiguration(), authorizationProvider);
            httpURLConnection.connect();
            try {
                int n2 = httpURLConnection.getResponseCode();
                switch (n2) {
                    case 304: {
                        LOGGER.debug("Configuration not modified");
                        result.status = Status.NOT_MODIFIED;
                        Result result2 = result;
                        return result2;
                    }
                    case 404: {
                        LOGGER.debug("Unable to access {}: Not Found", (Object)lastModifiedSource.toString());
                        result.status = Status.NOT_FOUND;
                        Result result3 = result;
                        return result3;
                    }
                    case 200: {
                        InputStream inputStream = httpURLConnection.getInputStream();
                        Object object = null;
                        try {
                            lastModifiedSource.setLastModified(httpURLConnection.getLastModified());
                            LOGGER.debug("Content was modified for {}. previous lastModified: {}, new lastModified: {}", (Object)lastModifiedSource.toString(), (Object)l2, (Object)httpURLConnection.getLastModified());
                            result.status = Status.SUCCESS;
                            result.inputStream = new ByteArrayInputStream(HttpInputStreamUtil.readStream(inputStream));
                            Result result4 = result;
                            return result4;
                        }
                        catch (Throwable throwable) {
                            try {
                                object = throwable;
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                try {
                                    object = httpURLConnection.getErrorStream();
                                    Throwable throwable2 = null;
                                    try {
                                        LOGGER.info("Error accessing configuration at {}: {}", (Object)lastModifiedSource.toString(), (Object)HttpInputStreamUtil.readStream((InputStream)object));
                                        throw new ConfigurationException("Unable to access " + lastModifiedSource.toString(), iOException);
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (object != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    ((InputStream)object).close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable2.addSuppressed(throwable4);
                                                }
                                            } else {
                                                ((InputStream)object).close();
                                            }
                                        }
                                    }
                                }
                                catch (IOException iOException2) {
                                    LOGGER.error("Error accessing configuration at {}: {}", (Object)lastModifiedSource.toString(), (Object)iOException.getMessage());
                                }
                                throw new ConfigurationException("Unable to access " + lastModifiedSource.toString(), iOException);
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                if (object != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                        }
                    }
                    case 401: {
                        throw new ConfigurationException("Authorization failed");
                    }
                }
                if (n2 < 0) {
                    LOGGER.info("Invalid response code returned");
                    throw new ConfigurationException("Unable to access " + lastModifiedSource.toString());
                }
                LOGGER.info("Unexpected response code returned {}", (Object)n2);
                throw new ConfigurationException("Unable to access " + lastModifiedSource.toString());
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (IOException iOException) {
            LOGGER.warn("Error accessing {}: {}", (Object)lastModifiedSource.toString(), (Object)iOException.getMessage());
            throw new ConfigurationException("Unable to access " + lastModifiedSource.toString(), iOException);
        }
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static class Result {
        private InputStream inputStream;
        private Status status;

        public Result() {
        }

        public Result(Status status) {
            this.status = status;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

