/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.CopyOnWrite;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ObjectThreadContextMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ThreadContextMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.ReadOnlyStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.SortedArrayStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class CopyOnWriteSortedArrayThreadContextMap
implements CopyOnWrite,
ObjectThreadContextMap,
ReadOnlyThreadContextMap {
    public static final String INHERITABLE_MAP = "isThreadContextMapInheritable";
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final String PROPERTY_NAME_INITIAL_CAPACITY = "com.contrastsecurity.thirdparty.log4j2.ThreadContext.initial.capacity";
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);
    private static volatile int initialCapacity;
    private static volatile boolean inheritableMap;
    private final ThreadLocal<StringMap> localMap = this.createThreadLocalMap();

    static void init() {
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        initialCapacity = propertiesUtil.getIntegerProperty(PROPERTY_NAME_INITIAL_CAPACITY, 16);
        inheritableMap = propertiesUtil.getBooleanProperty(INHERITABLE_MAP);
    }

    private ThreadLocal<StringMap> createThreadLocalMap() {
        if (inheritableMap) {
            return new InheritableThreadLocal<StringMap>(){

                @Override
                protected StringMap childValue(StringMap stringMap) {
                    if (stringMap == null) {
                        return null;
                    }
                    StringMap stringMap2 = CopyOnWriteSortedArrayThreadContextMap.this.createStringMap(stringMap);
                    stringMap2.freeze();
                    return stringMap2;
                }
            };
        }
        return new ThreadLocal<StringMap>();
    }

    protected StringMap createStringMap() {
        return new SortedArrayStringMap(initialCapacity);
    }

    protected StringMap createStringMap(ReadOnlyStringMap readOnlyStringMap) {
        return new SortedArrayStringMap(readOnlyStringMap);
    }

    @Override
    public void put(String string, String string2) {
        this.putValue(string, string2);
    }

    public void putValue(String string, Object object) {
        StringMap stringMap = this.localMap.get();
        stringMap = stringMap == null ? this.createStringMap() : this.createStringMap(stringMap);
        stringMap.putValue(string, object);
        stringMap.freeze();
        this.localMap.set(stringMap);
    }

    @Override
    public void putAll(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        StringMap stringMap = this.localMap.get();
        stringMap = stringMap == null ? this.createStringMap() : this.createStringMap(stringMap);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringMap.putValue(entry.getKey(), entry.getValue());
        }
        stringMap.freeze();
        this.localMap.set(stringMap);
    }

    @Override
    public <V> void putAllValues(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        StringMap stringMap = this.localMap.get();
        stringMap = stringMap == null ? this.createStringMap() : this.createStringMap(stringMap);
        for (Map.Entry<String, V> entry : map.entrySet()) {
            stringMap.putValue(entry.getKey(), entry.getValue());
        }
        stringMap.freeze();
        this.localMap.set(stringMap);
    }

    @Override
    public String get(String string) {
        return (String)this.getValue(string);
    }

    @Override
    public <V> V getValue(String string) {
        StringMap stringMap = this.localMap.get();
        return stringMap == null ? null : (V)stringMap.getValue(string);
    }

    @Override
    public void remove(String string) {
        StringMap stringMap = this.localMap.get();
        if (stringMap != null) {
            StringMap stringMap2 = this.createStringMap(stringMap);
            stringMap2.remove(string);
            stringMap2.freeze();
            this.localMap.set(stringMap2);
        }
    }

    @Override
    public void removeAll(Iterable<String> iterable) {
        StringMap stringMap = this.localMap.get();
        if (stringMap != null) {
            StringMap stringMap2 = this.createStringMap(stringMap);
            for (String string : iterable) {
                stringMap2.remove(string);
            }
            stringMap2.freeze();
            this.localMap.set(stringMap2);
        }
    }

    @Override
    public void clear() {
        this.localMap.remove();
    }

    @Override
    public boolean containsKey(String string) {
        StringMap stringMap = this.localMap.get();
        return stringMap != null && stringMap.containsKey(string);
    }

    @Override
    public Map<String, String> getCopy() {
        StringMap stringMap = this.localMap.get();
        return stringMap == null ? new HashMap() : stringMap.toMap();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        StringMap stringMap = this.localMap.get();
        return stringMap == null ? EMPTY_CONTEXT_DATA : stringMap;
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        StringMap stringMap = this.localMap.get();
        return stringMap == null ? null : Collections.unmodifiableMap(stringMap.toMap());
    }

    @Override
    public boolean isEmpty() {
        StringMap stringMap = this.localMap.get();
        return stringMap == null || stringMap.isEmpty();
    }

    public String toString() {
        StringMap stringMap = this.localMap.get();
        return stringMap == null ? "{}" : stringMap.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        StringMap stringMap = this.localMap.get();
        n3 = 31 * n3 + (stringMap == null ? 0 : stringMap.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap threadContextMap = (ThreadContextMap)object;
        Map<String, String> map = this.getImmutableMapOrNull();
        Map<String, String> map2 = threadContextMap.getImmutableMapOrNull();
        return Objects.equals(map, map2);
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
        CopyOnWriteSortedArrayThreadContextMap.init();
    }
}

