/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.BiConsumer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.LowLevelLogUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertySource;
import java.util.Collection;
import java.util.Map;

public class EnvironmentPropertySource
implements PropertySource {
    private static final String PREFIX = "LOG4J_";
    private static final int DEFAULT_PRIORITY = 100;

    @Override
    public int getPriority() {
        return 100;
    }

    private void logException(SecurityException securityException) {
        LowLevelLogUtil.logException("The system environment variables are not available to Log4j due to security restrictions: " + securityException, securityException);
    }

    @Override
    public void forEach(BiConsumer<String, String> biConsumer) {
        Map<String, String> map;
        try {
            map = System.getenv();
        }
        catch (SecurityException securityException) {
            this.logException(securityException);
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            if (!string.startsWith(PREFIX)) continue;
            biConsumer.accept(string.substring(PREFIX.length()), entry.getValue());
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> iterable) {
        StringBuilder stringBuilder = new StringBuilder("LOG4J");
        boolean bl = true;
        for (CharSequence charSequence : iterable) {
            bl = false;
            stringBuilder.append('_');
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                stringBuilder.append(Character.toUpperCase(charSequence.charAt(i2)));
            }
        }
        return bl ? null : stringBuilder.toString();
    }

    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getenv().keySet();
        }
        catch (SecurityException securityException) {
            this.logException(securityException);
            return PropertySource.super.getPropertyNames();
        }
    }

    @Override
    public String getProperty(String string) {
        try {
            return System.getenv(string);
        }
        catch (SecurityException securityException) {
            this.logException(securityException);
            return PropertySource.super.getProperty(string);
        }
    }

    @Override
    public boolean containsProperty(String string) {
        try {
            return System.getenv().containsKey(string);
        }
        catch (SecurityException securityException) {
            this.logException(securityException);
            return PropertySource.super.containsProperty(string);
        }
    }
}

