/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.BiConsumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface PropertySource {
    public int getPriority();

    default public void forEach(BiConsumer<String, String> biConsumer) {
    }

    default public Collection<String> getPropertyNames() {
        return Collections.emptySet();
    }

    default public CharSequence getNormalForm(Iterable<? extends CharSequence> iterable) {
        return null;
    }

    default public String getProperty(String string) {
        return null;
    }

    default public boolean containsProperty(String string) {
        return false;
    }

    public static final class Util {
        private static final Pattern PREFIX_PATTERN = Pattern.compile("(^log4j2?[-._/]?|^org\\.apache\\.logging\\.log4j\\.)|(?=AsyncLogger(Config)?\\.)", 2);
        private static final Pattern PROPERTY_TOKENIZER = Pattern.compile("([A-Z]*[a-z0-9]+|[A-Z0-9]+)[-._/]?");
        private static final Map<CharSequence, List<CharSequence>> CACHE = new ConcurrentHashMap<CharSequence, List<CharSequence>>();

        public static List<CharSequence> tokenize(CharSequence charSequence) {
            if (CACHE.containsKey(charSequence)) {
                return CACHE.get(charSequence);
            }
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            int n2 = 0;
            Matcher matcher = PREFIX_PATTERN.matcher(charSequence);
            if (matcher.find(n2)) {
                n2 = matcher.end();
                Matcher matcher2 = PROPERTY_TOKENIZER.matcher(charSequence);
                while (matcher2.find(n2)) {
                    arrayList.add(matcher2.group(1).toLowerCase());
                    n2 = matcher2.end();
                }
            }
            CACHE.put(charSequence, arrayList);
            return arrayList;
        }

        public static CharSequence joinAsCamelCase(Iterable<? extends CharSequence> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (CharSequence charSequence : iterable) {
                if (bl) {
                    stringBuilder.append(charSequence);
                } else {
                    stringBuilder.append(Character.toUpperCase(charSequence.charAt(0)));
                    if (charSequence.length() > 1) {
                        stringBuilder.append(charSequence.subSequence(1, charSequence.length()));
                    }
                }
                bl = false;
            }
            return stringBuilder.toString();
        }

        private Util() {
        }

        static {
            CACHE.put("disableThreadContext", Arrays.asList("disable", "thread", "context"));
            CACHE.put("disableThreadContextStack", Arrays.asList("disable", "thread", "context", "stack"));
            CACHE.put("disableThreadContextMap", Arrays.asList("disable", "thread", "context", "map"));
            CACHE.put("isThreadContextMapInheritable", Arrays.asList("is", "thread", "context", "map", "inheritable"));
        }
    }

    public static class Comparator
    implements Serializable,
    java.util.Comparator<PropertySource> {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(PropertySource propertySource, PropertySource propertySource2) {
            return Integer.compare(Objects.requireNonNull(propertySource).getPriority(), Objects.requireNonNull(propertySource2).getPriority());
        }
    }
}

