/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.BiConsumer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.FilteredObjectInputStream;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.IndexedStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.ReadOnlyStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.TriConsumer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SortedArrayStringMap
implements IndexedStringMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private static final long serialVersionUID = -5748905872274478116L;
    private static final int HASHVAL = 31;
    private static final TriConsumer<String, Object, StringMap> PUT_ALL;
    private static final String[] EMPTY;
    private static final String FROZEN = "Frozen collection cannot be modified";
    private transient String[] keys = EMPTY;
    private transient Object[] values = EMPTY;
    private transient int size;
    private static final Method setObjectInputFilter;
    private static final Method getObjectInputFilter;
    private static final Method newObjectInputFilter;
    private int threshold;
    private boolean immutable;
    private transient boolean iterating;

    public SortedArrayStringMap() {
        this(4);
    }

    public SortedArrayStringMap(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity must be at least zero but was " + n2);
        }
        this.threshold = SortedArrayStringMap.ceilingNextPowerOfTwo(n2 == 0 ? 1 : n2);
    }

    public SortedArrayStringMap(ReadOnlyStringMap readOnlyStringMap) {
        if (readOnlyStringMap instanceof SortedArrayStringMap) {
            this.initFrom0((SortedArrayStringMap)readOnlyStringMap);
        } else if (readOnlyStringMap != null) {
            this.resize(SortedArrayStringMap.ceilingNextPowerOfTwo(readOnlyStringMap.size()));
            readOnlyStringMap.forEach(PUT_ALL, this);
        }
    }

    public SortedArrayStringMap(Map<String, ?> map) {
        this.resize(SortedArrayStringMap.ceilingNextPowerOfTwo(map.size()));
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.putValue(Objects.toString(entry.getKey(), null), entry.getValue());
        }
    }

    private void assertNotFrozen() {
        if (this.immutable) {
            throw new UnsupportedOperationException(FROZEN);
        }
    }

    private void assertNoConcurrentModification() {
        if (this.iterating) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        if (this.keys == EMPTY) {
            return;
        }
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(String string) {
        return this.indexOfKey(string) >= 0;
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Object v2 = this.getValueAt(i2);
            hashMap.put(this.getKeyAt(i2), v2 == null ? null : String.valueOf(v2));
        }
        return hashMap;
    }

    @Override
    public void freeze() {
        this.immutable = true;
    }

    @Override
    public boolean isFrozen() {
        return this.immutable;
    }

    @Override
    public <V> V getValue(String string) {
        int n2 = this.indexOfKey(string);
        if (n2 < 0) {
            return null;
        }
        return (V)this.values[n2];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int indexOfKey(String string) {
        if (this.keys == EMPTY) {
            return -1;
        }
        if (string == null) {
            return this.nullKeyIndex();
        }
        int n2 = this.size > 0 && this.keys[0] == null ? 1 : 0;
        return Arrays.binarySearch(this.keys, n2, this.size, string);
    }

    private int nullKeyIndex() {
        return this.size > 0 && this.keys[0] == null ? 0 : -1;
    }

    @Override
    public void putValue(String string, Object object) {
        int n2;
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        if (this.keys == EMPTY) {
            this.inflateTable(this.threshold);
        }
        if ((n2 = this.indexOfKey(string)) >= 0) {
            this.keys[n2] = string;
            this.values[n2] = object;
        } else {
            this.insertAt(~n2, string, object);
        }
    }

    private void insertAt(int n2, String string, Object object) {
        this.ensureCapacity();
        System.arraycopy(this.keys, n2, this.keys, n2 + 1, this.size - n2);
        System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
        this.keys[n2] = string;
        this.values[n2] = object;
        ++this.size;
    }

    @Override
    public void putAll(ReadOnlyStringMap readOnlyStringMap) {
        if (readOnlyStringMap == this || readOnlyStringMap == null || readOnlyStringMap.isEmpty()) {
            return;
        }
        this.assertNotFrozen();
        this.assertNoConcurrentModification();
        if (readOnlyStringMap instanceof SortedArrayStringMap) {
            if (this.size == 0) {
                this.initFrom0((SortedArrayStringMap)readOnlyStringMap);
            } else {
                this.merge((SortedArrayStringMap)readOnlyStringMap);
            }
        } else if (readOnlyStringMap != null) {
            readOnlyStringMap.forEach(PUT_ALL, this);
        }
    }

    private void initFrom0(SortedArrayStringMap sortedArrayStringMap) {
        if (this.keys.length < sortedArrayStringMap.size) {
            this.keys = new String[sortedArrayStringMap.threshold];
            this.values = new Object[sortedArrayStringMap.threshold];
        }
        System.arraycopy(sortedArrayStringMap.keys, 0, this.keys, 0, sortedArrayStringMap.size);
        System.arraycopy(sortedArrayStringMap.values, 0, this.values, 0, sortedArrayStringMap.size);
        this.size = sortedArrayStringMap.size;
        this.threshold = sortedArrayStringMap.threshold;
    }

    private void merge(SortedArrayStringMap sortedArrayStringMap) {
        String[] stringArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = sortedArrayStringMap.size + this.size;
        this.threshold = SortedArrayStringMap.ceilingNextPowerOfTwo(n2);
        if (this.keys.length < this.threshold) {
            this.keys = new String[this.threshold];
            this.values = new Object[this.threshold];
        }
        boolean bl = true;
        if (sortedArrayStringMap.size() > this.size()) {
            System.arraycopy(stringArray, 0, this.keys, sortedArrayStringMap.size, this.size);
            System.arraycopy(objectArray, 0, this.values, sortedArrayStringMap.size, this.size);
            System.arraycopy(sortedArrayStringMap.keys, 0, this.keys, 0, sortedArrayStringMap.size);
            System.arraycopy(sortedArrayStringMap.values, 0, this.values, 0, sortedArrayStringMap.size);
            this.size = sortedArrayStringMap.size;
            bl = false;
        } else {
            System.arraycopy(stringArray, 0, this.keys, 0, this.size);
            System.arraycopy(objectArray, 0, this.values, 0, this.size);
            System.arraycopy(sortedArrayStringMap.keys, 0, this.keys, this.size, sortedArrayStringMap.size);
            System.arraycopy(sortedArrayStringMap.values, 0, this.values, this.size, sortedArrayStringMap.size);
        }
        for (int i2 = this.size; i2 < n2; ++i2) {
            int n3 = this.indexOfKey(this.keys[i2]);
            if (n3 < 0) {
                this.insertAt(~n3, this.keys[i2], this.values[i2]);
                continue;
            }
            if (!bl) continue;
            this.keys[n3] = this.keys[i2];
            this.values[n3] = this.values[i2];
        }
        Arrays.fill(this.keys, this.size, n2, null);
        Arrays.fill(this.values, this.size, n2, null);
    }

    private void ensureCapacity() {
        if (this.size >= this.threshold) {
            this.resize(this.threshold * 2);
        }
    }

    private void resize(int n2) {
        String[] stringArray = this.keys;
        Object[] objectArray = this.values;
        this.keys = new String[n2];
        this.values = new Object[n2];
        System.arraycopy(stringArray, 0, this.keys, 0, this.size);
        System.arraycopy(objectArray, 0, this.values, 0, this.size);
        this.threshold = n2;
    }

    private void inflateTable(int n2) {
        this.threshold = n2;
        this.keys = new String[n2];
        this.values = new Object[n2];
    }

    @Override
    public void remove(String string) {
        if (this.keys == EMPTY) {
            return;
        }
        int n2 = this.indexOfKey(string);
        if (n2 >= 0) {
            this.assertNotFrozen();
            this.assertNoConcurrentModification();
            System.arraycopy(this.keys, n2 + 1, this.keys, n2, this.size - 1 - n2);
            System.arraycopy(this.values, n2 + 1, this.values, n2, this.size - 1 - n2);
            this.keys[this.size - 1] = null;
            this.values[this.size - 1] = null;
            --this.size;
        }
    }

    @Override
    public String getKeyAt(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return null;
        }
        return this.keys[n2];
    }

    @Override
    public <V> V getValueAt(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return null;
        }
        return (V)this.values[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <V> void forEach(BiConsumer<String, ? super V> biConsumer) {
        this.iterating = true;
        try {
            for (int i2 = 0; i2 < this.size; ++i2) {
                biConsumer.accept(this.keys[i2], this.values[i2]);
            }
        }
        finally {
            this.iterating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, T> void forEach(TriConsumer<String, ? super V, T> triConsumer, T t2) {
        this.iterating = true;
        try {
            for (int i2 = 0; i2 < this.size; ++i2) {
                triConsumer.accept(this.keys[i2], this.values[i2], t2);
            }
        }
        finally {
            this.iterating = false;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SortedArrayStringMap)) {
            return false;
        }
        SortedArrayStringMap sortedArrayStringMap = (SortedArrayStringMap)object;
        if (this.size() != sortedArrayStringMap.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!Objects.equals(this.keys[i2], sortedArrayStringMap.keys[i2])) {
                return false;
            }
            if (Objects.equals(this.values[i2], sortedArrayStringMap.values[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 37;
        n2 = 31 * n2 + this.size;
        n2 = 31 * n2 + SortedArrayStringMap.hashCode(this.keys, this.size);
        n2 = 31 * n2 + SortedArrayStringMap.hashCode(this.values, this.size);
        return n2;
    }

    private static int hashCode(Object[] objectArray, int n2) {
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = 31 * n3 + (objectArray[i2] == null ? 0 : objectArray[i2].hashCode());
        }
        return n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append('{');
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keys[i2]).append('=');
            stringBuilder.append(this.values[i2] == this ? "(this map)" : this.values[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.keys == EMPTY) {
            objectOutputStream.writeInt(SortedArrayStringMap.ceilingNextPowerOfTwo(this.threshold));
        } else {
            objectOutputStream.writeInt(this.keys.length);
        }
        objectOutputStream.writeInt(this.size);
        if (this.size > 0) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                objectOutputStream.writeObject(this.keys[i2]);
                try {
                    objectOutputStream.writeObject(SortedArrayStringMap.marshall(this.values[i2]));
                    continue;
                }
                catch (Exception exception) {
                    this.handleSerializationException(exception, i2, this.keys[i2]);
                    objectOutputStream.writeObject(null);
                }
            }
        }
    }

    private static byte[] marshall(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object unmarshall(byte[] byArray, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objectInputStream2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Collection<String> collection = null;
        if (objectInputStream instanceof FilteredObjectInputStream) {
            collection = ((FilteredObjectInputStream)objectInputStream).getAllowedClasses();
            objectInputStream2 = new FilteredObjectInputStream(byteArrayInputStream, collection);
        } else {
            try {
                object = getObjectInputFilter.invoke((Object)objectInputStream, new Object[0]);
                Object object2 = newObjectInputFilter.invoke(null, object);
                objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
                setObjectInputFilter.invoke((Object)objectInputStream2, object2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new StreamCorruptedException("Unable to set ObjectInputFilter on stream");
            }
        }
        try {
            object = objectInputStream2.readObject();
            return object;
        }
        finally {
            objectInputStream2.close();
        }
    }

    private static int ceilingNextPowerOfTwo(int n2) {
        int n3 = 32;
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!(objectInputStream instanceof FilteredObjectInputStream) && setObjectInputFilter == null) {
            throw new IllegalArgumentException("readObject requires a FilteredObjectInputStream or an ObjectInputStream that accepts an ObjectInputFilter");
        }
        objectInputStream.defaultReadObject();
        this.keys = EMPTY;
        this.values = EMPTY;
        int n2 = objectInputStream.readInt();
        if (n2 < 0) {
            throw new InvalidObjectException("Illegal capacity: " + n2);
        }
        int n3 = objectInputStream.readInt();
        if (n3 < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + n3);
        }
        if (n3 > 0) {
            this.inflateTable(n2);
        } else {
            this.threshold = n2;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.keys[i2] = (String)objectInputStream.readObject();
            try {
                byte[] byArray = (byte[])objectInputStream.readObject();
                this.values[i2] = byArray == null ? null : SortedArrayStringMap.unmarshall(byArray, objectInputStream);
                continue;
            }
            catch (Exception | LinkageError throwable) {
                this.handleSerializationException(throwable, i2, this.keys[i2]);
                this.values[i2] = null;
            }
        }
        this.size = n3;
    }

    private void handleSerializationException(Throwable throwable, int n2, String string) {
        StatusLogger.getLogger().warn("Ignoring {} for key[{}] ('{}')", (Object)String.valueOf(throwable), (Object)n2, (Object)this.keys[n2]);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_6;
        Method method;
        Method method2;
        block5: {
            PUT_ALL = (string, object, stringMap) -> stringMap.putValue((String)string, object);
            EMPTY = Strings.EMPTY_ARRAY;
            Method[] methodArray = ObjectInputStream.class.getMethods();
            method2 = null;
            method = null;
            for (Method method3 : methodArray) {
                if (method3.getName().equals("setObjectInputFilter")) {
                    method2 = method3;
                    continue;
                }
                if (!method3.getName().equals("getObjectInputFilter")) continue;
                method = method3;
            }
            Object var3_4 = null;
            try {
                if (method2 == null) break block5;
                Class<?> clazz = Class.forName("com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.internal.DefaultObjectInputFilter");
                for (Method method4 : methodArray = clazz.getMethods()) {
                    if (!method4.getName().equals("newInstance") || !Modifier.isStatic(method4.getModifiers())) continue;
                    Method method5 = method4;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        newObjectInputFilter = var3_6;
        setObjectInputFilter = method2;
        getObjectInputFilter = method;
    }
}

