/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.BlockNode;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.ItemResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import java.lang.reflect.Array;

public class ForEachNode
extends BlockNode {
    protected String item;
    protected Class itemType;
    protected ExecutableStatement condition;
    private static final int ITERABLE = 0;
    private static final int ARRAY = 1;
    private static final int CHARSEQUENCE = 2;
    private static final int INTEGER = 3;
    private int type = -1;

    public ForEachNode(char[] cArray, int n2, int n3, int n4, int n5, int n6, ParserContext parserContext) {
        super(parserContext);
        this.expr = cArray;
        this.start = n2;
        this.offset = n3;
        this.fields = n6;
        this.handleCond(cArray, this.start, this.offset, this.fields, parserContext);
        this.blockStart = n4;
        this.blockOffset = n5;
        if ((n6 & 0x10) != 0) {
            if (parserContext.isStrictTypeEnforcement() && this.itemType != null) {
                parserContext = parserContext.createSubcontext();
                parserContext.addInput(this.item, this.itemType);
            }
            parserContext.pushVariableScope();
            parserContext.makeVisible(this.item);
            this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(cArray, n4, n5, parserContext);
            parserContext.popVariableScope();
        }
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        ItemResolverFactory.ItemResolver itemResolver = new ItemResolverFactory.ItemResolver(this.item);
        ItemResolverFactory itemResolverFactory = new ItemResolverFactory(itemResolver, new DefaultLocalVariableResolverFactory(variableResolverFactory));
        Object object3 = this.condition.getValue(object, object2, variableResolverFactory);
        if (this.type == -1) {
            this.determineIterType(object3.getClass());
        }
        switch (this.type) {
            case 1: {
                int n2 = Array.getLength(object3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    itemResolver.setValue(Array.get(object3, i2));
                    Object object4 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                    if (!itemResolverFactory.tiltFlag()) continue;
                    return object4;
                }
                break;
            }
            case 2: {
                char[] cArray = object3.toString().toCharArray();
                int n3 = cArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    Character c2 = Character.valueOf(cArray[i3]);
                    itemResolver.setValue(c2);
                    Object object5 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                    if (!itemResolverFactory.tiltFlag()) continue;
                    return object5;
                }
                break;
            }
            case 3: {
                int n4 = (Integer)object3 + 1;
                for (int i4 = 1; i4 != n4; ++i4) {
                    itemResolver.setValue(i4);
                    Object object6 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                    if (!itemResolverFactory.tiltFlag()) continue;
                    return object6;
                }
                break;
            }
            case 0: {
                for (Object t2 : (Iterable)object3) {
                    itemResolver.setValue(t2);
                    Object object7 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                    if (!itemResolverFactory.tiltFlag()) continue;
                    return object7;
                }
                break;
            }
        }
        return null;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        ItemResolverFactory.ItemResolver itemResolver = new ItemResolverFactory.ItemResolver(this.item);
        ItemResolverFactory itemResolverFactory = new ItemResolverFactory(itemResolver, new DefaultLocalVariableResolverFactory(variableResolverFactory));
        Object object3 = MVEL.eval(this.expr, this.start, this.offset, object2, variableResolverFactory);
        if (this.itemType != null && this.itemType.isArray()) {
            this.enforceTypeSafety(this.itemType, ParseTools.getBaseComponentType(object3.getClass()));
        }
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.blockStart, this.blockOffset, this.pCtx);
        if (object3 instanceof Iterable) {
            for (Object t2 : (Iterable)object3) {
                itemResolver.setValue(t2);
                Object object4 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                if (!itemResolverFactory.tiltFlag()) continue;
                return object4;
            }
        } else if (object3 != null && object3.getClass().isArray()) {
            int n2 = Array.getLength(object3);
            for (int i2 = 0; i2 < n2; ++i2) {
                itemResolver.setValue(Array.get(object3, i2));
                Object object5 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                if (!itemResolverFactory.tiltFlag()) continue;
                return object5;
            }
        } else if (object3 instanceof CharSequence) {
            char[] cArray = object3.toString().toCharArray();
            int n3 = cArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Character c2 = Character.valueOf(cArray[i3]);
                itemResolver.setValue(c2);
                Object object6 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                if (!itemResolverFactory.tiltFlag()) continue;
                return object6;
            }
        } else if (object3 instanceof Integer) {
            int n4 = (Integer)object3 + 1;
            for (int i4 = 1; i4 != n4; ++i4) {
                itemResolver.setValue(i4);
                Object object7 = this.compiledBlock.getValue(object, object2, itemResolverFactory);
                if (!itemResolverFactory.tiltFlag()) continue;
                return object7;
            }
        } else {
            throw new CompileException("non-iterable type: " + (object3 != null ? object3.getClass().getName() : "null"), this.expr, this.start);
        }
        return null;
    }

    private void handleCond(char[] cArray, int n2, int n3, int n4, ParserContext parserContext) {
        Object object;
        int n5;
        int n6 = n2 + n3;
        for (n5 = n2; n5 < n6 && cArray[n5] != ':'; ++n5) {
        }
        if (n5 == n6 || cArray[n5] != ':') {
            throw new CompileException("expected : in foreach", cArray, n5);
        }
        this.item = ParseTools.createStringTrimmed(cArray, n2, n5 - n2);
        int n7 = this.item.indexOf(32);
        if (n7 != -1) {
            object = new String(cArray, n2, n7).trim();
            try {
                this.itemType = ParseTools.findClass(null, (String)object, parserContext);
                this.item = new String(cArray, n2 + n7, n5 - n2 - n7).trim();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CompileException("cannot resolve identifier: " + (String)object, cArray, n2);
            }
        }
        this.start = n5 + 1;
        this.offset = n3 - (n5 - n2) - 1;
        if ((n4 & 0x10) != 0) {
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset, parserContext);
            object = this.condition.getKnownEgressType();
            if (this.itemType != null && ((Class)object).isArray()) {
                this.enforceTypeSafety(this.itemType, ParseTools.getBaseComponentType(this.condition.getKnownEgressType()));
            } else if (parserContext.isStrongTyping()) {
                this.determineIterType((Class)object);
            }
        }
    }

    private void determineIterType(Class clazz) {
        if (Iterable.class.isAssignableFrom(clazz)) {
            this.type = 0;
        } else if (clazz.isArray()) {
            this.type = 1;
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            this.type = 2;
        } else if (Integer.class.isAssignableFrom(clazz)) {
            this.type = 3;
        } else {
            throw new CompileException("non-iterable type: " + clazz.getName(), this.expr, this.start);
        }
    }

    private void enforceTypeSafety(Class clazz, Class clazz2) {
        if (!clazz.isAssignableFrom(clazz2) && !DataConversion.canConvert(clazz2, clazz)) {
            throw new CompileException("type mismatch in foreach: expected: " + clazz.getName() + "; but found: " + ParseTools.getBaseComponentType(clazz2), this.expr, this.start);
        }
    }
}

