/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.conversion;

import com.contrastsecurity.thirdparty.org.mvel2.ConversionException;
import com.contrastsecurity.thirdparty.org.mvel2.ConversionHandler;
import com.contrastsecurity.thirdparty.org.mvel2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;

public class BigDecimalCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(Object.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal(String.valueOf(object), MathContext.DECIMAL128);
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public BigDecimal convert(Object object) {
                return (BigDecimal)object;
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal(((BigInteger)object).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(String.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal((String)object, MathContext.DECIMAL128);
            }
        });
        CNV.put(Double.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal((Double)object, MathContext.DECIMAL128);
            }
        });
        CNV.put(Float.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal(((Float)object).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(Short.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal(((Short)object).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(Long.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal(((Long)object).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(Integer.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal(((Integer)object).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(String.class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal((String)object, MathContext.DECIMAL128);
            }
        });
        CNV.put(char[].class, new Converter(){

            public BigDecimal convert(Object object) {
                return new BigDecimal((char[])object, MathContext.DECIMAL128);
            }
        });
    }
}

