/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.optimizers.dynamic;

import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.Accessor;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.OptimizerFactory;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.dynamic.DynamicAccessor;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicCollectionAccessor
implements DynamicAccessor {
    private ParserContext pCtx;
    private Object rootObject;
    private Class colType;
    private char[] property;
    private int start;
    private int offset;
    private long stamp;
    private int type;
    private int runcount;
    private boolean opt = false;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicCollectionAccessor(ParserContext parserContext, Object object, Class clazz, char[] cArray, int n2, int n3, int n4, Accessor accessor) {
        this.pCtx = parserContext;
        this.rootObject = object;
        this.colType = clazz;
        this._safeAccessor = this._accessor = accessor;
        this.type = n4;
        this.property = cArray;
        this.start = n2;
        this.offset = n3;
        this.stamp = System.currentTimeMillis();
    }

    public Object getValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(this.pCtx, object, object2, variableResolverFactory);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        return this._accessor.getValue(object, object2, variableResolverFactory);
    }

    public Object setValue(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object object3) {
        ++this.runcount;
        return this._accessor.setValue(object, object2, variableResolverFactory, object3);
    }

    private Object optimize(ParserContext parserContext, Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        this._accessor = OptimizerFactory.getAccessorCompiler("ASM").optimizeCollection(parserContext, this.rootObject, this.colType, this.property, this.start, this.offset, object, object2, variableResolverFactory);
        return this._accessor.getValue(object, object2, variableResolverFactory);
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public long getStamp() {
        return this.stamp;
    }

    public int getRuncount() {
        return this.runcount;
    }

    public Class getKnownEgressType() {
        return this.colType;
    }
}

