/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis;

import com.contrastsecurity.thirdparty.org.objectweb.asm.Type;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.IincInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LabelNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.MethodInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.VarInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Interpreter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Value;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame<V extends Value> {
    private static final int MAX_STACK_SIZE = 65536;
    private V returnValue;
    private V[] values;
    private int numLocals;
    private int numStack;
    private int maxStack;

    public Frame(int n2, int n3) {
        this.values = new Value[n2 + (n3 >= 0 ? n3 : 4)];
        this.numLocals = n2;
        this.numStack = 0;
        this.maxStack = n3 >= 0 ? n3 : 65536;
    }

    public Frame(Frame<? extends V> frame) {
        this(frame.numLocals, frame.values.length - frame.numLocals);
        this.init(frame);
    }

    public Frame<V> init(Frame<? extends V> frame) {
        this.returnValue = frame.returnValue;
        if (this.values.length < frame.values.length) {
            this.values = (Value[])frame.values.clone();
        } else {
            System.arraycopy(frame.values, 0, this.values, 0, frame.values.length);
        }
        this.numLocals = frame.numLocals;
        this.numStack = frame.numStack;
        this.maxStack = frame.maxStack;
        return this;
    }

    public void initJumpTarget(int n2, LabelNode labelNode) {
    }

    public void setReturn(V v2) {
        this.returnValue = v2;
    }

    public int getLocals() {
        return this.numLocals;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public V getLocal(int n2) {
        if (n2 >= this.numLocals) {
            throw new IndexOutOfBoundsException("Trying to get an inexistant local variable " + n2);
        }
        return this.values[n2];
    }

    public void setLocal(int n2, V v2) {
        if (n2 >= this.numLocals) {
            throw new IndexOutOfBoundsException("Trying to set an inexistant local variable " + n2);
        }
        this.values[n2] = v2;
    }

    public int getStackSize() {
        return this.numStack;
    }

    public V getStack(int n2) {
        return this.values[this.numLocals + n2];
    }

    public void setStack(int n2, V v2) {
        this.values[this.numLocals + n2] = v2;
    }

    public void clearStack() {
        this.numStack = 0;
    }

    public V pop() {
        if (this.numStack == 0) {
            throw new IndexOutOfBoundsException("Cannot pop operand off an empty stack.");
        }
        return this.values[this.numLocals + --this.numStack];
    }

    public void push(V v2) {
        if (this.numLocals + this.numStack >= this.values.length) {
            if (this.numLocals + this.numStack >= this.maxStack) {
                throw new IndexOutOfBoundsException("Insufficient maximum stack size.");
            }
            V[] VArray = this.values;
            this.values = new Value[2 * this.values.length];
            System.arraycopy(VArray, 0, this.values, 0, VArray.length);
        }
        this.values[this.numLocals + this.numStack++] = v2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AbstractInsnNode abstractInsnNode, Interpreter<V> interpreter) throws AnalyzerException {
        switch (abstractInsnNode.getOpcode()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.push(interpreter.copyOperation(abstractInsnNode, this.getLocal(((VarInsnNode)abstractInsnNode).var)));
                return;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                V v2;
                Object e2 = interpreter.copyOperation(abstractInsnNode, this.pop());
                int n2 = ((VarInsnNode)abstractInsnNode).var;
                this.setLocal(n2, e2);
                if (e2.getSize() == 2) {
                    this.setLocal(n2 + 1, interpreter.newEmptyValue(n2 + 1));
                }
                if (n2 <= 0 || (v2 = this.getLocal(n2 - 1)) == null || v2.getSize() != 2) return;
                this.setLocal(n2 - 1, interpreter.newEmptyValue(n2 - 1));
                return;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                V v3 = this.pop();
                V v4 = this.pop();
                V v5 = this.pop();
                interpreter.ternaryOperation(abstractInsnNode, v5, v4, v3);
                return;
            }
            case 87: {
                if (this.pop().getSize() != 2) return;
                throw new AnalyzerException(abstractInsnNode, "Illegal use of POP");
            }
            case 88: {
                if (this.pop().getSize() != 1 || this.pop().getSize() == 1) return;
                throw new AnalyzerException(abstractInsnNode, "Illegal use of POP2");
            }
            case 89: {
                V v6 = this.pop();
                if (v6.getSize() != 1) {
                    throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP");
                }
                this.push(v6);
                this.push(interpreter.copyOperation(abstractInsnNode, v6));
                return;
            }
            case 90: {
                V v7 = this.pop();
                V v8 = this.pop();
                if (v7.getSize() != 1 || v8.getSize() != 1) {
                    throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP_X1");
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v7));
                this.push(v8);
                this.push(v7);
                return;
            }
            case 91: {
                V v9 = this.pop();
                if (v9.getSize() == 1 && this.executeDupX2(abstractInsnNode, v9, interpreter)) return;
                throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP_X2");
            }
            case 92: {
                V v10 = this.pop();
                if (v10.getSize() == 1) {
                    V v11 = this.pop();
                    if (v11.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2");
                    this.push(v11);
                    this.push(v10);
                    this.push(interpreter.copyOperation(abstractInsnNode, v11));
                    this.push(interpreter.copyOperation(abstractInsnNode, v10));
                    return;
                }
                this.push(v10);
                this.push(interpreter.copyOperation(abstractInsnNode, v10));
                return;
            }
            case 93: {
                V v12 = this.pop();
                if (v12.getSize() == 1) {
                    V v13;
                    V v14 = this.pop();
                    if (v14.getSize() != 1 || (v13 = this.pop()).getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X1");
                    this.push(interpreter.copyOperation(abstractInsnNode, v14));
                    this.push(interpreter.copyOperation(abstractInsnNode, v12));
                    this.push(v13);
                    this.push(v14);
                    this.push(v12);
                    return;
                }
                V v15 = this.pop();
                if (v15.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X1");
                this.push(interpreter.copyOperation(abstractInsnNode, v12));
                this.push(v15);
                this.push(v12);
                return;
            }
            case 94: {
                V v16 = this.pop();
                if (v16.getSize() == 1) {
                    V v17 = this.pop();
                    if (v17.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X2");
                    V v18 = this.pop();
                    if (v18.getSize() == 1) {
                        V v19 = this.pop();
                        if (v19.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X2");
                        this.push(interpreter.copyOperation(abstractInsnNode, v17));
                        this.push(interpreter.copyOperation(abstractInsnNode, v16));
                        this.push(v19);
                        this.push(v18);
                        this.push(v17);
                        this.push(v16);
                        return;
                    }
                    this.push(interpreter.copyOperation(abstractInsnNode, v17));
                    this.push(interpreter.copyOperation(abstractInsnNode, v16));
                    this.push(v18);
                    this.push(v17);
                    this.push(v16);
                    return;
                }
                if (this.executeDupX2(abstractInsnNode, v16, interpreter)) return;
                throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X2");
            }
            case 95: {
                V v20 = this.pop();
                V v21 = this.pop();
                if (v21.getSize() != 1 || v20.getSize() != 1) {
                    throw new AnalyzerException(abstractInsnNode, "Illegal use of SWAP");
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v20));
                this.push(interpreter.copyOperation(abstractInsnNode, v21));
                return;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                V v22 = this.pop();
                V v23 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v23, v22));
                return;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 132: {
                int n3 = ((IincInsnNode)abstractInsnNode).var;
                this.setLocal(n3, interpreter.unaryOperation(abstractInsnNode, this.getLocal(n3)));
                return;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                V v24 = this.pop();
                V v25 = this.pop();
                interpreter.binaryOperation(abstractInsnNode, v25, v24);
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 169: {
                return;
            }
            case 170: 
            case 171: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                V v26 = this.pop();
                interpreter.unaryOperation(abstractInsnNode, v26);
                interpreter.returnOperation(abstractInsnNode, v26, this.returnValue);
                return;
            }
            case 177: {
                if (this.returnValue == null) return;
                throw new AnalyzerException(abstractInsnNode, "Incompatible return type");
            }
            case 178: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 179: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 180: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.executeInvokeInsn(abstractInsnNode, ((MethodInsnNode)abstractInsnNode).desc, interpreter);
                return;
            }
            case 186: {
                this.executeInvokeInsn(abstractInsnNode, ((InvokeDynamicInsnNode)abstractInsnNode).desc, interpreter);
                return;
            }
            case 187: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 188: 
            case 189: 
            case 190: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 191: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 192: 
            case 193: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 194: 
            case 195: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 197: {
                ArrayList<V> arrayList = new ArrayList<V>();
                for (int i2 = ((MultiANewArrayInsnNode)abstractInsnNode).dims; i2 > 0; --i2) {
                    arrayList.add(0, this.pop());
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 198: 
            case 199: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            default: {
                throw new AnalyzerException(abstractInsnNode, "Illegal opcode " + abstractInsnNode.getOpcode());
            }
        }
    }

    private boolean executeDupX2(AbstractInsnNode abstractInsnNode, V v2, Interpreter<V> interpreter) throws AnalyzerException {
        V v3 = this.pop();
        if (v3.getSize() == 1) {
            V v4 = this.pop();
            if (v4.getSize() == 1) {
                this.push(interpreter.copyOperation(abstractInsnNode, v2));
                this.push(v4);
                this.push(v3);
                this.push(v2);
                return true;
            }
        } else {
            this.push(interpreter.copyOperation(abstractInsnNode, v2));
            this.push(v3);
            this.push(v2);
            return true;
        }
        return false;
    }

    private void executeInvokeInsn(AbstractInsnNode abstractInsnNode, String string, Interpreter<V> interpreter) throws AnalyzerException {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (int i2 = Type.getArgumentTypes(string).length; i2 > 0; --i2) {
            arrayList.add(0, this.pop());
        }
        if (abstractInsnNode.getOpcode() != 184 && abstractInsnNode.getOpcode() != 186) {
            arrayList.add(0, this.pop());
        }
        if (Type.getReturnType(string) == Type.VOID_TYPE) {
            interpreter.naryOperation(abstractInsnNode, arrayList);
        } else {
            this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
        }
    }

    public boolean merge(Frame<? extends V> frame, Interpreter<V> interpreter) throws AnalyzerException {
        if (this.numStack != frame.numStack) {
            throw new AnalyzerException(null, "Incompatible stack heights");
        }
        boolean bl = false;
        for (int i2 = 0; i2 < this.numLocals + this.numStack; ++i2) {
            V v2 = interpreter.merge(this.values[i2], frame.values[i2]);
            if (v2.equals(this.values[i2])) continue;
            this.values[i2] = v2;
            bl = true;
        }
        return bl;
    }

    public boolean merge(Frame<? extends V> frame, boolean[] blArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.numLocals; ++i2) {
            if (blArray[i2] || this.values[i2].equals(frame.values[i2])) continue;
            this.values[i2] = frame.values[i2];
            bl = true;
        }
        return bl;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < this.getLocals(); ++n2) {
            stringBuilder.append(this.getLocal(n2));
        }
        stringBuilder.append(' ');
        for (n2 = 0; n2 < this.getStackSize(); ++n2) {
            stringBuilder.append(this.getStack(n2).toString());
        }
        return stringBuilder.toString();
    }
}

