/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.util;

import com.contrastsecurity.thirdparty.org.objectweb.asm.Attribute;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ConstantDynamic;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Handle;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Label;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Type;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypePath;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.ASMifierSupport;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.Printer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ASMifier
extends Printer {
    private static final String USAGE = "Prints the ASM code to generate the given class.\nUsage: ASMifier [-nodebug] <fully qualified class name or class file name>";
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;
    private static final int ACCESS_MODULE = 0x200000;
    private static final String ANNOTATION_VISITOR = "annotationVisitor";
    private static final String ANNOTATION_VISITOR0 = "annotationVisitor0 = ";
    private static final String COMMA = "\", \"";
    private static final String END_ARRAY = " });\n";
    private static final String END_PARAMETERS = ");\n\n";
    private static final String NEW_OBJECT_ARRAY = ", new Object[] {";
    private static final String VISIT_END = ".visitEnd();\n";
    private static final List<String> FRAME_TYPES = Collections.unmodifiableList(Arrays.asList("Opcodes.TOP", "Opcodes.INTEGER", "Opcodes.FLOAT", "Opcodes.DOUBLE", "Opcodes.LONG", "Opcodes.NULL", "Opcodes.UNINITIALIZED_THIS"));
    private static final Map<Integer, String> CLASS_VERSIONS;
    protected final String name;
    protected final int id;
    protected Map<Label, String> labelNames;

    public ASMifier() {
        this(589824, "classWriter", 0);
        if (this.getClass() != ASMifier.class) {
            throw new IllegalStateException();
        }
    }

    protected ASMifier(int n2, String string, int n3) {
        super(n2);
        this.name = string;
        this.id = n3;
    }

    public static void main(String[] stringArray) throws IOException {
        ASMifier.main(stringArray, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    static void main(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) throws IOException {
        ASMifier.main(stringArray, USAGE, new ASMifier(), printWriter, printWriter2);
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        String string4;
        if (string == null) {
            string4 = "module-info";
        } else {
            int n4 = string.lastIndexOf(47);
            if (n4 == -1) {
                string4 = string;
            } else {
                this.text.add("package asm." + string.substring(0, n4).replace('/', '.') + ";\n");
                string4 = string.substring(n4 + 1).replaceAll("[-\\(\\)]", "_");
            }
        }
        this.text.add("import org.objectweb.asm.AnnotationVisitor;\n");
        this.text.add("import org.objectweb.asm.Attribute;\n");
        this.text.add("import org.objectweb.asm.ClassReader;\n");
        this.text.add("import org.objectweb.asm.ClassWriter;\n");
        this.text.add("import org.objectweb.asm.ConstantDynamic;\n");
        this.text.add("import org.objectweb.asm.FieldVisitor;\n");
        this.text.add("import org.objectweb.asm.Handle;\n");
        this.text.add("import org.objectweb.asm.Label;\n");
        this.text.add("import org.objectweb.asm.MethodVisitor;\n");
        this.text.add("import org.objectweb.asm.Opcodes;\n");
        this.text.add("import org.objectweb.asm.RecordComponentVisitor;\n");
        this.text.add("import org.objectweb.asm.Type;\n");
        this.text.add("import org.objectweb.asm.TypePath;\n");
        this.text.add("public class " + string4 + "Dump implements Opcodes {\n\n");
        this.text.add("public static byte[] dump () throws Exception {\n\n");
        this.text.add("ClassWriter classWriter = new ClassWriter(0);\n");
        this.text.add("FieldVisitor fieldVisitor;\n");
        this.text.add("RecordComponentVisitor recordComponentVisitor;\n");
        this.text.add("MethodVisitor methodVisitor;\n");
        this.text.add("AnnotationVisitor annotationVisitor0;\n\n");
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visit(");
        String string5 = CLASS_VERSIONS.get(n2);
        if (string5 != null) {
            this.stringBuilder.append(string5);
        } else {
            this.stringBuilder.append(n2);
        }
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n3 | 0x40000);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append("new String[] {");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.stringBuilder.append(i2 == 0 ? " " : ", ");
                this.appendConstant(stringArray[i2]);
            }
            this.stringBuilder.append(" }");
        } else {
            this.stringBuilder.append("null");
        }
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitSource(String string, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitSource(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitModule(String string, int n2, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("ModuleVisitor moduleVisitor = classWriter.visitModule(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n2 | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("moduleVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitNestHost(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitNestHost(");
        this.appendConstant(string);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitOuterClass(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitClassAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public ASMifier visitClassTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitClassAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitNestMember(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitNestMember(");
        this.appendConstant(string);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPermittedSubclass(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitPermittedSubclass(");
        this.appendConstant(string);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitInnerClass(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n2 | 0x100000);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitRecordComponent(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("recordComponentVisitor = classWriter.visitRecordComponent(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("recordComponentVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public ASMifier visitField(int n2, String string, String string2, String string3, Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("fieldVisitor = classWriter.visitField(");
        this.appendAccessFlags(n2 | 0x80000);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.appendConstant(object);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("fieldVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public ASMifier visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("methodVisitor = classWriter.visitMethod(");
        this.appendAccessFlags(n2);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append("new String[] {");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.stringBuilder.append(i2 == 0 ? " " : ", ");
                this.appendConstant(stringArray[i2]);
            }
            this.stringBuilder.append(" }");
        } else {
            this.stringBuilder.append("null");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier("methodVisitor", 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitClassEnd() {
        this.text.add("classWriter.visitEnd();\n\n");
        this.text.add("return classWriter.toByteArray();\n");
        this.text.add("}\n");
        this.text.add("}\n");
    }

    public void visitMainClass(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitMainClass(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPackage(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitPackage(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitRequire(String string, int n2, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitRequire(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n2 | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitExport(String string, int n2, String ... stringArray) {
        this.visitExportOrOpen("moduleVisitor.visitExport(", string, n2, stringArray);
    }

    public void visitOpen(String string, int n2, String ... stringArray) {
        this.visitExportOrOpen("moduleVisitor.visitOpen(", string, n2, stringArray);
    }

    private void visitExportOrOpen(String string, String string2, int n2, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(string);
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n2 | 0x200000);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(", new String[] {");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.stringBuilder.append(i2 == 0 ? " " : ", ");
                this.appendConstant(stringArray[i2]);
            }
            this.stringBuilder.append(" }");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitUse(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitUse(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitProvide(String string, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitProvide(");
        this.appendConstant(string);
        this.stringBuilder.append(",  new String[] {");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.stringBuilder.append(i2 == 0 ? " " : ", ");
            this.appendConstant(stringArray[i2]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitModuleEnd() {
        this.text.add("moduleVisitor.visitEnd();\n");
    }

    public void visit(String string, Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visit(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(object);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitEnum(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visitEnum(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitAnnotation(String string, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitAnnotation(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public ASMifier visitArray(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitArray(");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitAnnotationEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitRecordComponentAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public ASMifier visitRecordComponentTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitRecordComponentAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitRecordComponentEnd() {
        this.visitMemberEnd();
    }

    public ASMifier visitFieldAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public ASMifier visitFieldTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitFieldEnd() {
        this.visitMemberEnd();
    }

    public void visitParameter(String string, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitParameter(");
        ASMifier.appendString(this.stringBuilder, string);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(n2);
        this.text.add(this.stringBuilder.append(");\n").toString());
    }

    public ASMifier visitAnnotationDefault() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitAnnotationDefault();\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public ASMifier visitMethodAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public ASMifier visitMethodTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public ASMifier visitAnnotableParameterCount(int n2, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitAnnotableParameterCount(").append(n2).append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    public ASMifier visitParameterAnnotation(int n2, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitParameterAnnotation(").append(n2).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitMethodAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitCode() {
        this.text.add(this.name + ".visitCode();\n");
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        this.stringBuilder.setLength(0);
        switch (n2) {
            case -1: 
            case 0: {
                this.declareFrameTypes(n3, objectArray);
                this.declareFrameTypes(n4, objectArray2);
                if (n2 == -1) {
                    this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_NEW, ");
                } else {
                    this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_FULL, ");
                }
                this.stringBuilder.append(n3).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(n3, objectArray);
                this.stringBuilder.append("}, ").append(n4).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(n4, objectArray2);
                this.stringBuilder.append('}');
                break;
            }
            case 1: {
                this.declareFrameTypes(n3, objectArray);
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_APPEND,").append(n3).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(n3, objectArray);
                this.stringBuilder.append("}, 0, null");
                break;
            }
            case 2: {
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_CHOP,").append(n3).append(", null, 0, null");
                break;
            }
            case 3: {
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_SAME, 0, null, 0, null");
                break;
            }
            case 4: {
                this.declareFrameTypes(1, objectArray2);
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_SAME1, 0, null, 1, new Object[] {");
                this.appendFrameTypes(1, objectArray2);
                this.stringBuilder.append('}');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInsn(int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitInsn(").append(OPCODES[n2]).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIntInsn(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitIntInsn(").append(OPCODES[n2]).append(", ").append(n2 == 188 ? TYPES[n3] : Integer.toString(n3)).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitVarInsn(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitVarInsn(").append(OPCODES[n2]).append(", ").append(n3).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTypeInsn(int n2, String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitTypeInsn(").append(OPCODES[n2]).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitFieldInsn(").append(OPCODES[n2]).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMethodInsn(").append(OPCODES[n2]).append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.stringBuilder.append(bl ? "true" : "false");
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitInvokeDynamicInsn(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(handle);
        this.stringBuilder.append(", new Object[]{");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.appendConstant(objectArray[i2]);
            if (i2 == objectArray.length - 1) continue;
            this.stringBuilder.append(", ");
        }
        this.stringBuilder.append("});\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitJumpInsn(int n2, Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitJumpInsn(").append(OPCODES[n2]).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLabel(Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitLabel(");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLdcInsn(Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLdcInsn(");
        this.appendConstant(object);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIincInsn(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitIincInsn(").append(n2).append(", ").append(n3).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label ... labelArray) {
        this.stringBuilder.setLength(0);
        for (Label label2 : labelArray) {
            this.declareLabel(label2);
        }
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitTableSwitchInsn(").append(n2).append(", ").append(n3).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(", new Label[] {");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.stringBuilder.append(i2 == 0 ? " " : ", ");
            this.appendLabel(labelArray[i2]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n2;
        this.stringBuilder.setLength(0);
        for (Label label2 : labelArray) {
            this.declareLabel(label2);
        }
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.stringBuilder.append(", new int[] {");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.stringBuilder.append(n2 == 0 ? " " : ", ").append(nArray[n2]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (n2 = 0; n2 < labelArray.length; ++n2) {
            this.stringBuilder.append(n2 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n2]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMultiANewArrayInsn(");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(n2).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitInsnAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation("visitInsnAnnotation", n2, typePath, string, bl);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.declareLabel(label2);
        this.declareLabel(label3);
        this.stringBuilder.append(this.name).append(".visitTryCatchBlock(");
        this.appendLabel(label);
        this.stringBuilder.append(", ");
        this.appendLabel(label2);
        this.stringBuilder.append(", ");
        this.appendLabel(label3);
        this.stringBuilder.append(", ");
        this.appendConstant(string);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitTryCatchAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation("visitTryCatchAnnotation", n2, typePath, string, bl);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLocalVariable(");
        this.appendConstant(string);
        this.stringBuilder.append(", ");
        this.appendConstant(string2);
        this.stringBuilder.append(", ");
        this.appendConstant(string3);
        this.stringBuilder.append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(", ");
        this.appendLabel(label2);
        this.stringBuilder.append(", ").append(n2).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitLocalVariableAnnotation(int n2, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        int n3;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitLocalVariableAnnotation(").append(n2);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.stringBuilder.append("new Label[] {");
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.stringBuilder.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n3]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (n3 = 0; n3 < labelArray2.length; ++n3) {
            this.stringBuilder.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray2[n3]);
        }
        this.stringBuilder.append(" }, new int[] {");
        for (n3 = 0; n3 < nArray.length; ++n3) {
            this.stringBuilder.append(n3 == 0 ? " " : ", ").append(nArray[n3]);
        }
        this.stringBuilder.append(" }, ");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitLineNumber(int n2, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLineNumber(").append(n2).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMaxs(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMaxs(").append(n2).append(", ").append(n3).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodEnd() {
        this.visitMemberEnd();
    }

    public ASMifier visitAnnotation(String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitAnnotation(");
        this.appendConstant(string);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public ASMifier visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation("visitTypeAnnotation", n2, typePath, string, bl);
    }

    public ASMifier visitTypeAnnotation(String string, int n2, TypePath typePath, String string2, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append('.').append(string).append('(').append(n2);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.appendConstant(string2);
        this.stringBuilder.append(", ").append(bl).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier aSMifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(aSMifier.getText());
        this.text.add("}\n");
        return aSMifier;
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// ATTRIBUTE ").append(attribute.type).append('\n');
        if (attribute instanceof ASMifierSupport) {
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            this.stringBuilder.append("{\n");
            ((ASMifierSupport)((Object)attribute)).asmify(this.stringBuilder, "attribute", this.labelNames);
            this.stringBuilder.append(this.name).append(".visitAttribute(attribute);\n");
            this.stringBuilder.append("}\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void visitMemberEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    protected ASMifier createASMifier(String string, int n2) {
        return new ASMifier(this.api, string, n2);
    }

    private void appendAccessFlags(int n2) {
        boolean bl = true;
        if ((n2 & 1) != 0) {
            this.stringBuilder.append("ACC_PUBLIC");
            bl = false;
        }
        if ((n2 & 2) != 0) {
            this.stringBuilder.append("ACC_PRIVATE");
            bl = false;
        }
        if ((n2 & 4) != 0) {
            this.stringBuilder.append("ACC_PROTECTED");
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_FINAL");
            bl = false;
        }
        if ((n2 & 8) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STATIC");
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n2 & 0x40000) == 0) {
                if ((n2 & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_SYNCHRONIZED");
                } else {
                    this.stringBuilder.append("ACC_TRANSITIVE");
                }
            } else {
                this.stringBuilder.append("ACC_SUPER");
            }
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n2 & 0x80000) == 0) {
                if ((n2 & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_BRIDGE");
                } else {
                    this.stringBuilder.append("ACC_STATIC_PHASE");
                }
            } else {
                this.stringBuilder.append("ACC_VOLATILE");
            }
            bl = false;
        }
        if ((n2 & 0x80) != 0 && (n2 & 0xC0000) == 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_VARARGS");
            bl = false;
        }
        if ((n2 & 0x80) != 0 && (n2 & 0x80000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_TRANSIENT");
            bl = false;
        }
        if ((n2 & 0x100) != 0 && (n2 & 0xC0000) == 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_NATIVE");
            bl = false;
        }
        if ((n2 & 0x4000) != 0 && (n2 & 0x1C0000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ENUM");
            bl = false;
        }
        if ((n2 & 0x2000) != 0 && (n2 & 0x140000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ANNOTATION");
            bl = false;
        }
        if ((n2 & 0x400) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ABSTRACT");
            bl = false;
        }
        if ((n2 & 0x200) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_INTERFACE");
            bl = false;
        }
        if ((n2 & 0x800) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STRICT");
            bl = false;
        }
        if ((n2 & 0x1000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_SYNTHETIC");
            bl = false;
        }
        if ((n2 & 0x20000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_DEPRECATED");
            bl = false;
        }
        if ((n2 & 0x10000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_RECORD");
            bl = false;
        }
        if ((n2 & 0x8000) != 0) {
            if (!bl) {
                this.stringBuilder.append(" | ");
            }
            if ((n2 & 0x40000) == 0) {
                this.stringBuilder.append("ACC_MANDATED");
            } else {
                this.stringBuilder.append("ACC_MODULE");
            }
            bl = false;
        }
        if (bl) {
            this.stringBuilder.append('0');
        }
    }

    protected void appendConstant(Object object) {
        if (object == null) {
            this.stringBuilder.append("null");
        } else if (object instanceof String) {
            ASMifier.appendString(this.stringBuilder, (String)object);
        } else if (object instanceof Type) {
            this.stringBuilder.append("Type.getType(\"");
            this.stringBuilder.append(((Type)object).getDescriptor());
            this.stringBuilder.append("\")");
        } else if (object instanceof Handle) {
            this.stringBuilder.append("new Handle(");
            Handle handle = (Handle)object;
            this.stringBuilder.append("Opcodes.").append(HANDLE_TAG[handle.getTag()]).append(", \"");
            this.stringBuilder.append(handle.getOwner()).append(COMMA);
            this.stringBuilder.append(handle.getName()).append(COMMA);
            this.stringBuilder.append(handle.getDesc()).append("\", ");
            this.stringBuilder.append(handle.isInterface()).append(')');
        } else if (object instanceof ConstantDynamic) {
            this.stringBuilder.append("new ConstantDynamic(\"");
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            this.stringBuilder.append(constantDynamic.getName()).append(COMMA);
            this.stringBuilder.append(constantDynamic.getDescriptor()).append("\", ");
            this.appendConstant(constantDynamic.getBootstrapMethod());
            this.stringBuilder.append(NEW_OBJECT_ARRAY);
            int n2 = constantDynamic.getBootstrapMethodArgumentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.appendConstant(constantDynamic.getBootstrapMethodArgument(i2));
                if (i2 == n2 - 1) continue;
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append("})");
        } else if (object instanceof Byte) {
            this.stringBuilder.append("new Byte((byte)").append(object).append(')');
        } else if (object instanceof Boolean) {
            this.stringBuilder.append((Boolean)object != false ? "Boolean.TRUE" : "Boolean.FALSE");
        } else if (object instanceof Short) {
            this.stringBuilder.append("new Short((short)").append(object).append(')');
        } else if (object instanceof Character) {
            this.stringBuilder.append("new Character((char)").append((int)((Character)object).charValue()).append(')');
        } else if (object instanceof Integer) {
            this.stringBuilder.append("new Integer(").append(object).append(')');
        } else if (object instanceof Float) {
            this.stringBuilder.append("new Float(\"").append(object).append("\")");
        } else if (object instanceof Long) {
            this.stringBuilder.append("new Long(").append(object).append("L)");
        } else if (object instanceof Double) {
            this.stringBuilder.append("new Double(\"").append(object).append("\")");
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.stringBuilder.append("new byte[] {");
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                this.stringBuilder.append(i3 == 0 ? "" : ",").append(byArray[i3]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            this.stringBuilder.append("new boolean[] {");
            for (int i4 = 0; i4 < blArray.length; ++i4) {
                this.stringBuilder.append(i4 == 0 ? "" : ",").append(blArray[i4]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            this.stringBuilder.append("new short[] {");
            for (int i5 = 0; i5 < sArray.length; ++i5) {
                this.stringBuilder.append(i5 == 0 ? "" : ",").append("(short)").append(sArray[i5]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.stringBuilder.append("new char[] {");
            for (int i6 = 0; i6 < cArray.length; ++i6) {
                this.stringBuilder.append(i6 == 0 ? "" : ",").append("(char)").append((int)cArray[i6]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.stringBuilder.append("new int[] {");
            for (int i7 = 0; i7 < nArray.length; ++i7) {
                this.stringBuilder.append(i7 == 0 ? "" : ",").append(nArray[i7]);
            }
            this.stringBuilder.append('}');
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.stringBuilder.append("new long[] {");
            for (int i8 = 0; i8 < lArray.length; ++i8) {
                this.stringBuilder.append(i8 == 0 ? "" : ",").append(lArray[i8]).append('L');
            }
            this.stringBuilder.append('}');
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            this.stringBuilder.append("new float[] {");
            for (int i9 = 0; i9 < fArray.length; ++i9) {
                this.stringBuilder.append(i9 == 0 ? "" : ",").append(fArray[i9]).append('f');
            }
            this.stringBuilder.append('}');
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            this.stringBuilder.append("new double[] {");
            for (int i10 = 0; i10 < dArray.length; ++i10) {
                this.stringBuilder.append(i10 == 0 ? "" : ",").append(dArray[i10]).append('d');
            }
            this.stringBuilder.append('}');
        }
    }

    private void declareFrameTypes(int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(objectArray[i2] instanceof Label)) continue;
            this.declareLabel((Label)objectArray[i2]);
        }
    }

    private void appendFrameTypes(int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                this.stringBuilder.append(", ");
            }
            if (objectArray[i2] instanceof String) {
                this.appendConstant(objectArray[i2]);
                continue;
            }
            if (objectArray[i2] instanceof Integer) {
                this.stringBuilder.append(FRAME_TYPES.get((Integer)objectArray[i2]));
                continue;
            }
            this.appendLabel((Label)objectArray[i2]);
        }
    }

    protected void declareLabel(Label label) {
        String string;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((string = this.labelNames.get(label)) == null) {
            string = "label" + this.labelNames.size();
            this.labelNames.put(label, string);
            this.stringBuilder.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    protected void appendLabel(Label label) {
        this.stringBuilder.append(this.labelNames.get(label));
    }

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(196653, "V1_1");
        hashMap.put(46, "V1_2");
        hashMap.put(47, "V1_3");
        hashMap.put(48, "V1_4");
        hashMap.put(49, "V1_5");
        hashMap.put(50, "V1_6");
        hashMap.put(51, "V1_7");
        hashMap.put(52, "V1_8");
        hashMap.put(53, "V9");
        hashMap.put(54, "V10");
        hashMap.put(55, "V11");
        hashMap.put(56, "V12");
        hashMap.put(57, "V13");
        hashMap.put(58, "V14");
        hashMap.put(59, "V15");
        hashMap.put(60, "V16");
        hashMap.put(61, "V17");
        hashMap.put(62, "V18");
        hashMap.put(63, "V19");
        hashMap.put(64, "V20");
        CLASS_VERSIONS = Collections.unmodifiableMap(hashMap);
    }
}

